/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmusv.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Zustand der Eingangsfrequenz.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AttUsvEingangsFrequenzZustand extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	Daten sind nicht ermittelbar (ist KEIN Fehler).
	<p>
	Wird gesetzt, wenn der entsprechende Wert nicht ermittelbar ist (z.B. kein Sensor).
	</p>
	*/
	public static final AttUsvEingangsFrequenzZustand ZUSTAND_1N_NICHT_ERMITTELBAR = new AttUsvEingangsFrequenzZustand("nicht ermittelbar", 		Byte
	.valueOf("-1"));

	/**
	Eingangsfrequenz ist in Ordnung.
	<p>
	
	</p>
	*/
	public static final AttUsvEingangsFrequenzZustand ZUSTAND_0_IN_ORDNUNG = new AttUsvEingangsFrequenzZustand("in Ordnung", 		Byte
	.valueOf("0"));

	/**
	Eingangsfrequenz ist zu hoch.
	<p>
	
	</p>
	*/
	public static final AttUsvEingangsFrequenzZustand ZUSTAND_1_HOCH = new AttUsvEingangsFrequenzZustand("Hoch", 		Byte
	.valueOf("1"));

	/**
	Eingangsfrequenz ist zu niedrig.
	<p>
	
	</p>
	*/
	public static final AttUsvEingangsFrequenzZustand ZUSTAND_2_NIEDRIG = new AttUsvEingangsFrequenzZustand("Niedrig", 		Byte
	.valueOf("2"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttUsvEingangsFrequenzZustand getZustand(final 		Byte
	 value) {
		for (AttUsvEingangsFrequenzZustand e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttUsvEingangsFrequenzZustand getZustand(final String value) {
		for (AttUsvEingangsFrequenzZustand e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttUsvEingangsFrequenzZustand> getZustaende() {
		List<AttUsvEingangsFrequenzZustand> list = new ArrayList<AttUsvEingangsFrequenzZustand>();
		list.add(ZUSTAND_1N_NICHT_ERMITTELBAR);
		list.add(ZUSTAND_0_IN_ORDNUNG);
		list.add(ZUSTAND_1_HOCH);
		list.add(ZUSTAND_2_NIEDRIG);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut Eingangsfrequenzzustand.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttUsvEingangsFrequenzZustand(final 		Byte
	 value) {
		super(value);
	}
	
	private AttUsvEingangsFrequenzZustand(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
