/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmusv.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Zustand der Notstromversorgung.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AttUsvZustandNotStrom extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	Daten sind nicht ermittelbar (ist KEIN Fehler).
	<p>
	Wird gesetzt, wenn der entsprechende Wert nicht ermittelbar ist (z.B. kein Sensor).
	</p>
	*/
	public static final AttUsvZustandNotStrom ZUSTAND_1N_NICHT_ERMITTELBAR = new AttUsvZustandNotStrom("nicht ermittelbar", 		Byte
	.valueOf("-1"));

	/**
	Notstromversorgung ist in Ordnung, aber passiv.
	<p>
	
	</p>
	*/
	public static final AttUsvZustandNotStrom ZUSTAND_0_IN_ORDNUNG_PASSIV = new AttUsvZustandNotStrom("in Ordnung, passiv", 		Byte
	.valueOf("0"));

	/**
	Notstromversorgung ist in Ordnung, passiv.
	<p>
	
	</p>
	*/
	public static final AttUsvZustandNotStrom ZUSTAND_1_IN_ORDNUNG_AKTIV = new AttUsvZustandNotStrom("in Ordnung, aktiv", 		Byte
	.valueOf("1"));

	/**
	Notstromversorgung ist gestört.
	<p>
	
	</p>
	*/
	public static final AttUsvZustandNotStrom ZUSTAND_2_STOERUNG = new AttUsvZustandNotStrom("Störung", 		Byte
	.valueOf("2"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttUsvZustandNotStrom getZustand(final 		Byte
	 value) {
		for (AttUsvZustandNotStrom e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttUsvZustandNotStrom getZustand(final String value) {
		for (AttUsvZustandNotStrom e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttUsvZustandNotStrom> getZustaende() {
		List<AttUsvZustandNotStrom> list = new ArrayList<AttUsvZustandNotStrom>();
		list.add(ZUSTAND_1N_NICHT_ERMITTELBAR);
		list.add(ZUSTAND_0_IN_ORDNUNG_PASSIV);
		list.add(ZUSTAND_1_IN_ORDNUNG_AKTIV);
		list.add(ZUSTAND_2_STOERUNG);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut ZustandNotStrom.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttUsvZustandNotStrom(final 		Byte
	 value) {
		super(value);
	}
	
	private AttUsvZustandNotStrom(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
