/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmusv.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
USV-Zustand.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class OdUsvZustand extends AbstractOnlineDatensatz<OdUsvZustand.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Zustand,
				};
			}
	
			/**
			 * Zustand.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Zustand = new Aspekte("Zustand", "asp.zustand");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmusv.attribute.AttUsvUsvZustand
				 _usvZustand
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmusv.attribute.AttUsvBatterieZustand
				 _batterieZustand
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmusv.attribute.AttUsvKommunikationsZustand
				 _kommunikationsZustand
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmusv.attribute.AttUsvEingangsFrequenzZustand
				 _eingangsFrequenzZustand
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmusv.attribute.AttUsvWechselSpannung
				 _wechselSpannung
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmusv.attribute.AttUsvZustandPhase
				 _zustandPhase1
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmusv.attribute.AttUsvZustandPhase
				 _zustandPhase2
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmusv.attribute.AttUsvZustandPhase
				 _zustandPhase3
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmusv.attribute.AttUsvZustandNotStrom
				 _zustandNotStrom
				;
		
			/**
			UsvZustand.
			<p>
			
			</p>
			
			@return der Wert von UsvZustand.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmusv.attribute.AttUsvUsvZustand
				 getUsvZustand() {
				return _usvZustand;
			}
		
			/**
			UsvZustand.
			<p>
			
			</p>
			
			@param _usvZustand der neue Wert von UsvZustand.
			*/
			public void setUsvZustand(de.bsvrz.sys.funclib.bitctrl.modell.tmusv.attribute.AttUsvUsvZustand
			 _usvZustand) {
				this._usvZustand = _usvZustand;
			}
		
			/**
			BatterieZustand.
			<p>
			
			</p>
			
			@return der Wert von BatterieZustand.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmusv.attribute.AttUsvBatterieZustand
				 getBatterieZustand() {
				return _batterieZustand;
			}
		
			/**
			BatterieZustand.
			<p>
			
			</p>
			
			@param _batterieZustand der neue Wert von BatterieZustand.
			*/
			public void setBatterieZustand(de.bsvrz.sys.funclib.bitctrl.modell.tmusv.attribute.AttUsvBatterieZustand
			 _batterieZustand) {
				this._batterieZustand = _batterieZustand;
			}
		
			/**
			KommunikationsZustand.
			<p>
			
			</p>
			
			@return der Wert von KommunikationsZustand.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmusv.attribute.AttUsvKommunikationsZustand
				 getKommunikationsZustand() {
				return _kommunikationsZustand;
			}
		
			/**
			KommunikationsZustand.
			<p>
			
			</p>
			
			@param _kommunikationsZustand der neue Wert von KommunikationsZustand.
			*/
			public void setKommunikationsZustand(de.bsvrz.sys.funclib.bitctrl.modell.tmusv.attribute.AttUsvKommunikationsZustand
			 _kommunikationsZustand) {
				this._kommunikationsZustand = _kommunikationsZustand;
			}
		
			/**
			EingangsFrequenzZustand.
			<p>
			
			</p>
			
			@return der Wert von EingangsFrequenzZustand.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmusv.attribute.AttUsvEingangsFrequenzZustand
				 getEingangsFrequenzZustand() {
				return _eingangsFrequenzZustand;
			}
		
			/**
			EingangsFrequenzZustand.
			<p>
			
			</p>
			
			@param _eingangsFrequenzZustand der neue Wert von EingangsFrequenzZustand.
			*/
			public void setEingangsFrequenzZustand(de.bsvrz.sys.funclib.bitctrl.modell.tmusv.attribute.AttUsvEingangsFrequenzZustand
			 _eingangsFrequenzZustand) {
				this._eingangsFrequenzZustand = _eingangsFrequenzZustand;
			}
		
			/**
			WechselSpannung.
			<p>
			
			</p>
			
			@return der Wert von WechselSpannung.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmusv.attribute.AttUsvWechselSpannung
				 getWechselSpannung() {
				return _wechselSpannung;
			}
		
			/**
			WechselSpannung.
			<p>
			
			</p>
			
			@param _wechselSpannung der neue Wert von WechselSpannung.
			*/
			public void setWechselSpannung(de.bsvrz.sys.funclib.bitctrl.modell.tmusv.attribute.AttUsvWechselSpannung
			 _wechselSpannung) {
				this._wechselSpannung = _wechselSpannung;
			}
		
			/**
			ZustandPhase1.
			<p>
			
			</p>
			
			@return der Wert von ZustandPhase1.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmusv.attribute.AttUsvZustandPhase
				 getZustandPhase1() {
				return _zustandPhase1;
			}
		
			/**
			ZustandPhase1.
			<p>
			
			</p>
			
			@param _zustandPhase1 der neue Wert von ZustandPhase1.
			*/
			public void setZustandPhase1(de.bsvrz.sys.funclib.bitctrl.modell.tmusv.attribute.AttUsvZustandPhase
			 _zustandPhase1) {
				this._zustandPhase1 = _zustandPhase1;
			}
		
			/**
			ZustandPhase2.
			<p>
			
			</p>
			
			@return der Wert von ZustandPhase2.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmusv.attribute.AttUsvZustandPhase
				 getZustandPhase2() {
				return _zustandPhase2;
			}
		
			/**
			ZustandPhase2.
			<p>
			
			</p>
			
			@param _zustandPhase2 der neue Wert von ZustandPhase2.
			*/
			public void setZustandPhase2(de.bsvrz.sys.funclib.bitctrl.modell.tmusv.attribute.AttUsvZustandPhase
			 _zustandPhase2) {
				this._zustandPhase2 = _zustandPhase2;
			}
		
			/**
			ZustandPhase3.
			<p>
			
			</p>
			
			@return der Wert von ZustandPhase3.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmusv.attribute.AttUsvZustandPhase
				 getZustandPhase3() {
				return _zustandPhase3;
			}
		
			/**
			ZustandPhase3.
			<p>
			
			</p>
			
			@param _zustandPhase3 der neue Wert von ZustandPhase3.
			*/
			public void setZustandPhase3(de.bsvrz.sys.funclib.bitctrl.modell.tmusv.attribute.AttUsvZustandPhase
			 _zustandPhase3) {
				this._zustandPhase3 = _zustandPhase3;
			}
		
			/**
			ZustandNotStrom.
			<p>
			
			</p>
			
			@return der Wert von ZustandNotStrom.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmusv.attribute.AttUsvZustandNotStrom
				 getZustandNotStrom() {
				return _zustandNotStrom;
			}
		
			/**
			ZustandNotStrom.
			<p>
			
			</p>
			
			@param _zustandNotStrom der neue Wert von ZustandNotStrom.
			*/
			public void setZustandNotStrom(de.bsvrz.sys.funclib.bitctrl.modell.tmusv.attribute.AttUsvZustandNotStrom
			 _zustandNotStrom) {
				this._zustandNotStrom = _zustandNotStrom;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getUsvZustand() != null) {
		                if (getUsvZustand().isZustand()) {
		                    datum.getUnscaledValue("UsvZustand").setText(getUsvZustand().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("UsvZustand").set(getUsvZustand().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getBatterieZustand() != null) {
		                if (getBatterieZustand().isZustand()) {
		                    datum.getUnscaledValue("BatterieZustand").setText(getBatterieZustand().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("BatterieZustand").set(getBatterieZustand().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getKommunikationsZustand() != null) {
		                if (getKommunikationsZustand().isZustand()) {
		                    datum.getUnscaledValue("KommunikationsZustand").setText(getKommunikationsZustand().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("KommunikationsZustand").set(getKommunikationsZustand().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getEingangsFrequenzZustand() != null) {
		                if (getEingangsFrequenzZustand().isZustand()) {
		                    datum.getUnscaledValue("EingangsFrequenzZustand").setText(getEingangsFrequenzZustand().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("EingangsFrequenzZustand").set(getEingangsFrequenzZustand().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getWechselSpannung() != null) {
		                if (getWechselSpannung().isZustand()) {
		                    datum.getUnscaledValue("WechselSpannung").setText(getWechselSpannung().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("WechselSpannung").set(getWechselSpannung().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getZustandPhase1() != null) {
		                if (getZustandPhase1().isZustand()) {
		                    datum.getUnscaledValue("ZustandPhase1").setText(getZustandPhase1().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("ZustandPhase1").set(getZustandPhase1().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getZustandPhase2() != null) {
		                if (getZustandPhase2().isZustand()) {
		                    datum.getUnscaledValue("ZustandPhase2").setText(getZustandPhase2().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("ZustandPhase2").set(getZustandPhase2().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getZustandPhase3() != null) {
		                if (getZustandPhase3().isZustand()) {
		                    datum.getUnscaledValue("ZustandPhase3").setText(getZustandPhase3().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("ZustandPhase3").set(getZustandPhase3().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getZustandNotStrom() != null) {
		                if (getZustandNotStrom().isZustand()) {
		                    datum.getUnscaledValue("ZustandNotStrom").setText(getZustandNotStrom().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("ZustandNotStrom").set(getZustandNotStrom().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("UsvZustand").isState()) {
								setUsvZustand(de.bsvrz.sys.funclib.bitctrl.modell.tmusv.attribute.AttUsvUsvZustand
								.getZustand(daten.getScaledValue("UsvZustand").getText()));
							} else {
							setUsvZustand(new de.bsvrz.sys.funclib.bitctrl.modell.tmusv.attribute.AttUsvUsvZustand
							(daten.
								getUnscaledValue
							("UsvZustand").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("BatterieZustand").isState()) {
								setBatterieZustand(de.bsvrz.sys.funclib.bitctrl.modell.tmusv.attribute.AttUsvBatterieZustand
								.getZustand(daten.getScaledValue("BatterieZustand").getText()));
							} else {
							setBatterieZustand(new de.bsvrz.sys.funclib.bitctrl.modell.tmusv.attribute.AttUsvBatterieZustand
							(daten.
								getUnscaledValue
							("BatterieZustand").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("KommunikationsZustand").isState()) {
								setKommunikationsZustand(de.bsvrz.sys.funclib.bitctrl.modell.tmusv.attribute.AttUsvKommunikationsZustand
								.getZustand(daten.getScaledValue("KommunikationsZustand").getText()));
							} else {
							setKommunikationsZustand(new de.bsvrz.sys.funclib.bitctrl.modell.tmusv.attribute.AttUsvKommunikationsZustand
							(daten.
								getUnscaledValue
							("KommunikationsZustand").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("EingangsFrequenzZustand").isState()) {
								setEingangsFrequenzZustand(de.bsvrz.sys.funclib.bitctrl.modell.tmusv.attribute.AttUsvEingangsFrequenzZustand
								.getZustand(daten.getScaledValue("EingangsFrequenzZustand").getText()));
							} else {
							setEingangsFrequenzZustand(new de.bsvrz.sys.funclib.bitctrl.modell.tmusv.attribute.AttUsvEingangsFrequenzZustand
							(daten.
								getUnscaledValue
							("EingangsFrequenzZustand").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("WechselSpannung").isState()) {
								setWechselSpannung(de.bsvrz.sys.funclib.bitctrl.modell.tmusv.attribute.AttUsvWechselSpannung
								.getZustand(daten.getScaledValue("WechselSpannung").getText()));
							} else {
							setWechselSpannung(new de.bsvrz.sys.funclib.bitctrl.modell.tmusv.attribute.AttUsvWechselSpannung
							(daten.
								getUnscaledValue
							("WechselSpannung").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("ZustandPhase1").isState()) {
								setZustandPhase1(de.bsvrz.sys.funclib.bitctrl.modell.tmusv.attribute.AttUsvZustandPhase
								.getZustand(daten.getScaledValue("ZustandPhase1").getText()));
							} else {
							setZustandPhase1(new de.bsvrz.sys.funclib.bitctrl.modell.tmusv.attribute.AttUsvZustandPhase
							(daten.
								getUnscaledValue
							("ZustandPhase1").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("ZustandPhase2").isState()) {
								setZustandPhase2(de.bsvrz.sys.funclib.bitctrl.modell.tmusv.attribute.AttUsvZustandPhase
								.getZustand(daten.getScaledValue("ZustandPhase2").getText()));
							} else {
							setZustandPhase2(new de.bsvrz.sys.funclib.bitctrl.modell.tmusv.attribute.AttUsvZustandPhase
							(daten.
								getUnscaledValue
							("ZustandPhase2").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("ZustandPhase3").isState()) {
								setZustandPhase3(de.bsvrz.sys.funclib.bitctrl.modell.tmusv.attribute.AttUsvZustandPhase
								.getZustand(daten.getScaledValue("ZustandPhase3").getText()));
							} else {
							setZustandPhase3(new de.bsvrz.sys.funclib.bitctrl.modell.tmusv.attribute.AttUsvZustandPhase
							(daten.
								getUnscaledValue
							("ZustandPhase3").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("ZustandNotStrom").isState()) {
								setZustandNotStrom(de.bsvrz.sys.funclib.bitctrl.modell.tmusv.attribute.AttUsvZustandNotStrom
								.getZustand(daten.getScaledValue("ZustandNotStrom").getText()));
							} else {
							setZustandNotStrom(new de.bsvrz.sys.funclib.bitctrl.modell.tmusv.attribute.AttUsvZustandNotStrom
							(daten.
								getUnscaledValue
							("ZustandNotStrom").
									byteValue
							()));
							}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setUsvZustand(getUsvZustand());
							klon.setBatterieZustand(getBatterieZustand());
							klon.setKommunikationsZustand(getKommunikationsZustand());
							klon.setEingangsFrequenzZustand(getEingangsFrequenzZustand());
							klon.setWechselSpannung(getWechselSpannung());
							klon.setZustandPhase1(getZustandPhase1());
							klon.setZustandPhase2(getZustandPhase2());
							klon.setZustandPhase3(getZustandPhase3());
							klon.setZustandNotStrom(getZustandNotStrom());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.usvZustand";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdUsvZustand(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
