/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Angabe der Stationierung gemäß ASB für ein
					Linienobjekt.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 17
 */
public class AtlAsbStationierung implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttOffsetMeter
			 _offset
			;
			private String
			 _anfangsKnoten
			= new String
			()
			;
			private String
			 _endKnoten
			= new String
			()
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttOffsetMeter
			 _anfang
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttOffsetMeter
			 _ende
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsRichtung
			 _verkehrsRichtung
			;
	
		/**
		Abstand des ASB-Stationierungs-Punktes vom
								Anfang des Linienobjekts.
		<p>
		
		</p>
		
		@return der Wert von Offset.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttOffsetMeter
			 getOffset() {
			return _offset;
		}
	
		/**
		Abstand des ASB-Stationierungs-Punktes vom
								Anfang des Linienobjekts.
		<p>
		
		</p>
		
		@param _offset der neue Wert von Offset.
		*/
		public void setOffset(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttOffsetMeter
		 _offset) {
			this._offset = _offset;
		}
	
		/**
		Anfangsknoten mit eindeutiger Kennung
								(Anfangsnullpunkt) des Teilabschnittes oder
								Astes. Die Nullpunktbezeichung hat die Form
								TTTTnnnB, wobei TTTT die vierstellige
								TK25-Blattnummer und nnn die dreistellige
								laufende Nummer ist, die zusammen die bundesweit
								eindeutige Netzknotennummer darstellen. Durch
								die Kennung B (ein Zeichen) wird zusätzlich der
								Nullpunkt des Abschnitts oder Astes eindeutig
								festgelegt. Eine nicht vorhandene Kennung wird
								als o(hne) eingetragen.
		<p>
		
		</p>
		
		@return der Wert von AnfangsKnoten.
		*/
			public String
			 getAnfangsKnoten() {
			return _anfangsKnoten;
		}
	
		/**
		Anfangsknoten mit eindeutiger Kennung
								(Anfangsnullpunkt) des Teilabschnittes oder
								Astes. Die Nullpunktbezeichung hat die Form
								TTTTnnnB, wobei TTTT die vierstellige
								TK25-Blattnummer und nnn die dreistellige
								laufende Nummer ist, die zusammen die bundesweit
								eindeutige Netzknotennummer darstellen. Durch
								die Kennung B (ein Zeichen) wird zusätzlich der
								Nullpunkt des Abschnitts oder Astes eindeutig
								festgelegt. Eine nicht vorhandene Kennung wird
								als o(hne) eingetragen.
		<p>
		
		</p>
		
		@param _anfangsKnoten der neue Wert von AnfangsKnoten.
		*/
		public void setAnfangsKnoten(String
		 _anfangsKnoten) {
			if (_anfangsKnoten.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._anfangsKnoten = _anfangsKnoten;
		}
	
		/**
		Endknoten mit eindeutiger Kennung (Endnullpunkt)
								des Teilabschnittes oder Astes. Die
								Nullpunktbezeichung hat die Form TTTTnnnB, wobei
								TTTT die vierstellige TK25-Blattnummer und nnn
								die dreistellige laufende Nummer ist, die
								zusammen die bundesweit eindeutige
								Netzknotennummer darstellen. Durch die Kennung B
								(ein Zeichen) wird zusätzlich der Nullpunkt des
								Abschnitts oder Astes eindeutig festgelegt. Eine
								nicht vorhandene Kennung wird als o(hne)
								eingetragen.
		<p>
		
		</p>
		
		@return der Wert von EndKnoten.
		*/
			public String
			 getEndKnoten() {
			return _endKnoten;
		}
	
		/**
		Endknoten mit eindeutiger Kennung (Endnullpunkt)
								des Teilabschnittes oder Astes. Die
								Nullpunktbezeichung hat die Form TTTTnnnB, wobei
								TTTT die vierstellige TK25-Blattnummer und nnn
								die dreistellige laufende Nummer ist, die
								zusammen die bundesweit eindeutige
								Netzknotennummer darstellen. Durch die Kennung B
								(ein Zeichen) wird zusätzlich der Nullpunkt des
								Abschnitts oder Astes eindeutig festgelegt. Eine
								nicht vorhandene Kennung wird als o(hne)
								eingetragen.
		<p>
		
		</p>
		
		@param _endKnoten der neue Wert von EndKnoten.
		*/
		public void setEndKnoten(String
		 _endKnoten) {
			if (_endKnoten.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._endKnoten = _endKnoten;
		}
	
		/**
		Anfangsstationierung. Stationierungsangabe in
								Metern relativ zum Abschnitt oder Ast.
		<p>
		
		</p>
		
		@return der Wert von Anfang.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttOffsetMeter
			 getAnfang() {
			return _anfang;
		}
	
		/**
		Anfangsstationierung. Stationierungsangabe in
								Metern relativ zum Abschnitt oder Ast.
		<p>
		
		</p>
		
		@param _anfang der neue Wert von Anfang.
		*/
		public void setAnfang(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttOffsetMeter
		 _anfang) {
			this._anfang = _anfang;
		}
	
		/**
		Endstationierung. Stationierungsangabe in Metern
								relativ zum Abschnitt oder Ast.
		<p>
		
		</p>
		
		@return der Wert von Ende.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttOffsetMeter
			 getEnde() {
			return _ende;
		}
	
		/**
		Endstationierung. Stationierungsangabe in Metern
								relativ zum Abschnitt oder Ast.
		<p>
		
		</p>
		
		@param _ende der neue Wert von Ende.
		*/
		public void setEnde(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttOffsetMeter
		 _ende) {
			this._ende = _ende;
		}
	
		/**
		Angabe des Richtungsbezugs der ASB-Stationierung
								relativ zur Richtung des Straßensegments.
		<p>
		
		</p>
		
		@return der Wert von VerkehrsRichtung.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsRichtung
			 getVerkehrsRichtung() {
			return _verkehrsRichtung;
		}
	
		/**
		Angabe des Richtungsbezugs der ASB-Stationierung
								relativ zur Richtung des Straßensegments.
		<p>
		
		</p>
		
		@param _verkehrsRichtung der neue Wert von VerkehrsRichtung.
		*/
		public void setVerkehrsRichtung(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsRichtung
		 _verkehrsRichtung) {
			this._verkehrsRichtung = _verkehrsRichtung;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getOffset() != null) {
	                if (getOffset().isZustand()) {
	                    datum.getUnscaledValue("Offset").setText(getOffset().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Offset").set(getOffset().getValue());
	                }
				}
				// ZeichenkettenAttributTyp
				if (getAnfangsKnoten() != null) {
					datum.getTextValue("AnfangsKnoten").setText(getAnfangsKnoten());
				}
				// ZeichenkettenAttributTyp
				if (getEndKnoten() != null) {
					datum.getTextValue("EndKnoten").setText(getEndKnoten());
				}
				// GanzzahlAttributTyp
				if (getAnfang() != null) {
	                if (getAnfang().isZustand()) {
	                    datum.getUnscaledValue("Anfang").setText(getAnfang().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Anfang").set(getAnfang().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getEnde() != null) {
	                if (getEnde().isZustand()) {
	                    datum.getUnscaledValue("Ende").setText(getEnde().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Ende").set(getEnde().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getVerkehrsRichtung() != null) {
	                if (getVerkehrsRichtung().isZustand()) {
	                    datum.getUnscaledValue("VerkehrsRichtung").setText(getVerkehrsRichtung().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("VerkehrsRichtung").set(getVerkehrsRichtung().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Offset").isState()) {
							setOffset(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttOffsetMeter
							.getZustand(daten.getScaledValue("Offset").getText()));
						} else {
						setOffset(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttOffsetMeter
						(daten.
							getUnscaledValue
						("Offset").
								longValue
						()));
						}
				// ZeichenkettenAttributTyp
					setAnfangsKnoten(daten.getTextValue("AnfangsKnoten").getText());
				// ZeichenkettenAttributTyp
					setEndKnoten(daten.getTextValue("EndKnoten").getText());
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Anfang").isState()) {
							setAnfang(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttOffsetMeter
							.getZustand(daten.getScaledValue("Anfang").getText()));
						} else {
						setAnfang(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttOffsetMeter
						(daten.
							getUnscaledValue
						("Anfang").
								longValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Ende").isState()) {
							setEnde(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttOffsetMeter
							.getZustand(daten.getScaledValue("Ende").getText()));
						} else {
						setEnde(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttOffsetMeter
						(daten.
							getUnscaledValue
						("Ende").
								longValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("VerkehrsRichtung").isState()) {
							setVerkehrsRichtung(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsRichtung
							.getZustand(daten.getScaledValue("VerkehrsRichtung").getText()));
						} else {
						setVerkehrsRichtung(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsRichtung
						(daten.
							getUnscaledValue
						("VerkehrsRichtung").
								byteValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlAsbStationierung clone() {
		AtlAsbStationierung klon = new AtlAsbStationierung();
		
						klon.setOffset(getOffset());
						klon.setAnfangsKnoten(getAnfangsKnoten());
						klon.setEndKnoten(getEndKnoten());
						klon.setAnfang(getAnfang());
						klon.setEnde(getEnde());
						klon.setVerkehrsRichtung(getVerkehrsRichtung());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
