/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Ergebnisse der Baustellensimulation.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlBaustellenSimulation implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	Zeitstempel
			 _startZeit
			;
			private 	RelativerZeitstempel
			 _dauer
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 _maxLaenge
			;
			private 	Zeitstempel
			 _maxLaengeZeit
			;
			private 	RelativerZeitstempel
			 _verlustZeit
			;
	
		/**
		Zeitpunkt des Staubeginns.
		<p>
		
		</p>
		
		@return der Wert von StartZeit.
		*/
			public 	Zeitstempel
			 getStartZeit() {
			return _startZeit;
		}
	
		/**
		Zeitpunkt des Staubeginns.
		<p>
		
		</p>
		
		@param _startZeit der neue Wert von StartZeit.
		*/
		public void setStartZeit(	Zeitstempel
		 _startZeit) {
			this._startZeit = _startZeit;
		}
	
		/**
		Dauer des Staus.
		<p>
		
		</p>
		
		@return der Wert von Dauer.
		*/
			public 	RelativerZeitstempel
			 getDauer() {
			return _dauer;
		}
	
		/**
		Dauer des Staus.
		<p>
		
		</p>
		
		@param _dauer der neue Wert von Dauer.
		*/
		public void setDauer(	RelativerZeitstempel
		 _dauer) {
			this._dauer = _dauer;
		}
	
		/**
		Maximale Staulänge.
		<p>
		
		</p>
		
		@return der Wert von MaxLaenge.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 getMaxLaenge() {
			return _maxLaenge;
		}
	
		/**
		Maximale Staulänge.
		<p>
		
		</p>
		
		@param _maxLaenge der neue Wert von MaxLaenge.
		*/
		public void setMaxLaenge(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
		 _maxLaenge) {
			this._maxLaenge = _maxLaenge;
		}
	
		/**
		Zeitpunkt der maximalen Staulänge.
		<p>
		
		</p>
		
		@return der Wert von MaxLaengeZeit.
		*/
			public 	Zeitstempel
			 getMaxLaengeZeit() {
			return _maxLaengeZeit;
		}
	
		/**
		Zeitpunkt der maximalen Staulänge.
		<p>
		
		</p>
		
		@param _maxLaengeZeit der neue Wert von MaxLaengeZeit.
		*/
		public void setMaxLaengeZeit(	Zeitstempel
		 _maxLaengeZeit) {
			this._maxLaengeZeit = _maxLaengeZeit;
		}
	
		/**
		Maximale Verlustzeit durch den Stau.
		<p>
		
		</p>
		
		@return der Wert von VerlustZeit.
		*/
			public 	RelativerZeitstempel
			 getVerlustZeit() {
			return _verlustZeit;
		}
	
		/**
		Maximale Verlustzeit durch den Stau.
		<p>
		
		</p>
		
		@param _verlustZeit der neue Wert von VerlustZeit.
		*/
		public void setVerlustZeit(	RelativerZeitstempel
		 _verlustZeit) {
			this._verlustZeit = _verlustZeit;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeitstempelAttributTyp
					datum.getTimeValue("StartZeit").setMillis(getStartZeit().getTime());
				// ZeitstempelAttributTyp
					datum.getTimeValue("Dauer").setMillis(getDauer().getTime());
				// GanzzahlAttributTyp
				if (getMaxLaenge() != null) {
	                if (getMaxLaenge().isZustand()) {
	                    datum.getUnscaledValue("MaxLänge").setText(getMaxLaenge().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("MaxLänge").set(getMaxLaenge().getValue());
	                }
				}
				// ZeitstempelAttributTyp
					datum.getTimeValue("MaxLängeZeit").setMillis(getMaxLaengeZeit().getTime());
				// ZeitstempelAttributTyp
					datum.getTimeValue("VerlustZeit").setMillis(getVerlustZeit().getTime());
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeitstempelAttributTyp
					setStartZeit(new
						Zeitstempel
						(daten.getTimeValue("StartZeit").getMillis()));
				// ZeitstempelAttributTyp
					setDauer(new
						RelativerZeitstempel
						(daten.getTimeValue("Dauer").getMillis()));
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("MaxLänge").isState()) {
							setMaxLaenge(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
							.getZustand(daten.getScaledValue("MaxLänge").getText()));
						} else {
						setMaxLaenge(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
						(daten.
							getUnscaledValue
						("MaxLänge").
								longValue
						()));
						}
				// ZeitstempelAttributTyp
					setMaxLaengeZeit(new
						Zeitstempel
						(daten.getTimeValue("MaxLängeZeit").getMillis()));
				// ZeitstempelAttributTyp
					setVerlustZeit(new
						RelativerZeitstempel
						(daten.getTimeValue("VerlustZeit").getMillis()));
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlBaustellenSimulation clone() {
		AtlBaustellenSimulation klon = new AtlBaustellenSimulation();
		
						klon.setStartZeit(getStartZeit());
						klon.setDauer(getDauer());
						klon.setMaxLaenge(getMaxLaenge());
						klon.setMaxLaengeZeit(getMaxLaengeZeit());
						klon.setVerlustZeit(getVerlustZeit());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
