/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Attributliste mit den Betriebskilometerangaben für ein STS und der betroffenen Straße.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 53
 */
public class AtlBetriebsKilometerStrasse implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.GesamtStrasse
			 _gesamtStrasse
			;
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlBetriebsKilometerGenau
			> _betriebsKilometer = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlBetriebsKilometerGenau
			>(0, true);
	
		/**
		Referenz auf die GesamtStraße, für die die BKM-Angaben gültig sind.
		<p>
		
		</p>
		
		@return der Wert von GesamtStrasse.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.GesamtStrasse
			 getGesamtStrasse() {
			return _gesamtStrasse;
		}
	
		/**
		Referenz auf die GesamtStraße, für die die BKM-Angaben gültig sind.
		<p>
		
		</p>
		
		@param _gesamtStrasse der neue Wert von GesamtStrasse.
		*/
		public void setGesamtStrasse(	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.GesamtStrasse
		 _gesamtStrasse) {
			this._gesamtStrasse = _gesamtStrasse;
		}
	
		/**
		Angabe der Betriebskilometer auf einem Linienobjekt in cm-genauer Angabe.
		<p>
		
		</p>
		
		@return der Wert von BetriebsKilometer.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlBetriebsKilometerGenau
			> getBetriebsKilometer() {
			return _betriebsKilometer;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soGesamtStrasse = getGesamtStrasse();
					final SystemObject tmpGesamtStrasse;
						if (soGesamtStrasse instanceof SystemObject) {
							tmpGesamtStrasse = (SystemObject)soGesamtStrasse;
						} else if(soGesamtStrasse instanceof SystemObjekt){
							tmpGesamtStrasse = ((SystemObjekt)soGesamtStrasse).getSystemObject();
						} else{
							tmpGesamtStrasse = null;
						}
					datum.getReferenceValue("GesamtStraße").setSystemObject(tmpGesamtStrasse);
				// AttributListenDefinition
					final Data.Array arrayBetriebsKilometer = datum.getArray("BetriebsKilometer");
					arrayBetriebsKilometer.setLength(getBetriebsKilometer().size());
					for (int i = 0; i < arrayBetriebsKilometer.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlBetriebsKilometerGenau
						 atl = getBetriebsKilometer().get(i);
						atl.bean2Atl(arrayBetriebsKilometer.getItem(i), factory);
	
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idGesamtStrasse = daten.getReferenceValue("GesamtStraße").getId();
					final SystemObjekt tmpGesamtStrasse;
					if (idGesamtStrasse == 0) {
						tmpGesamtStrasse = null;
					} else {
						final SystemObject soGesamtStrasse = factory.getDav().getDataModel().getObject(idGesamtStrasse);
						if (soGesamtStrasse == null) {
								tmpGesamtStrasse = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.impl.GesamtStrasseUngueltig(idGesamtStrasse);
						} else {
							tmpGesamtStrasse = factory.getModellobjekt(soGesamtStrasse);
						}
					}
					setGesamtStrasse((	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.GesamtStrasse
					) tmpGesamtStrasse);
				// AttributListenDefinition
					final Data.Array arrayBetriebsKilometer = daten.getArray("BetriebsKilometer");
					for (int i = 0; i < arrayBetriebsKilometer.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlBetriebsKilometerGenau
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlBetriebsKilometerGenau
						 ();
						atl.atl2Bean(arrayBetriebsKilometer.getItem(i), factory);
						getBetriebsKilometer().add(atl);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlBetriebsKilometerStrasse clone() {
		AtlBetriebsKilometerStrasse klon = new AtlBetriebsKilometerStrasse();
		
						klon.setGesamtStrasse(getGesamtStrasse());
					klon._betriebsKilometer = getBetriebsKilometer().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
