/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Liste mit den FCD-Daten für einen Teilabschnitt (Sicht der Quelle) auf einem
					StraßenTeilSegment.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 61
 */
public class AtlFcdStrassenTeilSegmentDatenListe implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 _vonOffset
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 _bisOffset
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
			 _vAktuell
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFcdZeitDauerSekunden2Nachkommastellen
			 _tReiseAktuell
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
			 _vFrei
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
			 _vRef
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttStoerfallSituation
			 _vLage
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFcdIndex
			 _indexQuelle
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFcdIndex
			 _indexVertrauen
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFcdIndex
			 _indexQualitaet
			;
	
		/**
		Offset in m vom Beginn des StraßenTeilSegments für den Anfangspunkt des betroffenen
								Bereichs.
		<p>
		
		</p>
		
		@return der Wert von VonOffset.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 getVonOffset() {
			return _vonOffset;
		}
	
		/**
		Offset in m vom Beginn des StraßenTeilSegments für den Anfangspunkt des betroffenen
								Bereichs.
		<p>
		
		</p>
		
		@param _vonOffset der neue Wert von VonOffset.
		*/
		public void setVonOffset(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
		 _vonOffset) {
			this._vonOffset = _vonOffset;
		}
	
		/**
		Offset in m vom Beginn des StraßenTeilSegments für den Endpunkt des betroffenen Bereichs.
								Liegen mehrere Teilabschnitte auf einem StraßenTeilSegment direkt hintereinander, so ist als
								vonOffset des nachfolgenden Teilabschnitts der bisOffset des darvorliegenden Teilabschnitts zu
								verwenden. Erstreckt sich ein Teilabschnitt über mehrere StraßenTeilSegmente, so ist für jedes
								betroffene StraßenTeilSegment mindestens ein eigener Teilabschnitt für das jeweilige
								StraßenTeilSegment anzulegen.
		<p>
		
		</p>
		
		@return der Wert von BisOffset.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 getBisOffset() {
			return _bisOffset;
		}
	
		/**
		Offset in m vom Beginn des StraßenTeilSegments für den Endpunkt des betroffenen Bereichs.
								Liegen mehrere Teilabschnitte auf einem StraßenTeilSegment direkt hintereinander, so ist als
								vonOffset des nachfolgenden Teilabschnitts der bisOffset des darvorliegenden Teilabschnitts zu
								verwenden. Erstreckt sich ein Teilabschnitt über mehrere StraßenTeilSegmente, so ist für jedes
								betroffene StraßenTeilSegment mindestens ein eigener Teilabschnitt für das jeweilige
								StraßenTeilSegment anzulegen.
		<p>
		
		</p>
		
		@param _bisOffset der neue Wert von BisOffset.
		*/
		public void setBisOffset(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
		 _bisOffset) {
			this._bisOffset = _bisOffset;
		}
	
		/**
		Mittlere momentane Geschwindigkeit: gemittelte Geschwindigkeit auf einem (Teil-) Segment
								im aktuellen Zeitintervall.
		<p>
		
		</p>
		
		@return der Wert von VAktuell.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
			 getVAktuell() {
			return _vAktuell;
		}
	
		/**
		Mittlere momentane Geschwindigkeit: gemittelte Geschwindigkeit auf einem (Teil-) Segment
								im aktuellen Zeitintervall.
		<p>
		
		</p>
		
		@param _vAktuell der neue Wert von VAktuell.
		*/
		public void setVAktuell(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
		 _vAktuell) {
			this._vAktuell = _vAktuell;
		}
	
		/**
		Momentane Reisezeit: gemittelte Reisezeit auf einem Netzabschnitt im aktuellen
								Zeitintervall.
		<p>
		
		</p>
		
		@return der Wert von TReiseAktuell.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFcdZeitDauerSekunden2Nachkommastellen
			 getTReiseAktuell() {
			return _tReiseAktuell;
		}
	
		/**
		Momentane Reisezeit: gemittelte Reisezeit auf einem Netzabschnitt im aktuellen
								Zeitintervall.
		<p>
		
		</p>
		
		@param _tReiseAktuell der neue Wert von TReiseAktuell.
		*/
		public void setTReiseAktuell(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFcdZeitDauerSekunden2Nachkommastellen
		 _tReiseAktuell) {
			this._tReiseAktuell = _tReiseAktuell;
		}
	
		/**
		Geschwindigkeit bei freiem Verkehrsfluss: mittlere Geschwindigkeit auf einem Teilabschnitt
								im unbelasteten Netz, z.B. nachts ohne Störungen.
		<p>
		
		</p>
		
		@return der Wert von VFrei.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
			 getVFrei() {
			return _vFrei;
		}
	
		/**
		Geschwindigkeit bei freiem Verkehrsfluss: mittlere Geschwindigkeit auf einem Teilabschnitt
								im unbelasteten Netz, z.B. nachts ohne Störungen.
		<p>
		
		</p>
		
		@param _vFrei der neue Wert von VFrei.
		*/
		public void setVFrei(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
		 _vFrei) {
			this._vFrei = _vFrei;
		}
	
		/**
		Übliche Geschwindigkeit im Vergleichszeitraum.
		<p>
		Definition: mittlere Geschwindigkeit
								auf einem Teilabschnitt in einem vergleichbaren Zeitraum, z.B. Donnerstag, kein Feier- bzw.
								Brauchtumstag, außerhalb Schulferien, 8:00 bis 9:00 Uhr (Wertebereich: positive Ganzzahl
								[km&#47;h]). Die Ermittlung der Kenngröße ist zu dokumentieren, dabei sind Angaben zur Bildung und
								Fortschreibung des Vergleichszeitraums zu machen.
		</p>
		
		@return der Wert von VRef.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
			 getVRef() {
			return _vRef;
		}
	
		/**
		Übliche Geschwindigkeit im Vergleichszeitraum.
		<p>
		Definition: mittlere Geschwindigkeit
								auf einem Teilabschnitt in einem vergleichbaren Zeitraum, z.B. Donnerstag, kein Feier- bzw.
								Brauchtumstag, außerhalb Schulferien, 8:00 bis 9:00 Uhr (Wertebereich: positive Ganzzahl
								[km&#47;h]). Die Ermittlung der Kenngröße ist zu dokumentieren, dabei sind Angaben zur Bildung und
								Fortschreibung des Vergleichszeitraums zu machen.
		</p>
		
		@param _vRef der neue Wert von VRef.
		*/
		public void setVRef(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
		 _vRef) {
			this._vRef = _vRef;
		}
	
		/**
		Momentane Verkehrslagestufe.
		<p>
		Die Verkehrslagestufe wird auf Basis der momentanten Geschwindigekeit und der
								Geschwindigkeit bei freiem Verkehrsfluss ermittelt. Die Einteilung&#47;Abbildung der LOS erfolgt
								dabei durch den Lieferant der Daten incl. der Zustände für nicht ermittelbare LOS. Die genaue
								Zuordnung zwischen den berechneten Stufen und der zugewiesenen Störfallsituation siehe
								gesonderte Dokumentation.
		</p>
		
		@return der Wert von VLage.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttStoerfallSituation
			 getVLage() {
			return _vLage;
		}
	
		/**
		Momentane Verkehrslagestufe.
		<p>
		Die Verkehrslagestufe wird auf Basis der momentanten Geschwindigekeit und der
								Geschwindigkeit bei freiem Verkehrsfluss ermittelt. Die Einteilung&#47;Abbildung der LOS erfolgt
								dabei durch den Lieferant der Daten incl. der Zustände für nicht ermittelbare LOS. Die genaue
								Zuordnung zwischen den berechneten Stufen und der zugewiesenen Störfallsituation siehe
								gesonderte Dokumentation.
		</p>
		
		@param _vLage der neue Wert von VLage.
		*/
		public void setVLage(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttStoerfallSituation
		 _vLage) {
			this._vLage = _vLage;
		}
	
		/**
		Quellenindex: Bei der Verwendung von Quellen, die nicht der eigenen aktuellen
								FCD-Erfassung zuzurechnen sind (z.B. der stationären Detektion auf den BAB, historische Daten)
								muss eine entsprechende Angabe erfolgen, die eine Einschätzung des aktuellen Anteils dieser
								Datenquellen ermöglicht. Zur Berechnung des Quellenindex siehe getrennte Dokumentation.
		<p>
		
		</p>
		
		@return der Wert von IndexQuelle.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFcdIndex
			 getIndexQuelle() {
			return _indexQuelle;
		}
	
		/**
		Quellenindex: Bei der Verwendung von Quellen, die nicht der eigenen aktuellen
								FCD-Erfassung zuzurechnen sind (z.B. der stationären Detektion auf den BAB, historische Daten)
								muss eine entsprechende Angabe erfolgen, die eine Einschätzung des aktuellen Anteils dieser
								Datenquellen ermöglicht. Zur Berechnung des Quellenindex siehe getrennte Dokumentation.
		<p>
		
		</p>
		
		@param _indexQuelle der neue Wert von IndexQuelle.
		*/
		public void setIndexQuelle(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFcdIndex
		 _indexQuelle) {
			this._indexQuelle = _indexQuelle;
		}
	
		/**
		Vertrauensindex: Bei der Lieferung von Echtzeitdaten beschreibt der Vertrauensindex einen
								Wert, durch den die Qualität der übertragenen verkehrlichen Kennwerte für das übertragene
								Zeitintervall bewertet wird. In dem Vertrauenskennwert können z.B. Detektionshäufigkeiten,
								Geschwindigkeitsvarianzen, Abweichungen von Referenzgeschwindigkeiten miteinfließen. Zur
								Berechnung des Vertrauensindex siehe getrennte Dokumentation.
		<p>
		
		</p>
		
		@return der Wert von IndexVertrauen.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFcdIndex
			 getIndexVertrauen() {
			return _indexVertrauen;
		}
	
		/**
		Vertrauensindex: Bei der Lieferung von Echtzeitdaten beschreibt der Vertrauensindex einen
								Wert, durch den die Qualität der übertragenen verkehrlichen Kennwerte für das übertragene
								Zeitintervall bewertet wird. In dem Vertrauenskennwert können z.B. Detektionshäufigkeiten,
								Geschwindigkeitsvarianzen, Abweichungen von Referenzgeschwindigkeiten miteinfließen. Zur
								Berechnung des Vertrauensindex siehe getrennte Dokumentation.
		<p>
		
		</p>
		
		@param _indexVertrauen der neue Wert von IndexVertrauen.
		*/
		public void setIndexVertrauen(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFcdIndex
		 _indexVertrauen) {
			this._indexVertrauen = _indexVertrauen;
		}
	
		/**
		Qualitätsindex: Alternativ können beide zuvor genannten Größen Quellenindex und
								Vertrauensindex in einem einzigen Kennwert zusammengefasst sein. Zur Berechnung des
								zusammengefassten Index siehe getrennte Dokumentation.
		<p>
		
		</p>
		
		@return der Wert von IndexQualitaet.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFcdIndex
			 getIndexQualitaet() {
			return _indexQualitaet;
		}
	
		/**
		Qualitätsindex: Alternativ können beide zuvor genannten Größen Quellenindex und
								Vertrauensindex in einem einzigen Kennwert zusammengefasst sein. Zur Berechnung des
								zusammengefassten Index siehe getrennte Dokumentation.
		<p>
		
		</p>
		
		@param _indexQualitaet der neue Wert von IndexQualitaet.
		*/
		public void setIndexQualitaet(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFcdIndex
		 _indexQualitaet) {
			this._indexQualitaet = _indexQualitaet;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getVonOffset() != null) {
	                if (getVonOffset().isZustand()) {
	                    datum.getUnscaledValue("vonOffset").setText(getVonOffset().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("vonOffset").set(getVonOffset().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getBisOffset() != null) {
	                if (getBisOffset().isZustand()) {
	                    datum.getUnscaledValue("bisOffset").setText(getBisOffset().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("bisOffset").set(getBisOffset().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getVAktuell() != null) {
	                if (getVAktuell().isZustand()) {
	                    datum.getUnscaledValue("vAktuell").setText(getVAktuell().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("vAktuell").set(getVAktuell().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getTReiseAktuell() != null) {
	                if (getTReiseAktuell().isZustand()) {
	                    datum.getUnscaledValue("tReiseAktuell").setText(getTReiseAktuell().toString());
	                } else {
						datum.
						getScaledValue
	                	("tReiseAktuell").set(getTReiseAktuell().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getVFrei() != null) {
	                if (getVFrei().isZustand()) {
	                    datum.getUnscaledValue("vFrei").setText(getVFrei().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("vFrei").set(getVFrei().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getVRef() != null) {
	                if (getVRef().isZustand()) {
	                    datum.getUnscaledValue("vRef").setText(getVRef().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("vRef").set(getVRef().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getVLage() != null) {
	                if (getVLage().isZustand()) {
	                    datum.getUnscaledValue("VLage").setText(getVLage().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("VLage").set(getVLage().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getIndexQuelle() != null) {
	                if (getIndexQuelle().isZustand()) {
	                    datum.getUnscaledValue("IndexQuelle").setText(getIndexQuelle().toString());
	                } else {
						datum.
						getScaledValue
	                	("IndexQuelle").set(getIndexQuelle().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getIndexVertrauen() != null) {
	                if (getIndexVertrauen().isZustand()) {
	                    datum.getUnscaledValue("IndexVertrauen").setText(getIndexVertrauen().toString());
	                } else {
						datum.
						getScaledValue
	                	("IndexVertrauen").set(getIndexVertrauen().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getIndexQualitaet() != null) {
	                if (getIndexQualitaet().isZustand()) {
	                    datum.getUnscaledValue("IndexQualität").setText(getIndexQualitaet().toString());
	                } else {
						datum.
						getScaledValue
	                	("IndexQualität").set(getIndexQualitaet().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("vonOffset").isState()) {
							setVonOffset(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
							.getZustand(daten.getScaledValue("vonOffset").getText()));
						} else {
						setVonOffset(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
						(daten.
							getUnscaledValue
						("vonOffset").
								longValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("bisOffset").isState()) {
							setBisOffset(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
							.getZustand(daten.getScaledValue("bisOffset").getText()));
						} else {
						setBisOffset(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
						(daten.
							getUnscaledValue
						("bisOffset").
								longValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("vAktuell").isState()) {
							setVAktuell(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
							.getZustand(daten.getScaledValue("vAktuell").getText()));
						} else {
						setVAktuell(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
						(daten.
							getUnscaledValue
						("vAktuell").
								shortValue
						()));
						}
				// GanzzahlAttributTyp
						setTReiseAktuell(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFcdZeitDauerSekunden2Nachkommastellen
						(daten.
							getScaledValue
						("tReiseAktuell").
							doubleValue
						()));
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("vFrei").isState()) {
							setVFrei(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
							.getZustand(daten.getScaledValue("vFrei").getText()));
						} else {
						setVFrei(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
						(daten.
							getUnscaledValue
						("vFrei").
								shortValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("vRef").isState()) {
							setVRef(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
							.getZustand(daten.getScaledValue("vRef").getText()));
						} else {
						setVRef(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
						(daten.
							getUnscaledValue
						("vRef").
								shortValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("VLage").isState()) {
							setVLage(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttStoerfallSituation
							.getZustand(daten.getScaledValue("VLage").getText()));
						} else {
						setVLage(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttStoerfallSituation
						(daten.
							getUnscaledValue
						("VLage").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("IndexQuelle").isState()) {
							setIndexQuelle(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFcdIndex
							.getZustand(daten.getScaledValue("IndexQuelle").getText()));
						} else {
						setIndexQuelle(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFcdIndex
						(daten.
							getScaledValue
						("IndexQuelle").
							doubleValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("IndexVertrauen").isState()) {
							setIndexVertrauen(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFcdIndex
							.getZustand(daten.getScaledValue("IndexVertrauen").getText()));
						} else {
						setIndexVertrauen(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFcdIndex
						(daten.
							getScaledValue
						("IndexVertrauen").
							doubleValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("IndexQualität").isState()) {
							setIndexQualitaet(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFcdIndex
							.getZustand(daten.getScaledValue("IndexQualität").getText()));
						} else {
						setIndexQualitaet(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFcdIndex
						(daten.
							getScaledValue
						("IndexQualität").
							doubleValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlFcdStrassenTeilSegmentDatenListe clone() {
		AtlFcdStrassenTeilSegmentDatenListe klon = new AtlFcdStrassenTeilSegmentDatenListe();
		
						klon.setVonOffset(getVonOffset());
						klon.setBisOffset(getBisOffset());
						klon.setVAktuell(getVAktuell());
						klon.setTReiseAktuell(getTReiseAktuell());
						klon.setVFrei(getVFrei());
						klon.setVRef(getVRef());
						klon.setVLage(getVLage());
						klon.setIndexQuelle(getIndexQuelle());
						klon.setIndexVertrauen(getIndexVertrauen());
						klon.setIndexQualitaet(getIndexQualitaet());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
