/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Regel, als konjunktive Normalform (KNF) formuliert.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 13
 */
public class AtlFuzzyRegel implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlFuzzyVariable
			> _praemisse = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlFuzzyVariable
			>(0, true);
			private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlFuzzyTerm
			 _konklusion
			= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlFuzzyTerm
			()
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttFuzzyZugehoerigkeit
			 _sicherheitsgrad
			;
	
		/**
		Eine Fuzzy-Variable.
		<p>
		
		</p>
		
		@return der Wert von Praemisse.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlFuzzyVariable
			> getPraemisse() {
			return _praemisse;
		}
	
	
		/**
		Term eines Fuzzy-Werts.
		<p>
		
		</p>
		
		@return der Wert von Konklusion.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlFuzzyTerm
			 getKonklusion() {
			return _konklusion;
		}
	
		/**
		Term eines Fuzzy-Werts.
		<p>
		
		</p>
		
		@param _konklusion der neue Wert von Konklusion.
		*/
		public void setKonklusion(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlFuzzyTerm
		 _konklusion) {
			this._konklusion = _konklusion;
		}
	
		/**
		Zugehörigkeit innerhalb einer linguistischen Variable (Fuzzy).
		<p>
		
		</p>
		
		@return der Wert von Sicherheitsgrad.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttFuzzyZugehoerigkeit
			 getSicherheitsgrad() {
			return _sicherheitsgrad;
		}
	
		/**
		Zugehörigkeit innerhalb einer linguistischen Variable (Fuzzy).
		<p>
		
		</p>
		
		@param _sicherheitsgrad der neue Wert von Sicherheitsgrad.
		*/
		public void setSicherheitsgrad(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttFuzzyZugehoerigkeit
		 _sicherheitsgrad) {
			this._sicherheitsgrad = _sicherheitsgrad;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// AttributListenDefinition
					final Data.Array arrayPraemisse = datum.getArray("Prämisse");
					arrayPraemisse.setLength(getPraemisse().size());
					for (int i = 0; i < arrayPraemisse.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlFuzzyVariable
						 atl = getPraemisse().get(i);
						atl.bean2Atl(arrayPraemisse.getItem(i), factory);
	
					}
				// AttributListenDefinition
					getKonklusion().bean2Atl(datum.getItem("Konklusion"), factory);
				// GanzzahlAttributTyp
				if (getSicherheitsgrad() != null) {
	                if (getSicherheitsgrad().isZustand()) {
	                    datum.getUnscaledValue("Sicherheitsgrad").setText(getSicherheitsgrad().toString());
	                } else {
						datum.
						getScaledValue
	                	("Sicherheitsgrad").set(getSicherheitsgrad().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// AttributListenDefinition
					final Data.Array arrayPraemisse = daten.getArray("Prämisse");
					for (int i = 0; i < arrayPraemisse.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlFuzzyVariable
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlFuzzyVariable
						 ();
						atl.atl2Bean(arrayPraemisse.getItem(i), factory);
						getPraemisse().add(atl);
					}
				// AttributListenDefinition
					getKonklusion().atl2Bean(daten.getItem("Konklusion"), factory);
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Sicherheitsgrad").isState()) {
							setSicherheitsgrad(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttFuzzyZugehoerigkeit
							.getZustand(daten.getScaledValue("Sicherheitsgrad").getText()));
						} else {
						setSicherheitsgrad(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttFuzzyZugehoerigkeit
						(daten.
							getScaledValue
						("Sicherheitsgrad").
							doubleValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlFuzzyRegel clone() {
		AtlFuzzyRegel klon = new AtlFuzzyRegel();
		
					klon._praemisse = getPraemisse().clone();
						klon._konklusion = getKonklusion().clone();
						klon.setSicherheitsgrad(getSicherheitsgrad());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
