/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Attributliste für lokale Störfallerkennung mittels
					Fundamentaldiagramm.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 26
 */
public class AtlLokaleStoerfallErkennungFundamentalDiagramm implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellen
			 _fa
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellen
			 _fp
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
			 _vgrenz
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
			 _vgrenzHysterese
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellen
			 _fk
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellen
			 _fkHysterese
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellen
			 _fv
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellen
			 _fvHysterese
			;
	
		/**
		Faktor für die Ermittlung der Analysedichte.
		<p>
		
		</p>
		
		@return der Wert von Fa.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellen
			 getFa() {
			return _fa;
		}
	
		/**
		Faktor für die Ermittlung der Analysedichte.
		<p>
		
		</p>
		
		@param _fa der neue Wert von Fa.
		*/
		public void setFa(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellen
		 _fa) {
			this._fa = _fa;
		}
	
		/**
		Faktor für die Ermittlung der Prognosedichte.
		<p>
		
		</p>
		
		@return der Wert von Fp.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellen
			 getFp() {
			return _fp;
		}
	
		/**
		Faktor für die Ermittlung der Prognosedichte.
		<p>
		
		</p>
		
		@param _fp der neue Wert von Fp.
		*/
		public void setFp(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellen
		 _fp) {
			this._fp = _fp;
		}
	
		/**
		Absoluter Wert für den Vergleich mit
								VKfzStörfall.
		<p>
		
		</p>
		
		@return der Wert von Vgrenz.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
			 getVgrenz() {
			return _vgrenz;
		}
	
		/**
		Absoluter Wert für den Vergleich mit
								VKfzStörfall.
		<p>
		
		</p>
		
		@param _vgrenz der neue Wert von Vgrenz.
		*/
		public void setVgrenz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
		 _vgrenz) {
			this._vgrenz = _vgrenz;
		}
	
		/**
		Hysteresewert für Vgrenz (VGrenz +&#47;-
								VgrenzHysterese).
		<p>
		
		</p>
		
		@return der Wert von VgrenzHysterese.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
			 getVgrenzHysterese() {
			return _vgrenzHysterese;
		}
	
		/**
		Hysteresewert für Vgrenz (VGrenz +&#47;-
								VgrenzHysterese).
		<p>
		
		</p>
		
		@param _vgrenzHysterese der neue Wert von VgrenzHysterese.
		*/
		public void setVgrenzHysterese(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
		 _vgrenzHysterese) {
			this._vgrenzHysterese = _vgrenzHysterese;
		}
	
		/**
		Faktor für den Vergleich von KKfzStörfallG mid
								K0.
		<p>
		
		</p>
		
		@return der Wert von Fk.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellen
			 getFk() {
			return _fk;
		}
	
		/**
		Faktor für den Vergleich von KKfzStörfallG mid
								K0.
		<p>
		
		</p>
		
		@param _fk der neue Wert von Fk.
		*/
		public void setFk(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellen
		 _fk) {
			this._fk = _fk;
		}
	
		/**
		Hysteresewert für fk(fk +&#47;- fkHysterese).
		<p>
		
		</p>
		
		@return der Wert von FkHysterese.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellen
			 getFkHysterese() {
			return _fkHysterese;
		}
	
		/**
		Hysteresewert für fk(fk +&#47;- fkHysterese).
		<p>
		
		</p>
		
		@param _fkHysterese der neue Wert von FkHysterese.
		*/
		public void setFkHysterese(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellen
		 _fkHysterese) {
			this._fkHysterese = _fkHysterese;
		}
	
		/**
		Faktor für den Vergleich von VKfzStörfallG mid
								V0.
		<p>
		
		</p>
		
		@return der Wert von Fv.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellen
			 getFv() {
			return _fv;
		}
	
		/**
		Faktor für den Vergleich von VKfzStörfallG mid
								V0.
		<p>
		
		</p>
		
		@param _fv der neue Wert von Fv.
		*/
		public void setFv(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellen
		 _fv) {
			this._fv = _fv;
		}
	
		/**
		Hysteresewert für fv(fv +&#47;- fkHysterese).
		<p>
		
		</p>
		
		@return der Wert von FvHysterese.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellen
			 getFvHysterese() {
			return _fvHysterese;
		}
	
		/**
		Hysteresewert für fv(fv +&#47;- fkHysterese).
		<p>
		
		</p>
		
		@param _fvHysterese der neue Wert von FvHysterese.
		*/
		public void setFvHysterese(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellen
		 _fvHysterese) {
			this._fvHysterese = _fvHysterese;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getFa() != null) {
	                if (getFa().isZustand()) {
	                    datum.getUnscaledValue("fa").setText(getFa().toString());
	                } else {
						datum.
						getScaledValue
	                	("fa").set(getFa().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getFp() != null) {
	                if (getFp().isZustand()) {
	                    datum.getUnscaledValue("fp").setText(getFp().toString());
	                } else {
						datum.
						getScaledValue
	                	("fp").set(getFp().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getVgrenz() != null) {
	                if (getVgrenz().isZustand()) {
	                    datum.getUnscaledValue("Vgrenz").setText(getVgrenz().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Vgrenz").set(getVgrenz().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getVgrenzHysterese() != null) {
	                if (getVgrenzHysterese().isZustand()) {
	                    datum.getUnscaledValue("VgrenzHysterese").setText(getVgrenzHysterese().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("VgrenzHysterese").set(getVgrenzHysterese().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getFk() != null) {
	                if (getFk().isZustand()) {
	                    datum.getUnscaledValue("fk").setText(getFk().toString());
	                } else {
						datum.
						getScaledValue
	                	("fk").set(getFk().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getFkHysterese() != null) {
	                if (getFkHysterese().isZustand()) {
	                    datum.getUnscaledValue("fkHysterese").setText(getFkHysterese().toString());
	                } else {
						datum.
						getScaledValue
	                	("fkHysterese").set(getFkHysterese().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getFv() != null) {
	                if (getFv().isZustand()) {
	                    datum.getUnscaledValue("fv").setText(getFv().toString());
	                } else {
						datum.
						getScaledValue
	                	("fv").set(getFv().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getFvHysterese() != null) {
	                if (getFvHysterese().isZustand()) {
	                    datum.getUnscaledValue("fvHysterese").setText(getFvHysterese().toString());
	                } else {
						datum.
						getScaledValue
	                	("fvHysterese").set(getFvHysterese().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						setFa(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellen
						(daten.
							getScaledValue
						("fa").
							doubleValue
						()));
				// GanzzahlAttributTyp
						setFp(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellen
						(daten.
							getScaledValue
						("fp").
							doubleValue
						()));
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Vgrenz").isState()) {
							setVgrenz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
							.getZustand(daten.getScaledValue("Vgrenz").getText()));
						} else {
						setVgrenz(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
						(daten.
							getUnscaledValue
						("Vgrenz").
								shortValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("VgrenzHysterese").isState()) {
							setVgrenzHysterese(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
							.getZustand(daten.getScaledValue("VgrenzHysterese").getText()));
						} else {
						setVgrenzHysterese(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
						(daten.
							getUnscaledValue
						("VgrenzHysterese").
								shortValue
						()));
						}
				// GanzzahlAttributTyp
						setFk(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellen
						(daten.
							getScaledValue
						("fk").
							doubleValue
						()));
				// GanzzahlAttributTyp
						setFkHysterese(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellen
						(daten.
							getScaledValue
						("fkHysterese").
							doubleValue
						()));
				// GanzzahlAttributTyp
						setFv(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellen
						(daten.
							getScaledValue
						("fv").
							doubleValue
						()));
				// GanzzahlAttributTyp
						setFvHysterese(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellen
						(daten.
							getScaledValue
						("fvHysterese").
							doubleValue
						()));
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlLokaleStoerfallErkennungFundamentalDiagramm clone() {
		AtlLokaleStoerfallErkennungFundamentalDiagramm klon = new AtlLokaleStoerfallErkennungFundamentalDiagramm();
		
						klon.setFa(getFa());
						klon.setFp(getFp());
						klon.setVgrenz(getVgrenz());
						klon.setVgrenzHysterese(getVgrenzHysterese());
						klon.setFk(getFk());
						klon.setFkHysterese(getFkHysterese());
						klon.setFv(getFv());
						klon.setFvHysterese(getFvHysterese());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
