/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Wertebereichsgrenzen für Prozentwerte bei der
					logischen Plausibilitätsprüfung.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlMinMaxProzent implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
			 _min
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
			 _max
			;
	
		/**
		Minimum des erlaubten Prozentwertes.
		<p>
		
		</p>
		
		@return der Wert von Min.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
			 getMin() {
			return _min;
		}
	
		/**
		Minimum des erlaubten Prozentwertes.
		<p>
		
		</p>
		
		@param _min der neue Wert von Min.
		*/
		public void setMin(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
		 _min) {
			this._min = _min;
		}
	
		/**
		Maximum des erlaubten Prozentwertes.
		<p>
		
		</p>
		
		@return der Wert von Max.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
			 getMax() {
			return _max;
		}
	
		/**
		Maximum des erlaubten Prozentwertes.
		<p>
		
		</p>
		
		@param _max der neue Wert von Max.
		*/
		public void setMax(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
		 _max) {
			this._max = _max;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getMin() != null) {
	                if (getMin().isZustand()) {
	                    datum.getUnscaledValue("Min").setText(getMin().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Min").set(getMin().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getMax() != null) {
	                if (getMax().isZustand()) {
	                    datum.getUnscaledValue("Max").setText(getMax().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Max").set(getMax().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Min").isState()) {
							setMin(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
							.getZustand(daten.getScaledValue("Min").getText()));
						} else {
						setMin(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
						(daten.
							getUnscaledValue
						("Min").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Max").isState()) {
							setMax(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
							.getZustand(daten.getScaledValue("Max").getText()));
						} else {
						setMax(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
						(daten.
							getUnscaledValue
						("Max").
								byteValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlMinMaxProzent clone() {
		AtlMinMaxProzent klon = new AtlMinMaxProzent();
		
						klon.setMin(getMin());
						klon.setMax(getMax());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
