/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Attributliste Ergebnisse der Kapazitätsermittlung
					pro Abschnitt.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 25
 */
public class AtlNbaKapazitaetsermittlungAbschnitt implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
			 _leistungsfaehigkeit
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 _offset
			;
	
		/**
		Leistungsfähigkeit des Abschnitts.
		<p>
		
		</p>
		
		@return der Wert von Leistungsfaehigkeit.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
			 getLeistungsfaehigkeit() {
			return _leistungsfaehigkeit;
		}
	
		/**
		Leistungsfähigkeit des Abschnitts.
		<p>
		
		</p>
		
		@param _leistungsfaehigkeit der neue Wert von Leistungsfaehigkeit.
		*/
		public void setLeistungsfaehigkeit(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
		 _leistungsfaehigkeit) {
			this._leistungsfaehigkeit = _leistungsfaehigkeit;
		}
	
		/**
		Position, Anfang des eingeschobenen Abschnitts
								auf dem STS.
		<p>
		
		</p>
		
		@return der Wert von Offset.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 getOffset() {
			return _offset;
		}
	
		/**
		Position, Anfang des eingeschobenen Abschnitts
								auf dem STS.
		<p>
		
		</p>
		
		@param _offset der neue Wert von Offset.
		*/
		public void setOffset(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
		 _offset) {
			this._offset = _offset;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getLeistungsfaehigkeit() != null) {
	                if (getLeistungsfaehigkeit().isZustand()) {
	                    datum.getUnscaledValue("Leistungsfähigkeit").setText(getLeistungsfaehigkeit().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Leistungsfähigkeit").set(getLeistungsfaehigkeit().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getOffset() != null) {
	                if (getOffset().isZustand()) {
	                    datum.getUnscaledValue("Offset").setText(getOffset().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Offset").set(getOffset().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Leistungsfähigkeit").isState()) {
							setLeistungsfaehigkeit(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
							.getZustand(daten.getScaledValue("Leistungsfähigkeit").getText()));
						} else {
						setLeistungsfaehigkeit(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
						(daten.
							getUnscaledValue
						("Leistungsfähigkeit").
								intValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Offset").isState()) {
							setOffset(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
							.getZustand(daten.getScaledValue("Offset").getText()));
						} else {
						setOffset(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
						(daten.
							getUnscaledValue
						("Offset").
								longValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaKapazitaetsermittlungAbschnitt clone() {
		AtlNbaKapazitaetsermittlungAbschnitt klon = new AtlNbaKapazitaetsermittlungAbschnitt();
		
						klon.setLeistungsfaehigkeit(getLeistungsfaehigkeit());
						klon.setOffset(getOffset());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
