/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Definition einer Stützstelle für das
					Fundamentaldiagramm.
<p>
&lt;absatz&gt;
						Die Definition umfasst eine Zuordnung von
						Attributen zu einer Stützstelle des
						nbaFundamentaldiagramm.
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 19
 */
public class AtlNbaStuetzstelleFundamentaldiagramm implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
			 _n
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
			 _vk
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttBemessungsVerkehrsStaerkeStunde
			 _qB
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
			 _k
			;
	
		/**
		Anzahl der Verschmelzungen aus denen das
								Fundamentaldiagramm besteht.
		<p>
		
		</p>
		
		@return der Wert von N.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
			 getN() {
			return _n;
		}
	
		/**
		Anzahl der Verschmelzungen aus denen das
								Fundamentaldiagramm besteht.
		<p>
		
		</p>
		
		@param _n der neue Wert von N.
		*/
		public void setN(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
		 _n) {
			this._n = _n;
		}
	
		/**
		Geschwindigkeitswert der Geschwindigkeitsklasse.
		<p>
		
		</p>
		
		@return der Wert von Vk.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
			 getVk() {
			return _vk;
		}
	
		/**
		Geschwindigkeitswert der Geschwindigkeitsklasse.
		<p>
		
		</p>
		
		@param _vk der neue Wert von Vk.
		*/
		public void setVk(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
		 _vk) {
			this._vk = _vk;
		}
	
		/**
		Verkehrsmenge des Fundamentaldiagramms.
		<p>
		
		</p>
		
		@return der Wert von QB.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttBemessungsVerkehrsStaerkeStunde
			 getQB() {
			return _qB;
		}
	
		/**
		Verkehrsmenge des Fundamentaldiagramms.
		<p>
		
		</p>
		
		@param _qB der neue Wert von QB.
		*/
		public void setQB(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttBemessungsVerkehrsStaerkeStunde
		 _qB) {
			this._qB = _qB;
		}
	
		/**
		Dichte des Fundamentaldiagramms.
		<p>
		
		</p>
		
		@return der Wert von K.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
			 getK() {
			return _k;
		}
	
		/**
		Dichte des Fundamentaldiagramms.
		<p>
		
		</p>
		
		@param _k der neue Wert von K.
		*/
		public void setK(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
		 _k) {
			this._k = _k;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getN() != null) {
	                if (getN().isZustand()) {
	                    datum.getUnscaledValue("n").setText(getN().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("n").set(getN().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getVk() != null) {
	                if (getVk().isZustand()) {
	                    datum.getUnscaledValue("vk").setText(getVk().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("vk").set(getVk().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getQB() != null) {
	                if (getQB().isZustand()) {
	                    datum.getUnscaledValue("QB").setText(getQB().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("QB").set(getQB().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getK() != null) {
	                if (getK().isZustand()) {
	                    datum.getUnscaledValue("K").setText(getK().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("K").set(getK().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						setN(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
						(daten.
							getUnscaledValue
						("n").
								longValue
						()));
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("vk").isState()) {
							setVk(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
							.getZustand(daten.getScaledValue("vk").getText()));
						} else {
						setVk(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
						(daten.
							getUnscaledValue
						("vk").
								shortValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("QB").isState()) {
							setQB(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttBemessungsVerkehrsStaerkeStunde
							.getZustand(daten.getScaledValue("QB").getText()));
						} else {
						setQB(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttBemessungsVerkehrsStaerkeStunde
						(daten.
							getUnscaledValue
						("QB").
								intValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("K").isState()) {
							setK(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
							.getZustand(daten.getScaledValue("K").getText()));
						} else {
						setK(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
						(daten.
							getUnscaledValue
						("K").
								shortValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaStuetzstelleFundamentaldiagramm clone() {
		AtlNbaStuetzstelleFundamentaldiagramm klon = new AtlNbaStuetzstelleFundamentaldiagramm();
		
						klon.setN(getN());
						klon.setVk(getVk());
						klon.setQB(getQB());
						klon.setK(getK());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
