/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Enthält die Parameter für die Datenspezifikationen,
					den Modulen und den zugehörigen
					Publikationsaspekten.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 7
 */
public class AtlParameterSatzPublikation implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttSweTyp
			 _sWE
			;
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlPublikationsZuordnung
			> _publikationsZuordnung = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlPublikationsZuordnung
			>(0, true);
	
		/**
		Attributtyp zur Identifikation der einzelnen
							SWE-Einheiten der DuA.
		<p>
		
		</p>
		
		@return der Wert von SWE.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttSweTyp
			 getSWE() {
			return _sWE;
		}
	
		/**
		Attributtyp zur Identifikation der einzelnen
							SWE-Einheiten der DuA.
		<p>
		
		</p>
		
		@param _sWE der neue Wert von SWE.
		*/
		public void setSWE(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttSweTyp
		 _sWE) {
			this._sWE = _sWE;
		}
	
		/**
		Mit dieser Attributgruppe wird spezifiziert, für
							welches Modul innerhalb einer SWE welcher
							Publikations -Aspekt für bestimmte
							DatenSpezifikationen benutzt wird bzw. ob überhaupt
							publiziert werden soll.
		<p>
		
		</p>
		
		@return der Wert von PublikationsZuordnung.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlPublikationsZuordnung
			> getPublikationsZuordnung() {
			return _publikationsZuordnung;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getSWE() != null) {
	                if (getSWE().isZustand()) {
	                    datum.getUnscaledValue("SWE").setText(getSWE().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("SWE").set(getSWE().getValue());
	                }
				}
				// AttributListenDefinition
					final Data.Array arrayPublikationsZuordnung = datum.getArray("PublikationsZuordnung");
					arrayPublikationsZuordnung.setLength(getPublikationsZuordnung().size());
					for (int i = 0; i < arrayPublikationsZuordnung.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlPublikationsZuordnung
						 atl = getPublikationsZuordnung().get(i);
						atl.bean2Atl(arrayPublikationsZuordnung.getItem(i), factory);
	
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("SWE").isState()) {
							setSWE(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttSweTyp
							.getZustand(daten.getScaledValue("SWE").getText()));
						} else {
						setSWE(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttSweTyp
						(daten.
							getUnscaledValue
						("SWE").
								byteValue
						()));
						}
				// AttributListenDefinition
					final Data.Array arrayPublikationsZuordnung = daten.getArray("PublikationsZuordnung");
					for (int i = 0; i < arrayPublikationsZuordnung.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlPublikationsZuordnung
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlPublikationsZuordnung
						 ();
						atl.atl2Bean(arrayPublikationsZuordnung.getItem(i), factory);
						getPublikationsZuordnung().add(atl);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlParameterSatzPublikation clone() {
		AtlParameterSatzPublikation klon = new AtlParameterSatzPublikation();
		
						klon.setSWE(getSWE());
					klon._publikationsZuordnung = getPublikationsZuordnung().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
