/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Mit dieser Attributgruppe wird spezifiziert, für
					welches Modul innerhalb einer SWE welcher
					Publikations -Aspekt für bestimmte
					DatenSpezifikationen benutzt wird bzw. ob überhaupt
					publiziert werden soll.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 7
 */
public class AtlPublikationsZuordnung implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttModulTyp
			 _modulTyp
			;
			private 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Aspekt
			 _publikationsAspekt
			;
			private Feld<	Object
			> _objekt = new Feld<	Object
			>(0, true);
			private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Attributgruppe
			> _attributGruppe = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Attributgruppe
			>(0, true);
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _publizieren
			;
	
		/**
		Attributtyp zur Identifikation der einzelnen Module.
							Ggf. können hier noch Weitere hinzukommen.
		<p>
		
		</p>
		
		@return der Wert von ModulTyp.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttModulTyp
			 getModulTyp() {
			return _modulTyp;
		}
	
		/**
		Attributtyp zur Identifikation der einzelnen Module.
							Ggf. können hier noch Weitere hinzukommen.
		<p>
		
		</p>
		
		@param _modulTyp der neue Wert von ModulTyp.
		*/
		public void setModulTyp(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttModulTyp
		 _modulTyp) {
			this._modulTyp = _modulTyp;
		}
	
		/**
		Mit diesem Attribut wird angegeben, unter
								welchem Aspekt die Daten publiziert werden
								sollen.
		<p>
		
		</p>
		
		@return der Wert von PublikationsAspekt.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Aspekt
			 getPublikationsAspekt() {
			return _publikationsAspekt;
		}
	
		/**
		Mit diesem Attribut wird angegeben, unter
								welchem Aspekt die Daten publiziert werden
								sollen.
		<p>
		
		</p>
		
		@param _publikationsAspekt der neue Wert von PublikationsAspekt.
		*/
		public void setPublikationsAspekt(	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Aspekt
		 _publikationsAspekt) {
			this._publikationsAspekt = _publikationsAspekt;
		}
	
		/**
		Mit diesem Attribut können beliebig viele
								Konfigurationsobjekte angegeben werden. Kein
								Eintrag verweist auf alle Objekte.
		<p>
		
		</p>
		
		@return der Wert von Objekt.
		*/
			public Feld<	Object
			> getObjekt() {
			return _objekt;
		}
	
	
		/**
		Mit diesem Attribut werden die Attributgruppen
								spezifiziert, für die bzg. der ausgewählten
								Konfigurationsobjekte eine Publikation
								stattfinden soll. Kein Eintrag verweist auf alle
								Attributgruppen.
		<p>
		
		</p>
		
		@return der Wert von AttributGruppe.
		*/
			public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Attributgruppe
			> getAttributGruppe() {
			return _attributGruppe;
		}
	
	
		/**
		Mit diesem Attribut wird angegeben, ob die
								entsprechenden Daten publiziert werden sollen.
		<p>
		
		</p>
		
		@return der Wert von Publizieren.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 getPublizieren() {
			return _publizieren;
		}
	
		/**
		Mit diesem Attribut wird angegeben, ob die
								entsprechenden Daten publiziert werden sollen.
		<p>
		
		</p>
		
		@param _publizieren der neue Wert von Publizieren.
		*/
		public void setPublizieren(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
		 _publizieren) {
			this._publizieren = _publizieren;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getModulTyp() != null) {
	                if (getModulTyp().isZustand()) {
	                    datum.getUnscaledValue("ModulTyp").setText(getModulTyp().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("ModulTyp").set(getModulTyp().getValue());
	                }
				}
				// ObjektReferenzAttributTyp
					final Object soPublikationsAspekt = getPublikationsAspekt();
					final SystemObject tmpPublikationsAspekt;
						if (soPublikationsAspekt instanceof SystemObject) {
							tmpPublikationsAspekt = (SystemObject)soPublikationsAspekt;
						} else if(soPublikationsAspekt instanceof SystemObjekt){
							tmpPublikationsAspekt = ((SystemObjekt)soPublikationsAspekt).getSystemObject();
						} else{
							tmpPublikationsAspekt = null;
						}
					datum.getReferenceValue("PublikationsAspekt").setSystemObject(tmpPublikationsAspekt);
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayObjekt = datum.getReferenceArray("Objekt");
					arrayObjekt.setLength(getObjekt().size());
					for (int i = 0; i < arrayObjekt.getLength(); ++i) {
						final Object soObjekt = getObjekt().get(i);
						final SystemObject tmpObjekt;
						if (soObjekt instanceof SystemObject) {
							tmpObjekt = (SystemObject)soObjekt;
						} else if(soObjekt instanceof SystemObjekt){
							tmpObjekt = ((SystemObjekt)soObjekt).getSystemObject();
						} else{
							tmpObjekt = null;
						}
						arrayObjekt.getReferenceValue(i).setSystemObject(tmpObjekt);
					}
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayAttributGruppe = datum.getReferenceArray("AttributGruppe");
					arrayAttributGruppe.setLength(getAttributGruppe().size());
					for (int i = 0; i < arrayAttributGruppe.getLength(); ++i) {
						final Object soAttributGruppe = getAttributGruppe().get(i);
						final SystemObject tmpAttributGruppe;
						if (soAttributGruppe instanceof SystemObject) {
							tmpAttributGruppe = (SystemObject)soAttributGruppe;
						} else if(soAttributGruppe instanceof SystemObjekt){
							tmpAttributGruppe = ((SystemObjekt)soAttributGruppe).getSystemObject();
						} else{
							tmpAttributGruppe = null;
						}
						arrayAttributGruppe.getReferenceValue(i).setSystemObject(tmpAttributGruppe);
					}
				// GanzzahlAttributTyp
				if (getPublizieren() != null) {
	                if (getPublizieren().isZustand()) {
	                    datum.getUnscaledValue("Publizieren").setText(getPublizieren().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Publizieren").set(getPublizieren().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("ModulTyp").isState()) {
							setModulTyp(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttModulTyp
							.getZustand(daten.getScaledValue("ModulTyp").getText()));
						} else {
						setModulTyp(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttModulTyp
						(daten.
							getUnscaledValue
						("ModulTyp").
								byteValue
						()));
						}
				// ObjektReferenzAttributTyp
					final long idPublikationsAspekt = daten.getReferenceValue("PublikationsAspekt").getId();
					final SystemObjekt tmpPublikationsAspekt;
					if (idPublikationsAspekt == 0) {
						tmpPublikationsAspekt = null;
					} else {
						final SystemObject soPublikationsAspekt = factory.getDav().getDataModel().getObject(idPublikationsAspekt);
						if (soPublikationsAspekt == null) {
								tmpPublikationsAspekt = new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektUngueltig(idPublikationsAspekt);
						} else {
							tmpPublikationsAspekt = factory.getModellobjekt(soPublikationsAspekt);
						}
					}
					setPublikationsAspekt((	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Aspekt
					) tmpPublikationsAspekt);
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayObjekt = daten.getReferenceArray("Objekt");
					for (int i = 0; i < arrayObjekt.getLength(); ++i) {
						final long idObjekt = daten.getReferenceArray("Objekt").getReferenceValue(i).getId();
						final SystemObjekt tmpObjekt;
						if (idObjekt == 0) {
							tmpObjekt = null;
						} else {
							final SystemObject soObjekt = factory.getDav().getDataModel().getObject(idObjekt);
							if (soObjekt == null) {
									tmpObjekt = new BaseUngueltigesSystemObjekt(idObjekt);
							} else {
								tmpObjekt = factory.getModellobjekt(soObjekt);
							}
						}
							getObjekt().add((	Object
							) tmpObjekt);
					}
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayAttributGruppe = daten.getReferenceArray("AttributGruppe");
					for (int i = 0; i < arrayAttributGruppe.getLength(); ++i) {
						final long idAttributGruppe = daten.getReferenceArray("AttributGruppe").getReferenceValue(i).getId();
						final SystemObjekt tmpAttributGruppe;
						if (idAttributGruppe == 0) {
							tmpAttributGruppe = null;
						} else {
							final SystemObject soAttributGruppe = factory.getDav().getDataModel().getObject(idAttributGruppe);
							if (soAttributGruppe == null) {
									tmpAttributGruppe = new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AttributgruppeUngueltig(idAttributGruppe);
							} else {
								tmpAttributGruppe = factory.getModellobjekt(soAttributGruppe);
							}
						}
							getAttributGruppe().add((	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Attributgruppe
							) tmpAttributGruppe);
					}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Publizieren").isState()) {
							setPublizieren(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							.getZustand(daten.getScaledValue("Publizieren").getText()));
						} else {
						setPublizieren(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
						(daten.
							getUnscaledValue
						("Publizieren").
								byteValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlPublikationsZuordnung clone() {
		AtlPublikationsZuordnung klon = new AtlPublikationsZuordnung();
		
						klon.setModulTyp(getModulTyp());
						klon.setPublikationsAspekt(getPublikationsAspekt());
					klon._objekt = getObjekt().clone();
					klon._attributGruppe = getAttributGruppe().clone();
						klon.setPublizieren(getPublizieren());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
