/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Angabe der statischen Beschilderung auf einem Linienobjekt.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 55
 */
public class AtlStatischeBeschilderungVerkehr implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttOffsetCm
			 _offsetVon
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttOffsetCm
			 _offsetBis
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrlicheBeschraenkung
			 _verkehrlicheBeschraenkung
			;
			private String
			 _bedingung
			= new String
			()
			;
	
		/**
		Ort des Beginns der Gültigkeit der verkehrlichen Beschränkung als Abstand des Punktes vom Anfang
								des Linienobjekts.
		<p>
		
		</p>
		
		@return der Wert von OffsetVon.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttOffsetCm
			 getOffsetVon() {
			return _offsetVon;
		}
	
		/**
		Ort des Beginns der Gültigkeit der verkehrlichen Beschränkung als Abstand des Punktes vom Anfang
								des Linienobjekts.
		<p>
		
		</p>
		
		@param _offsetVon der neue Wert von OffsetVon.
		*/
		public void setOffsetVon(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttOffsetCm
		 _offsetVon) {
			this._offsetVon = _offsetVon;
		}
	
		/**
		Ort des Endes der Gültigkeit der verkehrlichen Beschränkung als Abstand des Punktes vom Anfang
								des Linienobjekts.
		<p>
		
		</p>
		
		@return der Wert von OffsetBis.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttOffsetCm
			 getOffsetBis() {
			return _offsetBis;
		}
	
		/**
		Ort des Endes der Gültigkeit der verkehrlichen Beschränkung als Abstand des Punktes vom Anfang
								des Linienobjekts.
		<p>
		
		</p>
		
		@param _offsetBis der neue Wert von OffsetBis.
		*/
		public void setOffsetBis(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttOffsetCm
		 _offsetBis) {
			this._offsetBis = _offsetBis;
		}
	
		/**
		Verkehrliche Beschränkung. Weitere Bedingungen zur Beschränkung (zeitliche und sachliche) werden
								über das Attribut "Bedingung" festgelegt.
		<p>
		
		</p>
		
		@return der Wert von VerkehrlicheBeschraenkung.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrlicheBeschraenkung
			 getVerkehrlicheBeschraenkung() {
			return _verkehrlicheBeschraenkung;
		}
	
		/**
		Verkehrliche Beschränkung. Weitere Bedingungen zur Beschränkung (zeitliche und sachliche) werden
								über das Attribut "Bedingung" festgelegt.
		<p>
		
		</p>
		
		@param _verkehrlicheBeschraenkung der neue Wert von VerkehrlicheBeschraenkung.
		*/
		public void setVerkehrlicheBeschraenkung(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrlicheBeschraenkung
		 _verkehrlicheBeschraenkung) {
			this._verkehrlicheBeschraenkung = _verkehrlicheBeschraenkung;
		}
	
		/**
		Beschreibung der weiterer Bedingungen der Beschränkung.
								Die Synax entspricht der OSM-Spezifikation für das Condition-Feld.
								Zur Spezifikation der Syntax für die Angabe siehe
								"http:&#47;&#47;wiki.openstreetmap.org&#47;wiki&#47;Conditional_restrictions".
		<p>
		
		</p>
		
		@return der Wert von Bedingung.
		*/
			public String
			 getBedingung() {
			return _bedingung;
		}
	
		/**
		Beschreibung der weiterer Bedingungen der Beschränkung.
								Die Synax entspricht der OSM-Spezifikation für das Condition-Feld.
								Zur Spezifikation der Syntax für die Angabe siehe
								"http:&#47;&#47;wiki.openstreetmap.org&#47;wiki&#47;Conditional_restrictions".
		<p>
		
		</p>
		
		@param _bedingung der neue Wert von Bedingung.
		*/
		public void setBedingung(String
		 _bedingung) {
			if (_bedingung.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._bedingung = _bedingung;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getOffsetVon() != null) {
	                if (getOffsetVon().isZustand()) {
	                    datum.getUnscaledValue("OffsetVon").setText(getOffsetVon().toString());
	                } else {
						datum.
						getScaledValue
	                	("OffsetVon").set(getOffsetVon().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getOffsetBis() != null) {
	                if (getOffsetBis().isZustand()) {
	                    datum.getUnscaledValue("OffsetBis").setText(getOffsetBis().toString());
	                } else {
						datum.
						getScaledValue
	                	("OffsetBis").set(getOffsetBis().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getVerkehrlicheBeschraenkung() != null) {
	                if (getVerkehrlicheBeschraenkung().isZustand()) {
	                    datum.getUnscaledValue("VerkehrlicheBeschränkung").setText(getVerkehrlicheBeschraenkung().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("VerkehrlicheBeschränkung").set(getVerkehrlicheBeschraenkung().getValue());
	                }
				}
				// ZeichenkettenAttributTyp
				if (getBedingung() != null) {
					datum.getTextValue("Bedingung").setText(getBedingung());
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("OffsetVon").isState()) {
							setOffsetVon(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttOffsetCm
							.getZustand(daten.getScaledValue("OffsetVon").getText()));
						} else {
						setOffsetVon(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttOffsetCm
						(daten.
							getScaledValue
						("OffsetVon").
							doubleValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("OffsetBis").isState()) {
							setOffsetBis(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttOffsetCm
							.getZustand(daten.getScaledValue("OffsetBis").getText()));
						} else {
						setOffsetBis(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttOffsetCm
						(daten.
							getScaledValue
						("OffsetBis").
							doubleValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("VerkehrlicheBeschränkung").isState()) {
							setVerkehrlicheBeschraenkung(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrlicheBeschraenkung
							.getZustand(daten.getScaledValue("VerkehrlicheBeschränkung").getText()));
						} else {
						setVerkehrlicheBeschraenkung(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrlicheBeschraenkung
						(daten.
							getUnscaledValue
						("VerkehrlicheBeschränkung").
								shortValue
						()));
						}
				// ZeichenkettenAttributTyp
					setBedingung(daten.getTextValue("Bedingung").getText());
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlStatischeBeschilderungVerkehr clone() {
		AtlStatischeBeschilderungVerkehr klon = new AtlStatischeBeschilderungVerkehr();
		
						klon.setOffsetVon(getOffsetVon());
						klon.setOffsetBis(getOffsetBis());
						klon.setVerkehrlicheBeschraenkung(getVerkehrlicheBeschraenkung());
						klon.setBedingung(getBedingung());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
