/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Statusinformationen werden von der formalen
					Plausibilitätsprügung gesetzt.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlStatusPlausibilitaetsPruefungFormal implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _wertMax
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _wertMin
			;
	
		/**
		Wird von der formalen Plausibilitätsprüfung auf
								ja gesetzt, wenn Wert wegen
								Bereichsüberschreitung auf das Maximum gesetzt
								wurde.
		<p>
		
		</p>
		
		@return der Wert von WertMax.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 getWertMax() {
			return _wertMax;
		}
	
		/**
		Wird von der formalen Plausibilitätsprüfung auf
								ja gesetzt, wenn Wert wegen
								Bereichsüberschreitung auf das Maximum gesetzt
								wurde.
		<p>
		
		</p>
		
		@param _wertMax der neue Wert von WertMax.
		*/
		public void setWertMax(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
		 _wertMax) {
			this._wertMax = _wertMax;
		}
	
		/**
		Wird von der formalen Plausibilitätsprüfung auf
								ja gesetzt, wenn Wert wegen
								Bereichsunterschreitung auf das Minimum gesetzt
								wurde.
		<p>
		
		</p>
		
		@return der Wert von WertMin.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 getWertMin() {
			return _wertMin;
		}
	
		/**
		Wird von der formalen Plausibilitätsprüfung auf
								ja gesetzt, wenn Wert wegen
								Bereichsunterschreitung auf das Minimum gesetzt
								wurde.
		<p>
		
		</p>
		
		@param _wertMin der neue Wert von WertMin.
		*/
		public void setWertMin(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
		 _wertMin) {
			this._wertMin = _wertMin;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getWertMax() != null) {
	                if (getWertMax().isZustand()) {
	                    datum.getUnscaledValue("WertMax").setText(getWertMax().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("WertMax").set(getWertMax().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getWertMin() != null) {
	                if (getWertMin().isZustand()) {
	                    datum.getUnscaledValue("WertMin").setText(getWertMin().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("WertMin").set(getWertMin().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("WertMax").isState()) {
							setWertMax(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							.getZustand(daten.getScaledValue("WertMax").getText()));
						} else {
						setWertMax(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
						(daten.
							getUnscaledValue
						("WertMax").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("WertMin").isState()) {
							setWertMin(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							.getZustand(daten.getScaledValue("WertMin").getText()));
						} else {
						setWertMin(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
						(daten.
							getUnscaledValue
						("WertMin").
								byteValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlStatusPlausibilitaetsPruefungFormal clone() {
		AtlStatusPlausibilitaetsPruefungFormal klon = new AtlStatusPlausibilitaetsPruefungFormal();
		
						klon.setWertMax(getWertMax());
						klon.setWertMin(getWertMin());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
