/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Statusinformationen werden von der logischen
					Plausibilitätsprügung gesetzt.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlStatusPlausibilitaetsPruefungLogisch implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _wertMaxLogisch
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _wertMinLogisch
			;
	
		/**
		Wird von der logischen Plausibilitätsprüfung auf
								ja gesetzt, wenn Wert wegen
								Bereichsüberschreitung auf das Maximum gesetzt
								wurde.
		<p>
		
		</p>
		
		@return der Wert von WertMaxLogisch.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 getWertMaxLogisch() {
			return _wertMaxLogisch;
		}
	
		/**
		Wird von der logischen Plausibilitätsprüfung auf
								ja gesetzt, wenn Wert wegen
								Bereichsüberschreitung auf das Maximum gesetzt
								wurde.
		<p>
		
		</p>
		
		@param _wertMaxLogisch der neue Wert von WertMaxLogisch.
		*/
		public void setWertMaxLogisch(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
		 _wertMaxLogisch) {
			this._wertMaxLogisch = _wertMaxLogisch;
		}
	
		/**
		Wird von der logischen Plausibilitätsprüfung auf
								ja gesetzt, wenn Wert wegen
								Bereichsunterschreitung auf das Minimum gesetzt
								wurde.
		<p>
		
		</p>
		
		@return der Wert von WertMinLogisch.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 getWertMinLogisch() {
			return _wertMinLogisch;
		}
	
		/**
		Wird von der logischen Plausibilitätsprüfung auf
								ja gesetzt, wenn Wert wegen
								Bereichsunterschreitung auf das Minimum gesetzt
								wurde.
		<p>
		
		</p>
		
		@param _wertMinLogisch der neue Wert von WertMinLogisch.
		*/
		public void setWertMinLogisch(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
		 _wertMinLogisch) {
			this._wertMinLogisch = _wertMinLogisch;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getWertMaxLogisch() != null) {
	                if (getWertMaxLogisch().isZustand()) {
	                    datum.getUnscaledValue("WertMaxLogisch").setText(getWertMaxLogisch().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("WertMaxLogisch").set(getWertMaxLogisch().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getWertMinLogisch() != null) {
	                if (getWertMinLogisch().isZustand()) {
	                    datum.getUnscaledValue("WertMinLogisch").setText(getWertMinLogisch().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("WertMinLogisch").set(getWertMinLogisch().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("WertMaxLogisch").isState()) {
							setWertMaxLogisch(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							.getZustand(daten.getScaledValue("WertMaxLogisch").getText()));
						} else {
						setWertMaxLogisch(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
						(daten.
							getUnscaledValue
						("WertMaxLogisch").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("WertMinLogisch").isState()) {
							setWertMinLogisch(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							.getZustand(daten.getScaledValue("WertMinLogisch").getText()));
						} else {
						setWertMinLogisch(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
						(daten.
							getUnscaledValue
						("WertMinLogisch").
								byteValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlStatusPlausibilitaetsPruefungLogisch clone() {
		AtlStatusPlausibilitaetsPruefungLogisch klon = new AtlStatusPlausibilitaetsPruefungLogisch();
		
						klon.setWertMaxLogisch(getWertMaxLogisch());
						klon.setWertMinLogisch(getWertMinLogisch());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
