/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Liste der verkehrlichen Beschränkungen (z. B. auf
					einem StraßenTeilSegment).
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlVerkehrsBeschraenkungen implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsBeschraenkung
			 _typ
			;
			private String
			 _zeitbereich
			= new String
			()
			;
	
		/**
		Typ der verkehrlichen Einschränkung.
		<p>
		
		</p>
		
		@return der Wert von Typ.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsBeschraenkung
			 getTyp() {
			return _typ;
		}
	
		/**
		Typ der verkehrlichen Einschränkung.
		<p>
		
		</p>
		
		@param _typ der neue Wert von Typ.
		*/
		public void setTyp(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsBeschraenkung
		 _typ) {
			this._typ = _typ;
		}
	
		/**
		Gültigkeitszeitbereich für die verkehrliche
								Einschränkung.
		<p>
		
		</p>
		
		@return der Wert von Zeitbereich.
		*/
			public String
			 getZeitbereich() {
			return _zeitbereich;
		}
	
		/**
		Gültigkeitszeitbereich für die verkehrliche
								Einschränkung.
		<p>
		
		</p>
		
		@param _zeitbereich der neue Wert von Zeitbereich.
		*/
		public void setZeitbereich(String
		 _zeitbereich) {
			if (_zeitbereich.length() > 128) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 128 + " Zeichen sein.");
			}
			this._zeitbereich = _zeitbereich;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getTyp() != null) {
	                if (getTyp().isZustand()) {
	                    datum.getUnscaledValue("Typ").setText(getTyp().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Typ").set(getTyp().getValue());
	                }
				}
				// ZeichenkettenAttributTyp
				if (getZeitbereich() != null) {
					datum.getTextValue("Zeitbereich").setText(getZeitbereich());
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Typ").isState()) {
							setTyp(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsBeschraenkung
							.getZustand(daten.getScaledValue("Typ").getText()));
						} else {
						setTyp(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsBeschraenkung
						(daten.
							getUnscaledValue
						("Typ").
								byteValue
						()));
						}
				// ZeichenkettenAttributTyp
					setZeitbereich(daten.getTextValue("Zeitbereich").getText());
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlVerkehrsBeschraenkungen clone() {
		AtlVerkehrsBeschraenkungen klon = new AtlVerkehrsBeschraenkungen();
		
						klon.setTyp(getTyp());
						klon.setZeitbereich(getZeitbereich());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
