/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Fahrzeugdichte bezogen auf Pkw-Einheiten.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
@Wertebereich(
	minimum = 0L,
	maximum = 10000L,
	einheit = "PkwE/km"
)
public class AttBemessungsFahrzeugDichte extends Zahl<		Short
> {
	
	private static final long serialVersionUID = 1L;
	
	/**
	 * Der minimale Wert des Attributs.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final 		Short
	 MIN_VALUE =
				Short
		.valueOf("0");
	
	/**
	 * Der maximale Wert des Attributs.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final 		Short
	 MAX_VALUE =
				Short
		.valueOf("10000");
	
	/**
	 * Die Einheit.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final String EINHEIT = "PkwE/km";
	
	/**
	Daten sind nicht ermittelbar (ist KEIN
								Fehler).
	<p>
	Wird gesetzt, wenn der entsprechende Wert
								nicht ermittelbar ist und kein Interpolation
								sinnvoll möglich ist (z.B. ist die
								Geschwindigkeit nicht ermittelbar, wenn kein
								Fahrzeug erfasst wurde).
	</p>
	*/
	public static final AttBemessungsFahrzeugDichte ZUSTAND_1N_NICHT_ERMITTELBAR = new AttBemessungsFahrzeugDichte("nicht ermittelbar", 		Short
	.valueOf("-1"));

	/**
	Daten sind fehlerhaft.
	<p>
	Wird gesetzt, wenn die Daten als fehlerhaft
								erkannt wurden.
	</p>
	*/
	public static final AttBemessungsFahrzeugDichte ZUSTAND_2N_FEHLERHAFT = new AttBemessungsFahrzeugDichte("fehlerhaft", 		Short
	.valueOf("-2"));

	/**
	Daten nicht ermittelbar, da bereits
								Basiswerte fehlerhaft.
	<p>
	Wird gesetzt, wenn Daten, die zur Berechnung
								dieses Werts notwendig sind, bereits als
								fehlerhaft gekennzeichnet sind, oder wenn
								die Berechnung aus anderen Gründen (z.B.
								Nenner = 0 in der Berechnungsformel) nicht
								möglich war.
	</p>
	*/
	public static final AttBemessungsFahrzeugDichte ZUSTAND_3N_NICHT_ERMITTELBAR_FEHLERHAFT = new AttBemessungsFahrzeugDichte("nicht ermittelbar/fehlerhaft", 		Short
	.valueOf("-3"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttBemessungsFahrzeugDichte getZustand(final 		Short
	 value) {
		for (AttBemessungsFahrzeugDichte e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttBemessungsFahrzeugDichte getZustand(final String value) {
		for (AttBemessungsFahrzeugDichte e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttBemessungsFahrzeugDichte> getZustaende() {
		List<AttBemessungsFahrzeugDichte> list = new ArrayList<AttBemessungsFahrzeugDichte>();
		list.add(ZUSTAND_1N_NICHT_ERMITTELBAR);
		list.add(ZUSTAND_2N_FEHLERHAFT);
		list.add(ZUSTAND_3N_NICHT_ERMITTELBAR_FEHLERHAFT);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut BemessungsFahrzeugDichte.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttBemessungsFahrzeugDichte(final 		Short
	 value) {
		super(value);
	}
	
	private AttBemessungsFahrzeugDichte(final String zustand, final 		Short
	 value) {
		super(zustand, value);
	}
	
}
