/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Lage des Fahrstreifens (HFS, 1.ÜFS,...). Der
					kleinste Wert innerhalb eines Messquerschnitts liegt
					rechts, die anderen Spuren in aufsteigender
					Reihenfolge links davon.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
@Wertebereich(
	minimum = -10L,
	maximum = 10L,
	einheit = ""
)
public class AttFahrStreifenLage extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	/**
	 * Der minimale Wert des Attributs.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final 		Byte
	 MIN_VALUE =
				Byte
		.valueOf("-10");
	
	/**
	 * Der maximale Wert des Attributs.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final 		Byte
	 MAX_VALUE =
				Byte
		.valueOf("10");
	
	/**
	 * Die Einheit.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final String EINHEIT = "";
	
	/**
	Hauptfahrstreifen.
	<p>
	
	</p>
	*/
	public static final AttFahrStreifenLage ZUSTAND_0_HFS = new AttFahrStreifenLage("HFS", 		Byte
	.valueOf("0"));

	/**
	1. Überholfahrstreifen.
	<p>
	
	</p>
	*/
	public static final AttFahrStreifenLage ZUSTAND_1__1UEFS = new AttFahrStreifenLage("1ÜFS", 		Byte
	.valueOf("1"));

	/**
	2. Überholfahrstreifen.
	<p>
	
	</p>
	*/
	public static final AttFahrStreifenLage ZUSTAND_2__2UEFS = new AttFahrStreifenLage("2ÜFS", 		Byte
	.valueOf("2"));

	/**
	3. Überholfahrstreifen.
	<p>
	
	</p>
	*/
	public static final AttFahrStreifenLage ZUSTAND_3__3UEFS = new AttFahrStreifenLage("3ÜFS", 		Byte
	.valueOf("3"));

	/**
	4. Überholfahrstreifen.
	<p>
	
	</p>
	*/
	public static final AttFahrStreifenLage ZUSTAND_4__4UEFS = new AttFahrStreifenLage("4ÜFS", 		Byte
	.valueOf("4"));

	/**
	5. Überholfahrstreifen.
	<p>
	
	</p>
	*/
	public static final AttFahrStreifenLage ZUSTAND_5__5UEFS = new AttFahrStreifenLage("5ÜFS", 		Byte
	.valueOf("5"));

	/**
	6. Überholfahrstreifen.
	<p>
	
	</p>
	*/
	public static final AttFahrStreifenLage ZUSTAND_6__6UEFS = new AttFahrStreifenLage("6ÜFS", 		Byte
	.valueOf("6"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttFahrStreifenLage getZustand(final 		Byte
	 value) {
		for (AttFahrStreifenLage e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttFahrStreifenLage getZustand(final String value) {
		for (AttFahrStreifenLage e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttFahrStreifenLage> getZustaende() {
		List<AttFahrStreifenLage> list = new ArrayList<AttFahrStreifenLage>();
		list.add(ZUSTAND_0_HFS);
		list.add(ZUSTAND_1__1UEFS);
		list.add(ZUSTAND_2__2UEFS);
		list.add(ZUSTAND_3__3UEFS);
		list.add(ZUSTAND_4__4UEFS);
		list.add(ZUSTAND_5__5UEFS);
		list.add(ZUSTAND_6__6UEFS);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut FahrStreifenLage.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttFahrStreifenLage(final 		Byte
	 value) {
		super(value);
	}
	
	private AttFahrStreifenLage(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
