/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Mögliche Optionen für das Verhalten beim Umgang mit
					geprüften Werten der logischen Plausibilitätsprüfung
					Verkehrsdaten.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AttOptionenPlausibilitaetsPruefungLogischVerkehr extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	Wertebereichsprüfungwird NICHT durchgeführt.
								Wert wird nicht verändert, es werden keine
								Statusflags gesetzt.
	<p>
	
	</p>
	*/
	public static final AttOptionenPlausibilitaetsPruefungLogischVerkehr ZUSTAND_0_KEINE_PRUEFUNG = new AttOptionenPlausibilitaetsPruefungLogischVerkehr("Keine Prüfung", 		Byte
	.valueOf("0"));

	/**
	Wertebereichsprüfung wird durchgeführt.
								Fehlerhafte Werte werden nicht verändert, es
								werden nur die Statusflags gesetzt.
	<p>
	
	</p>
	*/
	public static final AttOptionenPlausibilitaetsPruefungLogischVerkehr ZUSTAND_1_NURPRUEFUNG = new AttOptionenPlausibilitaetsPruefungLogischVerkehr("NurPrüfung", 		Byte
	.valueOf("1"));

	/**
	Wertebereichsprüfung wird durchgeführt. Bei
								Bereichsunter- bzw. überschreitung wird der
								Wert auf den parametrierten Min- bzw.
								&#47;Max-Wert korrigiert und die Statusflags
								gesetzt.
	<p>
	
	</p>
	*/
	public static final AttOptionenPlausibilitaetsPruefungLogischVerkehr ZUSTAND_2_SETZE_MINMAX = new AttOptionenPlausibilitaetsPruefungLogischVerkehr("Setze MinMax", 		Byte
	.valueOf("2"));

	/**
	Wertebereichsprüfung wird durchgeführt. Bei
								Bereichsunterschreitung wird der Wert auf
								den parametrierten Min-Wert korrigiert und
								die Statusflags gesetzt, ansonsten Verhalten
								wie bei Option"NurPrüfen".
	<p>
	
	</p>
	*/
	public static final AttOptionenPlausibilitaetsPruefungLogischVerkehr ZUSTAND_3_SETZE_MIN = new AttOptionenPlausibilitaetsPruefungLogischVerkehr("Setze Min", 		Byte
	.valueOf("3"));

	/**
	Wertebereichsprüfung wird durchgeführt. Bei
								Bereichsüberschreitung wird der Wert auf den
								parametrierten Max-Wert korrigiert und die
								Statusflags gesetzt, ansonsten Verhalten wie
								bei Option"NurPrüfen".
	<p>
	
	</p>
	*/
	public static final AttOptionenPlausibilitaetsPruefungLogischVerkehr ZUSTAND_4_SETZE_MAX = new AttOptionenPlausibilitaetsPruefungLogischVerkehr("Setze Max", 		Byte
	.valueOf("4"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttOptionenPlausibilitaetsPruefungLogischVerkehr getZustand(final 		Byte
	 value) {
		for (AttOptionenPlausibilitaetsPruefungLogischVerkehr e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttOptionenPlausibilitaetsPruefungLogischVerkehr getZustand(final String value) {
		for (AttOptionenPlausibilitaetsPruefungLogischVerkehr e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttOptionenPlausibilitaetsPruefungLogischVerkehr> getZustaende() {
		List<AttOptionenPlausibilitaetsPruefungLogischVerkehr> list = new ArrayList<AttOptionenPlausibilitaetsPruefungLogischVerkehr>();
		list.add(ZUSTAND_0_KEINE_PRUEFUNG);
		list.add(ZUSTAND_1_NURPRUEFUNG);
		list.add(ZUSTAND_2_SETZE_MINMAX);
		list.add(ZUSTAND_3_SETZE_MIN);
		list.add(ZUSTAND_4_SETZE_MAX);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut OptionenPlausibilitätsPrüfungLogischVerkehr.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttOptionenPlausibilitaetsPruefungLogischVerkehr(final 		Byte
	 value) {
		super(value);
	}
	
	private AttOptionenPlausibilitaetsPruefungLogischVerkehr(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
