/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Verfahren, aufgrund dessen der Störfall erkannt
					wurde.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 39
 */
public class AttStoerfallIndikatorVerfahren extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	Verfahren ist unbekannt.
	<p>
	
	</p>
	*/
	public static final AttStoerfallIndikatorVerfahren ZUSTAND_0_UNBEKANNT = new AttStoerfallIndikatorVerfahren("unbekannt", 		Byte
	.valueOf("0"));

	/**
	Verfahren der Störfallerkennung: gemäß MARZ.
	<p>
	
	</p>
	*/
	public static final AttStoerfallIndikatorVerfahren ZUSTAND_1_MARZ = new AttStoerfallIndikatorVerfahren("MARZ", 		Byte
	.valueOf("1"));

	/**
	Verfahren der Störfallerkennung:
								entsprechend NRW.
	<p>
	
	</p>
	*/
	public static final AttStoerfallIndikatorVerfahren ZUSTAND_2_NRW = new AttStoerfallIndikatorVerfahren("NRW", 		Byte
	.valueOf("2"));

	/**
	Verfahren der Störfallerkennung: RDS.
	<p>
	
	</p>
	*/
	public static final AttStoerfallIndikatorVerfahren ZUSTAND_3_RDS = new AttStoerfallIndikatorVerfahren("RDS", 		Byte
	.valueOf("3"));

	/**
	Verfahren der Störfallerkennung: lokale
								Störfallerkennung mit Fundamentaldiagramm.
	<p>
	
	</p>
	*/
	public static final AttStoerfallIndikatorVerfahren ZUSTAND_4_FUNDAMENTALDIAGRAMM = new AttStoerfallIndikatorVerfahren("FundamentalDiagramm", 		Byte
	.valueOf("4"));

	/**
	Verfahren der Störfallerkennung: Constraint.
	<p>
	
	</p>
	*/
	public static final AttStoerfallIndikatorVerfahren ZUSTAND_5_CONSTRAINT = new AttStoerfallIndikatorVerfahren("Constraint", 		Byte
	.valueOf("5"));

	/**
	Verfahren der Störfallerkennung: Fuzzy.
	<p>
	
	</p>
	*/
	public static final AttStoerfallIndikatorVerfahren ZUSTAND_6_FUZZY = new AttStoerfallIndikatorVerfahren("Fuzzy", 		Byte
	.valueOf("6"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttStoerfallIndikatorVerfahren getZustand(final 		Byte
	 value) {
		for (AttStoerfallIndikatorVerfahren e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttStoerfallIndikatorVerfahren getZustand(final String value) {
		for (AttStoerfallIndikatorVerfahren e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttStoerfallIndikatorVerfahren> getZustaende() {
		List<AttStoerfallIndikatorVerfahren> list = new ArrayList<AttStoerfallIndikatorVerfahren>();
		list.add(ZUSTAND_0_UNBEKANNT);
		list.add(ZUSTAND_1_MARZ);
		list.add(ZUSTAND_2_NRW);
		list.add(ZUSTAND_3_RDS);
		list.add(ZUSTAND_4_FUNDAMENTALDIAGRAMM);
		list.add(ZUSTAND_5_CONSTRAINT);
		list.add(ZUSTAND_6_FUZZY);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut StörfallIndikatorVerfahren.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttStoerfallIndikatorVerfahren(final 		Byte
	 value) {
		super(value);
	}
	
	private AttStoerfallIndikatorVerfahren(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
