/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Verkehrssituation (Level Of Service).
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AttStoerfallSituation extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	Ermittlung aufgrund einer Störung nicht
								möglich.
	<p>
	
	</p>
	*/
	public static final AttStoerfallSituation ZUSTAND_0_STOERUNG = new AttStoerfallSituation("Störung", 		Byte
	.valueOf("0"));

	/**
	Es liegt noch kein Ergebniss vor, die
								Detektion wurde passiviert bzw. es ist gar
								keine Detektion vorhanden.
	<p>
	
	</p>
	*/
	public static final AttStoerfallSituation ZUSTAND_1_KEINE_AUSSAGE = new AttStoerfallSituation("keine Aussage", 		Byte
	.valueOf("1"));

	/**
	Interpretation ist abhängig vom Verfahren,
								das den Störfall erkannt hat.
	<p>
	
	</p>
	*/
	public static final AttStoerfallSituation ZUSTAND_2_FREIER_VERKEHR = new AttStoerfallSituation("freier Verkehr", 		Byte
	.valueOf("2"));

	/**
	Interpretation ist abhängig vom Verfahren,
								das den Störfall erkannt hat.
	<p>
	
	</p>
	*/
	public static final AttStoerfallSituation ZUSTAND_3_LEBHAFTER_VERKEHR = new AttStoerfallSituation("lebhafter Verkehr", 		Byte
	.valueOf("3"));

	/**
	Interpretation ist abhängig vom Verfahren,
								das den Störfall erkannt hat.
	<p>
	
	</p>
	*/
	public static final AttStoerfallSituation ZUSTAND_4_DICHTER_VERKEHR = new AttStoerfallSituation("dichter Verkehr", 		Byte
	.valueOf("4"));

	/**
	Interpretation ist abhängig vom Verfahren,
								das den Störfall erkannt hat.
	<p>
	
	</p>
	*/
	public static final AttStoerfallSituation ZUSTAND_5_ZAEHFLIESSENDER_VERKEHR = new AttStoerfallSituation("zähfließender Verkehr", 		Byte
	.valueOf("5"));

	/**
	Interpretation ist abhängig vom Verfahren,
								das den Störfall erkannt hat.
	<p>
	
	</p>
	*/
	public static final AttStoerfallSituation ZUSTAND_6_STOCKENDER_VERKEHR = new AttStoerfallSituation("stockender Verkehr", 		Byte
	.valueOf("6"));

	/**
	Interpretation ist abhängig vom Verfahren,
								das den Störfall erkannt hat.
	<p>
	
	</p>
	*/
	public static final AttStoerfallSituation ZUSTAND_7_STAU = new AttStoerfallSituation("Stau", 		Byte
	.valueOf("7"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttStoerfallSituation getZustand(final 		Byte
	 value) {
		for (AttStoerfallSituation e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttStoerfallSituation getZustand(final String value) {
		for (AttStoerfallSituation e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttStoerfallSituation> getZustaende() {
		List<AttStoerfallSituation> list = new ArrayList<AttStoerfallSituation>();
		list.add(ZUSTAND_0_STOERUNG);
		list.add(ZUSTAND_1_KEINE_AUSSAGE);
		list.add(ZUSTAND_2_FREIER_VERKEHR);
		list.add(ZUSTAND_3_LEBHAFTER_VERKEHR);
		list.add(ZUSTAND_4_DICHTER_VERKEHR);
		list.add(ZUSTAND_5_ZAEHFLIESSENDER_VERKEHR);
		list.add(ZUSTAND_6_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_7_STAU);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut StörfallSituation.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttStoerfallSituation(final 		Byte
	 value) {
		super(value);
	}
	
	private AttStoerfallSituation(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
