/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Typ des Straßenknotens (AutobahnKreuz,
					Anschlussstelle, ...) entsprechend der LCL-Typenliste.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 53
 */
public class AttStrassenKnotenTypErweitert extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	Sonstiger unspezifizierter Knoten.
	<p>
	
	</p>
	*/
	public static final AttStrassenKnotenTypErweitert ZUSTAND_0_SONSTIGERKNOTEN = new AttStrassenKnotenTypErweitert("SonstigerKnoten", 		Byte
	.valueOf("0"));

	/**
	Knoten ist ein Autobahnkreuz.
	<p>
	
	</p>
	*/
	public static final AttStrassenKnotenTypErweitert ZUSTAND_1_AUTOBAHNKREUZ = new AttStrassenKnotenTypErweitert("AutobahnKreuz", 		Byte
	.valueOf("1"));

	/**
	Knoten ist ein Autobahndreieck.
	<p>
	
	</p>
	*/
	public static final AttStrassenKnotenTypErweitert ZUSTAND_2_AUTOBAHNDREIECK = new AttStrassenKnotenTypErweitert("AutobahnDreieck", 		Byte
	.valueOf("2"));

	/**
	Knoten ist eine Autobahnanschlussstelle.
	<p>
	
	</p>
	*/
	public static final AttStrassenKnotenTypErweitert ZUSTAND_3_AUTOBAHNANSCHLUSSSTELLE = new AttStrassenKnotenTypErweitert("AutobahnAnschlussStelle", 		Byte
	.valueOf("3"));

	/**
	Knoten markiert Parkplatz (einschließlich Rastplätzen, Raststätten etc.).
	<p>
	
	</p>
	*/
	public static final AttStrassenKnotenTypErweitert ZUSTAND_4_PARKPLATZ = new AttStrassenKnotenTypErweitert("Parkplatz", 		Byte
	.valueOf("4"));

	/**
	Punkt auf einer Straße, an dem sich ein wesentliches Attribut der Straße ändert
								(Straßennummer, -name oder der administrative Status).
	<p>
	
	</p>
	*/
	public static final AttStrassenKnotenTypErweitert ZUSTAND_5_UEBERGANG = new AttStrassenKnotenTypErweitert("Übergang", 		Byte
	.valueOf("5"));

	/**
	Knotenpunkt, wo der Verkehr um eine zentrale Verkehrsinsel geführt wird.
	<p>
	
	</p>
	*/
	public static final AttStrassenKnotenTypErweitert ZUSTAND_6_KREISVERKEHR = new AttStrassenKnotenTypErweitert("Kreisverkehr", 		Byte
	.valueOf("6"));

	/**
	Allgemeiner Knoten im Nachgeordneten Netz incl. Kreuzungen, Über- und Unterführungen,
								Einmündungen, Ampelkreuzungen, Anschlussstellen etc.
	<p>
	
	</p>
	*/
	public static final AttStrassenKnotenTypErweitert ZUSTAND_7_KNOTEN = new AttStrassenKnotenTypErweitert("Knoten", 		Byte
	.valueOf("7"));

	/**
	Mit Namen versehener Punkt, wo die Straße über eine signifikante Länge eingehüllt ist.
	<p>
	
	</p>
	*/
	public static final AttStrassenKnotenTypErweitert ZUSTAND_8_TUNNEL = new AttStrassenKnotenTypErweitert("Tunnel", 		Byte
	.valueOf("8"));

	/**
	Mit Namen versehener Punkt, wo die Straße von einem Hochbauwerk getragen wird.
	<p>
	
	</p>
	*/
	public static final AttStrassenKnotenTypErweitert ZUSTAND_9_BRUECKE_ODER_VIADUKT = new AttStrassenKnotenTypErweitert("Brücke oder Viadukt", 		Byte
	.valueOf("9"));

	/**
	Ort, wo die Grenze eines administrativen Gebietes ein Segment oder Netz kreuzt.
	<p>
	
	</p>
	*/
	public static final AttStrassenKnotenTypErweitert ZUSTAND_10_GRENZUEBERGANG = new AttStrassenKnotenTypErweitert("Grenzübergang", 		Byte
	.valueOf("10"));

	/**
	Ort, wo die Kraftfahrer für die Benutzung gebührenpflichtiger Straßen bezahlen.
	<p>
	
	</p>
	*/
	public static final AttStrassenKnotenTypErweitert ZUSTAND_11_MAUTSTATION = new AttStrassenKnotenTypErweitert("Mautstation", 		Byte
	.valueOf("11"));

	/**
	Ort, an welchem Autofahrer Zufahrt&#47;Abfahrt zu einer Fähre haben.
	<p>
	
	</p>
	*/
	public static final AttStrassenKnotenTypErweitert ZUSTAND_12_FAEHRANLEGER = new AttStrassenKnotenTypErweitert("Fähranleger", 		Byte
	.valueOf("12"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttStrassenKnotenTypErweitert getZustand(final 		Byte
	 value) {
		for (AttStrassenKnotenTypErweitert e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttStrassenKnotenTypErweitert getZustand(final String value) {
		for (AttStrassenKnotenTypErweitert e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttStrassenKnotenTypErweitert> getZustaende() {
		List<AttStrassenKnotenTypErweitert> list = new ArrayList<AttStrassenKnotenTypErweitert>();
		list.add(ZUSTAND_0_SONSTIGERKNOTEN);
		list.add(ZUSTAND_1_AUTOBAHNKREUZ);
		list.add(ZUSTAND_2_AUTOBAHNDREIECK);
		list.add(ZUSTAND_3_AUTOBAHNANSCHLUSSSTELLE);
		list.add(ZUSTAND_4_PARKPLATZ);
		list.add(ZUSTAND_5_UEBERGANG);
		list.add(ZUSTAND_6_KREISVERKEHR);
		list.add(ZUSTAND_7_KNOTEN);
		list.add(ZUSTAND_8_TUNNEL);
		list.add(ZUSTAND_9_BRUECKE_ODER_VIADUKT);
		list.add(ZUSTAND_10_GRENZUEBERGANG);
		list.add(ZUSTAND_11_MAUTSTATION);
		list.add(ZUSTAND_12_FAEHRANLEGER);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut StraßenKnotenTypErweitert.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttStrassenKnotenTypErweitert(final 		Byte
	 value) {
		super(value);
	}
	
	private AttStrassenKnotenTypErweitert(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
