/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Typ der Straße (Autobahn, Bundesstraße,
					Landesstraße,...) entsprechend der LCL-Typenliste.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 53
 */
public class AttStrassenTypErweitert extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	Sonstiger Straßentyp.
	<p>
	
	</p>
	*/
	public static final AttStrassenTypErweitert ZUSTAND_0_SONSTIGESTRASSE = new AttStrassenTypErweitert("SonstigeStraße", 		Byte
	.valueOf("0"));

	/**
	Straße ist Autobahn.
	<p>
	
	</p>
	*/
	public static final AttStrassenTypErweitert ZUSTAND_1_AUTOBAHN = new AttStrassenTypErweitert("Autobahn", 		Byte
	.valueOf("1"));

	/**
	Straße ist Bundesstraße.
	<p>
	
	</p>
	*/
	public static final AttStrassenTypErweitert ZUSTAND_2_BUNDESSTRASSE = new AttStrassenTypErweitert("Bundesstraße", 		Byte
	.valueOf("2"));

	/**
	Straße ist Landes- oder Staatsstraße.
	<p>
	
	</p>
	*/
	public static final AttStrassenTypErweitert ZUSTAND_3_LANDES_ODER_STAATSSTRASSE = new AttStrassenTypErweitert("Landes- oder Staatsstraße", 		Byte
	.valueOf("3"));

	/**
	Straße ist Kreisstraße.
	<p>
	
	</p>
	*/
	public static final AttStrassenTypErweitert ZUSTAND_4_KREISSTRASSE = new AttStrassenTypErweitert("Kreisstraße", 		Byte
	.valueOf("4"));

	/**
	Straße ist Autobahnring ohne Anfangs- und Endpunkt.
	<p>
	
	</p>
	*/
	public static final AttStrassenTypErweitert ZUSTAND_5_AUTOBAHNRING = new AttStrassenTypErweitert("Autobahnring", 		Byte
	.valueOf("5"));

	/**
	Ringstraße, die keine Autobahn ist.
	<p>
	
	</p>
	*/
	public static final AttStrassenTypErweitert ZUSTAND_6_RINGSTRASSE = new AttStrassenTypErweitert("Ringstraße", 		Byte
	.valueOf("6"));

	/**
	Straße ist Stadt- oder Gemeindestraße.
	<p>
	
	</p>
	*/
	public static final AttStrassenTypErweitert ZUSTAND_7_STADT_ODER_GEMEINDESTRASSE = new AttStrassenTypErweitert("Stadt- oder Gemeindestraße", 		Byte
	.valueOf("7"));

	/**
	Spezieller Dienst, der mittels RO-RO-Schiff Straßenfahrzeuge zwischen zwei Punkten
								transportiert.
	<p>
	
	</p>
	*/
	public static final AttStrassenTypErweitert ZUSTAND_8_FAEHRVERBINDUNG = new AttStrassenTypErweitert("Fährverbindung", 		Byte
	.valueOf("8"));

	/**
	Spezieller Dienst, der mittels Zug Straßenfahrzeuge zwischen zwei Punkten transportiert.
	<p>
	
	</p>
	*/
	public static final AttStrassenTypErweitert ZUSTAND_9_AUTOREISEZUGVERBINDUNG = new AttStrassenTypErweitert("Autoreisezugverbindung", 		Byte
	.valueOf("9"));

	/**
	Straße ist Verbindungsstraße.
	<p>
	
	</p>
	*/
	public static final AttStrassenTypErweitert ZUSTAND_10_VERBINDUNGSSTRASSE = new AttStrassenTypErweitert("Verbindungsstraße", 		Byte
	.valueOf("10"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttStrassenTypErweitert getZustand(final 		Byte
	 value) {
		for (AttStrassenTypErweitert e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttStrassenTypErweitert getZustand(final String value) {
		for (AttStrassenTypErweitert e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttStrassenTypErweitert> getZustaende() {
		List<AttStrassenTypErweitert> list = new ArrayList<AttStrassenTypErweitert>();
		list.add(ZUSTAND_0_SONSTIGESTRASSE);
		list.add(ZUSTAND_1_AUTOBAHN);
		list.add(ZUSTAND_2_BUNDESSTRASSE);
		list.add(ZUSTAND_3_LANDES_ODER_STAATSSTRASSE);
		list.add(ZUSTAND_4_KREISSTRASSE);
		list.add(ZUSTAND_5_AUTOBAHNRING);
		list.add(ZUSTAND_6_RINGSTRASSE);
		list.add(ZUSTAND_7_STADT_ODER_GEMEINDESTRASSE);
		list.add(ZUSTAND_8_FAEHRVERBINDUNG);
		list.add(ZUSTAND_9_AUTOREISEZUGVERBINDUNG);
		list.add(ZUSTAND_10_VERBINDUNGSSTRASSE);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut StraßenTypErweitert.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttStrassenTypErweitert(final 		Byte
	 value) {
		super(value);
	}
	
	private AttStrassenTypErweitert(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
