/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Attributtyp zur Identifikation der einzelnen
					SWE-Einheiten der DuA.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 7
 */
public class AttSweTyp extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	
	<p>
	
	</p>
	*/
	public static final AttSweTyp ZUSTAND_1_SWE_PL_PRUEFUNG_FORMAL = new AttSweTyp("SWE_PL_Prüfung_formal", 		Byte
	.valueOf("1"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttSweTyp ZUSTAND_2_SWE_PL_PRUEFUNG_LOGISCH_LVE = new AttSweTyp("SWE_PL_Prüfung_logisch_LVE", 		Byte
	.valueOf("2"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttSweTyp ZUSTAND_3_SWE_PL_PRUEFUNG_LOGISCH_UFD = new AttSweTyp("SWE_PL_Prüfung_logisch UFD", 		Byte
	.valueOf("3"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttSweTyp ZUSTAND_4_SWE_PL_PRUEFUNG_LOGISCH_WZG = new AttSweTyp("SWE_PL_Prüfung_logisch WZG", 		Byte
	.valueOf("4"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttSweTyp ZUSTAND_5_SWE_MESSWERTERSETZUNG_LVE = new AttSweTyp("SWE_Messwertersetzung_LVE", 		Byte
	.valueOf("5"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttSweTyp ZUSTAND_6_SWE_ABFRAGE_PUFFERDATEN = new AttSweTyp("SWE_Abfrage_Pufferdaten", 		Byte
	.valueOf("6"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttSweTyp ZUSTAND_7_SWE_DATENAUFBEREITUNG_LVE = new AttSweTyp("SWE_Datenaufbereitung_LVE", 		Byte
	.valueOf("7"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttSweTyp ZUSTAND_8_SWE_DATENAUFBEREITUNG_UFD = new AttSweTyp("SWE_Datenaufbereitung_UFD", 		Byte
	.valueOf("8"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttSweTyp ZUSTAND_9_SWE_AGGREGATION_LVE = new AttSweTyp("SWE_Aggregation_LVE", 		Byte
	.valueOf("9"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttSweTyp ZUSTAND_10_SWE_ERGAENZUNG_BAST = new AttSweTyp("SWE_Ergänzung_BAST", 		Byte
	.valueOf("10"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttSweTyp ZUSTAND_11_SWE_GUETEBERECHNUNG = new AttSweTyp("SWE_Güteberechnung", 		Byte
	.valueOf("11"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttSweTyp ZUSTAND_12_SWE_MESSWERTERSETZUNG_UFD = new AttSweTyp("SWE_Messwertersetzung_UFD", 		Byte
	.valueOf("12"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttSweTyp ZUSTAND_13_SWE_PL_PRUEFUNG_LANGZEIT_UFD = new AttSweTyp("SWE_PL_Prüfung_Langzeit_UFD", 		Byte
	.valueOf("13"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttSweTyp ZUSTAND_14_SWE_DUA_GLAETTEWARNUNG_UND_PROGNOSE = new AttSweTyp("SWE_DuA_Glättewarnung_und_Prognose", 		Byte
	.valueOf("14"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttSweTyp getZustand(final 		Byte
	 value) {
		for (AttSweTyp e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttSweTyp getZustand(final String value) {
		for (AttSweTyp e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttSweTyp> getZustaende() {
		List<AttSweTyp> list = new ArrayList<AttSweTyp>();
		list.add(ZUSTAND_1_SWE_PL_PRUEFUNG_FORMAL);
		list.add(ZUSTAND_2_SWE_PL_PRUEFUNG_LOGISCH_LVE);
		list.add(ZUSTAND_3_SWE_PL_PRUEFUNG_LOGISCH_UFD);
		list.add(ZUSTAND_4_SWE_PL_PRUEFUNG_LOGISCH_WZG);
		list.add(ZUSTAND_5_SWE_MESSWERTERSETZUNG_LVE);
		list.add(ZUSTAND_6_SWE_ABFRAGE_PUFFERDATEN);
		list.add(ZUSTAND_7_SWE_DATENAUFBEREITUNG_LVE);
		list.add(ZUSTAND_8_SWE_DATENAUFBEREITUNG_UFD);
		list.add(ZUSTAND_9_SWE_AGGREGATION_LVE);
		list.add(ZUSTAND_10_SWE_ERGAENZUNG_BAST);
		list.add(ZUSTAND_11_SWE_GUETEBERECHNUNG);
		list.add(ZUSTAND_12_SWE_MESSWERTERSETZUNG_UFD);
		list.add(ZUSTAND_13_SWE_PL_PRUEFUNG_LANGZEIT_UFD);
		list.add(ZUSTAND_14_SWE_DUA_GLAETTEWARNUNG_UND_PROGNOSE);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut SWETyp.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttSweTyp(final 		Byte
	 value) {
		super(value);
	}
	
	private AttSweTyp(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
