/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Typ der verkehrlichen Einschränkungen.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AttVerkehrsBeschraenkung extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	Nicht näher spezifizierte Einschränkung.
	<p>
	
	</p>
	*/
	public static final AttVerkehrsBeschraenkung ZUSTAND_0_SONSTIGE = new AttVerkehrsBeschraenkung("sonstige", 		Byte
	.valueOf("0"));

	/**
	Überholverbot allgemein.
	<p>
	
	</p>
	*/
	public static final AttVerkehrsBeschraenkung ZUSTAND_1_UEBERHOLVERBOT = new AttVerkehrsBeschraenkung("Überholverbot", 		Byte
	.valueOf("1"));

	/**
	Überholverbot für LKW.
	<p>
	
	</p>
	*/
	public static final AttVerkehrsBeschraenkung ZUSTAND_2_UEBERHOLVERBOT_FUER_LKW = new AttVerkehrsBeschraenkung("Überholverbot für LKW", 		Byte
	.valueOf("2"));

	/**
	Überholverbot bei Nässe.
	<p>
	
	</p>
	*/
	public static final AttVerkehrsBeschraenkung ZUSTAND_3_UEBERHOLVERBOT_BEI_NAESSE = new AttVerkehrsBeschraenkung("Überholverbot bei Nässe", 		Byte
	.valueOf("3"));

	/**
	Allgemeine statische
								Geschwindigkeitsbeschränkung.
	<p>
	
	</p>
	*/
	public static final AttVerkehrsBeschraenkung ZUSTAND_4_HOECHSTGEWINDIGKEIT_ALLGEMEIN = new AttVerkehrsBeschraenkung("Höchstgewindigkeit Allgemein", 		Byte
	.valueOf("4"));

	/**
	Allgemeine statische
								Geschwindigkeitsbeschränkung auf 10 km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttVerkehrsBeschraenkung ZUSTAND_13_HOECHSTGESCHWINDIGKEIT_10_KM_H = new AttVerkehrsBeschraenkung("Höchstgeschwindigkeit 10 km/h", 		Byte
	.valueOf("13"));

	/**
	Allgemeine statische
								Geschwindigkeitsbeschränkung auf 20 km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttVerkehrsBeschraenkung ZUSTAND_14_HOECHSTGESCHWINDIGKEIT_20_KM_H = new AttVerkehrsBeschraenkung("Höchstgeschwindigkeit 20 km/h", 		Byte
	.valueOf("14"));

	/**
	Allgemeine statische
								Geschwindigkeitsbeschränkung auf 30 km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttVerkehrsBeschraenkung ZUSTAND_15_HOECHSTGESCHWINDIGKEIT_30_KM_H = new AttVerkehrsBeschraenkung("Höchstgeschwindigkeit 30 km/h", 		Byte
	.valueOf("15"));

	/**
	Allgemeine statische
								Geschwindigkeitsbeschränkung auf 40 km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttVerkehrsBeschraenkung ZUSTAND_5_HOECHSTGESCHWINDIGKEIT_40_KM_H = new AttVerkehrsBeschraenkung("Höchstgeschwindigkeit 40 km/h", 		Byte
	.valueOf("5"));

	/**
	Allgemeine statische
								Geschwindigkeitsbeschränkung auf 50 km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttVerkehrsBeschraenkung ZUSTAND_6_HOECHSTGESCHWINDIGKEIT_50_KM_H = new AttVerkehrsBeschraenkung("Höchstgeschwindigkeit 50 km/h", 		Byte
	.valueOf("6"));

	/**
	Allgemeine statische
								Geschwindigkeitsbeschränkung auf 60 km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttVerkehrsBeschraenkung ZUSTAND_7_HOECHSTGESCHWINDIGKEIT_60_KM_H = new AttVerkehrsBeschraenkung("Höchstgeschwindigkeit 60 km/h", 		Byte
	.valueOf("7"));

	/**
	Allgemeine statische
								Geschwindigkeitsbeschränkung auf 70 km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttVerkehrsBeschraenkung ZUSTAND_8_HOECHSTGESCHWINDIGKEIT_70_KM_H = new AttVerkehrsBeschraenkung("Höchstgeschwindigkeit 70 km/h", 		Byte
	.valueOf("8"));

	/**
	Allgemeine statische
								Geschwindigkeitsbeschränkung auf 80 km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttVerkehrsBeschraenkung ZUSTAND_9_HOECHSTGESCHWINDIGKEIT_80_KM_H = new AttVerkehrsBeschraenkung("Höchstgeschwindigkeit 80 km/h", 		Byte
	.valueOf("9"));

	/**
	Allgemeine statische
								Geschwindigkeitsbeschränkung auf 100 km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttVerkehrsBeschraenkung ZUSTAND_10_HOECHSTGESCHWINDIGKEIT_100_KM_H = new AttVerkehrsBeschraenkung("Höchstgeschwindigkeit 100 km/h", 		Byte
	.valueOf("10"));

	/**
	Allgemeine statische
								Geschwindigkeitsbeschränkung auf 120 km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttVerkehrsBeschraenkung ZUSTAND_11_HOECHSTGESCHWINDIGKEIT_120_KM_H = new AttVerkehrsBeschraenkung("Höchstgeschwindigkeit 120 km/h", 		Byte
	.valueOf("11"));

	/**
	Allgemeine statische
								Geschwindigkeitsbeschränkung auf 130 km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttVerkehrsBeschraenkung ZUSTAND_12_HOECHSTGESCHWINDIGKEIT_130_KM_H = new AttVerkehrsBeschraenkung("Höchstgeschwindigkeit 130 km/h", 		Byte
	.valueOf("12"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttVerkehrsBeschraenkung getZustand(final 		Byte
	 value) {
		for (AttVerkehrsBeschraenkung e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttVerkehrsBeschraenkung getZustand(final String value) {
		for (AttVerkehrsBeschraenkung e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttVerkehrsBeschraenkung> getZustaende() {
		List<AttVerkehrsBeschraenkung> list = new ArrayList<AttVerkehrsBeschraenkung>();
		list.add(ZUSTAND_0_SONSTIGE);
		list.add(ZUSTAND_1_UEBERHOLVERBOT);
		list.add(ZUSTAND_2_UEBERHOLVERBOT_FUER_LKW);
		list.add(ZUSTAND_3_UEBERHOLVERBOT_BEI_NAESSE);
		list.add(ZUSTAND_4_HOECHSTGEWINDIGKEIT_ALLGEMEIN);
		list.add(ZUSTAND_13_HOECHSTGESCHWINDIGKEIT_10_KM_H);
		list.add(ZUSTAND_14_HOECHSTGESCHWINDIGKEIT_20_KM_H);
		list.add(ZUSTAND_15_HOECHSTGESCHWINDIGKEIT_30_KM_H);
		list.add(ZUSTAND_5_HOECHSTGESCHWINDIGKEIT_40_KM_H);
		list.add(ZUSTAND_6_HOECHSTGESCHWINDIGKEIT_50_KM_H);
		list.add(ZUSTAND_7_HOECHSTGESCHWINDIGKEIT_60_KM_H);
		list.add(ZUSTAND_8_HOECHSTGESCHWINDIGKEIT_70_KM_H);
		list.add(ZUSTAND_9_HOECHSTGESCHWINDIGKEIT_80_KM_H);
		list.add(ZUSTAND_10_HOECHSTGESCHWINDIGKEIT_100_KM_H);
		list.add(ZUSTAND_11_HOECHSTGESCHWINDIGKEIT_120_KM_H);
		list.add(ZUSTAND_12_HOECHSTGESCHWINDIGKEIT_130_KM_H);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut VerkehrsBeschränkung.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttVerkehrsBeschraenkung(final 		Byte
	 value) {
		super(value);
	}
	
	private AttVerkehrsBeschraenkung(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
