/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Angabe eines Zyklus relativ zum aktuellen Zyklus
					(0=aktueller Zyklus, 1=letzter Zyklus, ..., 127).
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 12
 */
@Wertebereich(
	minimum = 0L,
	maximum = 127L,
	einheit = ""
)
public class AttZyklus extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	/**
	 * Der minimale Wert des Attributs.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final 		Byte
	 MIN_VALUE =
				Byte
		.valueOf("0");
	
	/**
	 * Der maximale Wert des Attributs.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final 		Byte
	 MAX_VALUE =
				Byte
		.valueOf("127");
	
	/**
	 * Die Einheit.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final String EINHEIT = "";
	
	/**
	
	<p>
	
	</p>
	*/
	public static final AttZyklus ZUSTAND_0_AKTUELLER_ZYKLUS = new AttZyklus("aktueller Zyklus", 		Byte
	.valueOf("0"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttZyklus ZUSTAND_1_LETZTER_ZYKLUS = new AttZyklus("letzter Zyklus", 		Byte
	.valueOf("1"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttZyklus ZUSTAND_2_VORLETZTER_ZYKLUS = new AttZyklus("vorletzter Zyklus", 		Byte
	.valueOf("2"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttZyklus ZUSTAND_3_VORVORLETZTER_ZYKLUS = new AttZyklus("vorvorletzter Zyklus", 		Byte
	.valueOf("3"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttZyklus getZustand(final 		Byte
	 value) {
		for (AttZyklus e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttZyklus getZustand(final String value) {
		for (AttZyklus e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttZyklus> getZustaende() {
		List<AttZyklus> list = new ArrayList<AttZyklus>();
		list.add(ZUSTAND_0_AKTUELLER_ZYKLUS);
		list.add(ZUSTAND_1_LETZTER_ZYKLUS);
		list.add(ZUSTAND_2_VORLETZTER_ZYKLUS);
		list.add(ZUSTAND_3_VORVORLETZTER_ZYKLUS);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut Zyklus.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttZyklus(final 		Byte
	 value) {
		super(value);
	}
	
	private AttZyklus(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
