/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Konfigurierende Eigenschaften der Objekte des Typs.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 10
 */
public class KdFahrStreifen extends AbstractKonfigurationsDatensatz<KdFahrStreifen.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Eigenschaften,
				};
			}
	
			/**
			 * Wird für konfigurierende Attributgruppen verwendet. Über die entsprechende Attributgruppe werden die konkreten Eigenschaften eines Objekts festgelegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Eigenschaften = new Aspekte("Eigenschaften", "asp.eigenschaften");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractDatum implements KonfigurationsDatum {
		
		/**
		 * Initialisiert das Datum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrStreifenTyp
				 _typ
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrStreifenLage
				 _lage
				;
				private 	Object
				 _fahrStreifenQuelle
				;
				private 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.FahrStreifen
				 _ersatzFahrStreifen
				;
		
			/**
			Typ des FahrStreifens (HFS, ÜFS,
									LkwKriechspur...).
			<p>
			
			</p>
			
			@return der Wert von Typ.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrStreifenTyp
				 getTyp() {
				return _typ;
			}
		
			/**
			Typ des FahrStreifens (HFS, ÜFS,
									LkwKriechspur...).
			<p>
			
			</p>
			
			@param _typ der neue Wert von Typ.
			*/
			public void setTyp(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrStreifenTyp
			 _typ) {
				this._typ = _typ;
			}
		
			/**
			Lage des FahrStreifens (HFS, 1.ÜFS,....).
			<p>
			
			</p>
			
			@return der Wert von Lage.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrStreifenLage
				 getLage() {
				return _lage;
			}
		
			/**
			Lage des FahrStreifens (HFS, 1.ÜFS,....).
			<p>
			
			</p>
			
			@param _lage der neue Wert von Lage.
			*/
			public void setLage(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrStreifenLage
			 _lage) {
				this._lage = _lage;
			}
		
			/**
			Referenz auf das Objekt, welches die Daten für
									diesen Fahrstreifen liefert (z. B. LVE-DE gemäß
									TLS).
			<p>
			
			</p>
			
			@return der Wert von FahrStreifenQuelle.
			*/
				public 	Object
				 getFahrStreifenQuelle() {
				return _fahrStreifenQuelle;
			}
		
			/**
			Referenz auf das Objekt, welches die Daten für
									diesen Fahrstreifen liefert (z. B. LVE-DE gemäß
									TLS).
			<p>
			
			</p>
			
			@param _fahrStreifenQuelle der neue Wert von FahrStreifenQuelle.
			*/
			public void setFahrStreifenQuelle(	Object
			 _fahrStreifenQuelle) {
				this._fahrStreifenQuelle = _fahrStreifenQuelle;
			}
		
			/**
			Ersatzfahrstreifen für die Messwertersetzung.
			<p>
			
			</p>
			
			@return der Wert von ErsatzFahrStreifen.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.FahrStreifen
				 getErsatzFahrStreifen() {
				return _ersatzFahrStreifen;
			}
		
			/**
			Ersatzfahrstreifen für die Messwertersetzung.
			<p>
			
			</p>
			
			@param _ersatzFahrStreifen der neue Wert von ErsatzFahrStreifen.
			*/
			public void setErsatzFahrStreifen(	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.FahrStreifen
			 _ersatzFahrStreifen) {
				this._ersatzFahrStreifen = _ersatzFahrStreifen;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getTyp() != null) {
		                if (getTyp().isZustand()) {
		                    datum.getUnscaledValue("Typ").setText(getTyp().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Typ").set(getTyp().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getLage() != null) {
		                if (getLage().isZustand()) {
		                    datum.getUnscaledValue("Lage").setText(getLage().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Lage").set(getLage().getValue());
		                }
					}
					// ObjektReferenzAttributTyp
						final Object soFahrStreifenQuelle = getFahrStreifenQuelle();
						final SystemObject tmpFahrStreifenQuelle;
							if (soFahrStreifenQuelle instanceof SystemObject) {
								tmpFahrStreifenQuelle = (SystemObject)soFahrStreifenQuelle;
							} else if(soFahrStreifenQuelle instanceof SystemObjekt){
								tmpFahrStreifenQuelle = ((SystemObjekt)soFahrStreifenQuelle).getSystemObject();
							} else{
								tmpFahrStreifenQuelle = null;
							}
						datum.getReferenceValue("FahrStreifenQuelle").setSystemObject(tmpFahrStreifenQuelle);
					// ObjektReferenzAttributTyp
						final Object soErsatzFahrStreifen = getErsatzFahrStreifen();
						final SystemObject tmpErsatzFahrStreifen;
							if (soErsatzFahrStreifen instanceof SystemObject) {
								tmpErsatzFahrStreifen = (SystemObject)soErsatzFahrStreifen;
							} else if(soErsatzFahrStreifen instanceof SystemObjekt){
								tmpErsatzFahrStreifen = ((SystemObjekt)soErsatzFahrStreifen).getSystemObject();
							} else{
								tmpErsatzFahrStreifen = null;
							}
						datum.getReferenceValue("ErsatzFahrStreifen").setSystemObject(tmpErsatzFahrStreifen);
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Typ").isState()) {
								setTyp(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrStreifenTyp
								.getZustand(daten.getScaledValue("Typ").getText()));
							} else {
							setTyp(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrStreifenTyp
							(daten.
								getUnscaledValue
							("Typ").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Lage").isState()) {
								setLage(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrStreifenLage
								.getZustand(daten.getScaledValue("Lage").getText()));
							} else {
							setLage(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrStreifenLage
							(daten.
								getUnscaledValue
							("Lage").
									byteValue
							()));
							}
					// ObjektReferenzAttributTyp
						final long idFahrStreifenQuelle = daten.getReferenceValue("FahrStreifenQuelle").getId();
						final SystemObjekt tmpFahrStreifenQuelle;
						if (idFahrStreifenQuelle == 0) {
							tmpFahrStreifenQuelle = null;
						} else {
							final SystemObject soFahrStreifenQuelle = factory.getDav().getDataModel().getObject(idFahrStreifenQuelle);
							if (soFahrStreifenQuelle == null) {
									tmpFahrStreifenQuelle = new BaseUngueltigesSystemObjekt(idFahrStreifenQuelle);
							} else {
								tmpFahrStreifenQuelle = factory.getModellobjekt(soFahrStreifenQuelle);
							}
						}
						setFahrStreifenQuelle((	Object
						) tmpFahrStreifenQuelle);
					// ObjektReferenzAttributTyp
						final long idErsatzFahrStreifen = daten.getReferenceValue("ErsatzFahrStreifen").getId();
						final SystemObjekt tmpErsatzFahrStreifen;
						if (idErsatzFahrStreifen == 0) {
							tmpErsatzFahrStreifen = null;
						} else {
							final SystemObject soErsatzFahrStreifen = factory.getDav().getDataModel().getObject(idErsatzFahrStreifen);
							if (soErsatzFahrStreifen == null) {
									tmpErsatzFahrStreifen = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.impl.FahrStreifenUngueltig(idErsatzFahrStreifen);
							} else {
								tmpErsatzFahrStreifen = factory.getModellobjekt(soErsatzFahrStreifen);
							}
						}
						setErsatzFahrStreifen((	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.FahrStreifen
						) tmpErsatzFahrStreifen);
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setTyp(getTyp());
							klon.setLage(getLage());
							klon.setFahrStreifenQuelle(getFahrStreifenQuelle());
							klon.setErsatzFahrStreifen(getErsatzFahrStreifen());
			
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}
	
		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.fahrStreifen";

	/**
	 * Initialisiert den Konfigurationsdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public KdFahrStreifen(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
