/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Konfigurierende Eigenschaften der Objekte des Typs.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 53
 */
public class KdGesamtStrasse extends AbstractKonfigurationsDatensatz<KdGesamtStrasse.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Eigenschaften,
				};
			}
	
			/**
			 * Wird für konfigurierende Attributgruppen verwendet. Über die entsprechende Attributgruppe werden die konkreten Eigenschaften eines Objekts festgelegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Eigenschaften = new Aspekte("Eigenschaften", "asp.eigenschaften");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractDatum implements KonfigurationsDatum {
		
		/**
		 * Initialisiert das Datum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttStrassenTypErweitert
				 _typ
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
				 _nummer
				;
				private String
				 _zusatz
				= new String
				()
				;
				private String
				 _bezeichnung
				= new String
				()
				;
				private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Strasse
				> _strasseFR1 = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Strasse
				>(0, true);
				private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Strasse
				> _strasseFR2 = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Strasse
				>(0, true);
		
			/**
			Typ der Straße (Autobahn, Bundesstraße,
									Landesstraße,...) entsprechend der LCL-Typenliste.
			<p>
			
			</p>
			
			@return der Wert von Typ.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttStrassenTypErweitert
				 getTyp() {
				return _typ;
			}
		
			/**
			Typ der Straße (Autobahn, Bundesstraße,
									Landesstraße,...) entsprechend der LCL-Typenliste.
			<p>
			
			</p>
			
			@param _typ der neue Wert von Typ.
			*/
			public void setTyp(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttStrassenTypErweitert
			 _typ) {
				this._typ = _typ;
			}
		
			/**
			Straßennummer (ohne Typkürzel), z.B. "5".
			<p>
			
			</p>
			
			@return der Wert von Nummer.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
				 getNummer() {
				return _nummer;
			}
		
			/**
			Straßennummer (ohne Typkürzel), z.B. "5".
			<p>
			
			</p>
			
			@param _nummer der neue Wert von Nummer.
			*/
			public void setNummer(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
			 _nummer) {
				this._nummer = _nummer;
			}
		
			/**
			Zusätzliche Angabe zu Straßentyp und Nummer,
									z.B. "a" für " B 96 a".
			<p>
			
			</p>
			
			@return der Wert von Zusatz.
			*/
				public String
				 getZusatz() {
				return _zusatz;
			}
		
			/**
			Zusätzliche Angabe zu Straßentyp und Nummer,
									z.B. "a" für " B 96 a".
			<p>
			
			</p>
			
			@param _zusatz der neue Wert von Zusatz.
			*/
			public void setZusatz(String
			 _zusatz) {
				if (_zusatz.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._zusatz = _zusatz;
			}
		
			/**
			Da es in der LCL auch Straßen gibt, die im Feld ROAD_NUMBER Bezeichungen haben, die sich nicht
									eindeutig
									auf Typ, Straßennummer und Zusatz abbilden lassen, nimmt dieses Feld den gesamten Wert der
									Spalte ROAD_NUMBER auf..
			<p>
			
			</p>
			
			@return der Wert von Bezeichnung.
			*/
				public String
				 getBezeichnung() {
				return _bezeichnung;
			}
		
			/**
			Da es in der LCL auch Straßen gibt, die im Feld ROAD_NUMBER Bezeichungen haben, die sich nicht
									eindeutig
									auf Typ, Straßennummer und Zusatz abbilden lassen, nimmt dieses Feld den gesamten Wert der
									Spalte ROAD_NUMBER auf..
			<p>
			
			</p>
			
			@param _bezeichnung der neue Wert von Bezeichnung.
			*/
			public void setBezeichnung(String
			 _bezeichnung) {
				if (_bezeichnung.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._bezeichnung = _bezeichnung;
			}
		
			/**
			Liste der Straßen in FR1, aufsteigend sortiert nach Fahrtrichtung.
			<p>
			&lt;absatz&gt;
										Sortiert nach Fahrtrichtung 1 bedeutet, dass die Objekte vom typ.straße so nacheinander
										eingetragen werden, dass die Gesamtstraße in FR1 (also positiver LCL Richtung) durchgehend
										über die eingetragenen Straßen durchfahren werden können. Bei Gesamtstraßen, die baulich
										nicht durchgehend befahren werden können, sind die Eintragungen analog so vorzunehmen,
										als wenn die Lücken nicht mehr vorhanden wären.
									&lt;&#47;absatz&gt;
									&lt;absatz&gt;Da die FR der Straßen über die atg.straßeFernZiele am typ.straße über die TmcRichtung
										festgelegt ist,
										dürfen hier nur Straßen eingetragen werden, bei denen der Eintrag bei TmcRichtung = positiv
										ist.
									&lt;&#47;absatz&gt;
			</p>
			
			@return der Wert von StrasseFR1.
			*/
				public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Strasse
				> getStrasseFR1() {
				return _strasseFR1;
			}
		
		
			/**
			Liste der Straßen in FR2, aufsteigend sortiert nach Fahrtrichtung.
			<p>
			&lt;absatz&gt;
										Sortiert nach Fahrtrichtung 2 bedeutet, dass die Objekte vom typ.straße so nacheinander
										eingetragen werden, dass die Gesamtstraße in FR2 (also negativer LCL Richtung) durchgehend
										über die eingetragenen Straßen durchfahren werden können. Bei Gesamtstraßen, die baulich
										nicht durchgehend befahren werden können, sind die Eintragungen analog so vorzunehmen,
										als wenn die Lücken nicht mehr vorhanden wären.
									&lt;&#47;absatz&gt;
									&lt;absatz&gt;Da die FR der Straßen über die atg.straßeFernZiele am typ.straße über die TmcRichtung
										festgelegt ist,
										dürfen hier nur Straßen eingetragen werden, bei denen der Eintrag bei TmcRichtung = negativ
										ist.
									&lt;&#47;absatz&gt;
			</p>
			
			@return der Wert von StrasseFR2.
			*/
				public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Strasse
				> getStrasseFR2() {
				return _strasseFR2;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getTyp() != null) {
		                if (getTyp().isZustand()) {
		                    datum.getUnscaledValue("Typ").setText(getTyp().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Typ").set(getTyp().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getNummer() != null) {
		                if (getNummer().isZustand()) {
		                    datum.getUnscaledValue("Nummer").setText(getNummer().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Nummer").set(getNummer().getValue());
		                }
					}
					// ZeichenkettenAttributTyp
					if (getZusatz() != null) {
						datum.getTextValue("Zusatz").setText(getZusatz());
					}
					// ZeichenkettenAttributTyp
					if (getBezeichnung() != null) {
						datum.getTextValue("Bezeichnung").setText(getBezeichnung());
					}
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayStrasseFR1 = datum.getReferenceArray("StraßeFR1");
						arrayStrasseFR1.setLength(getStrasseFR1().size());
						for (int i = 0; i < arrayStrasseFR1.getLength(); ++i) {
							final Object soStrasseFR1 = getStrasseFR1().get(i);
							final SystemObject tmpStrasseFR1;
							if (soStrasseFR1 instanceof SystemObject) {
								tmpStrasseFR1 = (SystemObject)soStrasseFR1;
							} else if(soStrasseFR1 instanceof SystemObjekt){
								tmpStrasseFR1 = ((SystemObjekt)soStrasseFR1).getSystemObject();
							} else{
								tmpStrasseFR1 = null;
							}
							arrayStrasseFR1.getReferenceValue(i).setSystemObject(tmpStrasseFR1);
						}
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayStrasseFR2 = datum.getReferenceArray("StraßeFR2");
						arrayStrasseFR2.setLength(getStrasseFR2().size());
						for (int i = 0; i < arrayStrasseFR2.getLength(); ++i) {
							final Object soStrasseFR2 = getStrasseFR2().get(i);
							final SystemObject tmpStrasseFR2;
							if (soStrasseFR2 instanceof SystemObject) {
								tmpStrasseFR2 = (SystemObject)soStrasseFR2;
							} else if(soStrasseFR2 instanceof SystemObjekt){
								tmpStrasseFR2 = ((SystemObjekt)soStrasseFR2).getSystemObject();
							} else{
								tmpStrasseFR2 = null;
							}
							arrayStrasseFR2.getReferenceValue(i).setSystemObject(tmpStrasseFR2);
						}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Typ").isState()) {
								setTyp(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttStrassenTypErweitert
								.getZustand(daten.getScaledValue("Typ").getText()));
							} else {
							setTyp(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttStrassenTypErweitert
							(daten.
								getUnscaledValue
							("Typ").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							setNummer(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
							(daten.
								getUnscaledValue
							("Nummer").
									longValue
							()));
					// ZeichenkettenAttributTyp
						setZusatz(daten.getTextValue("Zusatz").getText());
					// ZeichenkettenAttributTyp
						setBezeichnung(daten.getTextValue("Bezeichnung").getText());
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayStrasseFR1 = daten.getReferenceArray("StraßeFR1");
						for (int i = 0; i < arrayStrasseFR1.getLength(); ++i) {
							final long idStrasseFR1 = daten.getReferenceArray("StraßeFR1").getReferenceValue(i).getId();
							final SystemObjekt tmpStrasseFR1;
							if (idStrasseFR1 == 0) {
								tmpStrasseFR1 = null;
							} else {
								final SystemObject soStrasseFR1 = factory.getDav().getDataModel().getObject(idStrasseFR1);
								if (soStrasseFR1 == null) {
										tmpStrasseFR1 = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.impl.StrasseUngueltig(idStrasseFR1);
								} else {
									tmpStrasseFR1 = factory.getModellobjekt(soStrasseFR1);
								}
							}
								getStrasseFR1().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Strasse
								) tmpStrasseFR1);
						}
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayStrasseFR2 = daten.getReferenceArray("StraßeFR2");
						for (int i = 0; i < arrayStrasseFR2.getLength(); ++i) {
							final long idStrasseFR2 = daten.getReferenceArray("StraßeFR2").getReferenceValue(i).getId();
							final SystemObjekt tmpStrasseFR2;
							if (idStrasseFR2 == 0) {
								tmpStrasseFR2 = null;
							} else {
								final SystemObject soStrasseFR2 = factory.getDav().getDataModel().getObject(idStrasseFR2);
								if (soStrasseFR2 == null) {
										tmpStrasseFR2 = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.impl.StrasseUngueltig(idStrasseFR2);
								} else {
									tmpStrasseFR2 = factory.getModellobjekt(soStrasseFR2);
								}
							}
								getStrasseFR2().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Strasse
								) tmpStrasseFR2);
						}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setTyp(getTyp());
							klon.setNummer(getNummer());
							klon.setZusatz(getZusatz());
							klon.setBezeichnung(getBezeichnung());
						klon._strasseFR1 = getStrasseFR1().clone();
						klon._strasseFR2 = getStrasseFR2().clone();
			
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}
	
		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.gesamtStraße";

	/**
	 * Initialisiert den Konfigurationsdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public KdGesamtStrasse(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
