/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Konfigurierende Eigenschaften der Objekte des Typs. Enthält ZUSÄTZLICHE Informationen der LCL zu
					diesem Objekt.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 53
 */
public class KdStrassenSegmentLclInfo extends AbstractKonfigurationsDatensatz<KdStrassenSegmentLclInfo.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Eigenschaften,
				};
			}
	
			/**
			 * Wird für konfigurierende Attributgruppen verwendet. Über die entsprechende Attributgruppe werden die konkreten Eigenschaften eines Objekts festgelegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Eigenschaften = new Aspekte("Eigenschaften", "asp.eigenschaften");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractDatum implements KonfigurationsDatum {
		
		/**
		 * Initialisiert das Datum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private 	de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.objekte.TmcPunkt
				 _tmcPunktAnfang
				;
				private 	de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.objekte.TmcPunkt
				 _tmcPunktEnde
				;
		
			/**
			TMCPunkt am Anfang des Segments (in
									Fahrtrichtung).
			<p>
			
			</p>
			
			@return der Wert von TmcPunktAnfang.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.objekte.TmcPunkt
				 getTmcPunktAnfang() {
				return _tmcPunktAnfang;
			}
		
			/**
			TMCPunkt am Anfang des Segments (in
									Fahrtrichtung).
			<p>
			
			</p>
			
			@param _tmcPunktAnfang der neue Wert von TmcPunktAnfang.
			*/
			public void setTmcPunktAnfang(	de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.objekte.TmcPunkt
			 _tmcPunktAnfang) {
				this._tmcPunktAnfang = _tmcPunktAnfang;
			}
		
			/**
			TMCPunkt am Ende des Segments (in
									Fahrtrichtung).
			<p>
			
			</p>
			
			@return der Wert von TmcPunktEnde.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.objekte.TmcPunkt
				 getTmcPunktEnde() {
				return _tmcPunktEnde;
			}
		
			/**
			TMCPunkt am Ende des Segments (in
									Fahrtrichtung).
			<p>
			
			</p>
			
			@param _tmcPunktEnde der neue Wert von TmcPunktEnde.
			*/
			public void setTmcPunktEnde(	de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.objekte.TmcPunkt
			 _tmcPunktEnde) {
				this._tmcPunktEnde = _tmcPunktEnde;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ObjektReferenzAttributTyp
						final Object soTmcPunktAnfang = getTmcPunktAnfang();
						final SystemObject tmpTmcPunktAnfang;
							if (soTmcPunktAnfang instanceof SystemObject) {
								tmpTmcPunktAnfang = (SystemObject)soTmcPunktAnfang;
							} else if(soTmcPunktAnfang instanceof SystemObjekt){
								tmpTmcPunktAnfang = ((SystemObjekt)soTmcPunktAnfang).getSystemObject();
							} else{
								tmpTmcPunktAnfang = null;
							}
						datum.getReferenceValue("TmcPunktAnfang").setSystemObject(tmpTmcPunktAnfang);
					// ObjektReferenzAttributTyp
						final Object soTmcPunktEnde = getTmcPunktEnde();
						final SystemObject tmpTmcPunktEnde;
							if (soTmcPunktEnde instanceof SystemObject) {
								tmpTmcPunktEnde = (SystemObject)soTmcPunktEnde;
							} else if(soTmcPunktEnde instanceof SystemObjekt){
								tmpTmcPunktEnde = ((SystemObjekt)soTmcPunktEnde).getSystemObject();
							} else{
								tmpTmcPunktEnde = null;
							}
						datum.getReferenceValue("TmcPunktEnde").setSystemObject(tmpTmcPunktEnde);
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ObjektReferenzAttributTyp
						final long idTmcPunktAnfang = daten.getReferenceValue("TmcPunktAnfang").getId();
						final SystemObjekt tmpTmcPunktAnfang;
						if (idTmcPunktAnfang == 0) {
							tmpTmcPunktAnfang = null;
						} else {
							final SystemObject soTmcPunktAnfang = factory.getDav().getDataModel().getObject(idTmcPunktAnfang);
							if (soTmcPunktAnfang == null) {
									tmpTmcPunktAnfang = new de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.objekte.impl.TmcPunktUngueltig(idTmcPunktAnfang);
							} else {
								tmpTmcPunktAnfang = factory.getModellobjekt(soTmcPunktAnfang);
							}
						}
						setTmcPunktAnfang((	de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.objekte.TmcPunkt
						) tmpTmcPunktAnfang);
					// ObjektReferenzAttributTyp
						final long idTmcPunktEnde = daten.getReferenceValue("TmcPunktEnde").getId();
						final SystemObjekt tmpTmcPunktEnde;
						if (idTmcPunktEnde == 0) {
							tmpTmcPunktEnde = null;
						} else {
							final SystemObject soTmcPunktEnde = factory.getDav().getDataModel().getObject(idTmcPunktEnde);
							if (soTmcPunktEnde == null) {
									tmpTmcPunktEnde = new de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.objekte.impl.TmcPunktUngueltig(idTmcPunktEnde);
							} else {
								tmpTmcPunktEnde = factory.getModellobjekt(soTmcPunktEnde);
							}
						}
						setTmcPunktEnde((	de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.objekte.TmcPunkt
						) tmpTmcPunktEnde);
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setTmcPunktAnfang(getTmcPunktAnfang());
							klon.setTmcPunktEnde(getTmcPunktEnde());
			
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}
	
		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.straßenSegmentLclInfo";

	/**
	 * Initialisiert den Konfigurationsdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public KdStrassenSegmentLclInfo(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
