/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Achslastmessstelle.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public interface AchsLastMessStelle extends de.bsvrz.sys.funclib.bitctrl.modell.KonfigurationsObjekt
	,de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.PunktXY
	
	
	
	{

	/** Die PID des Systemobjekttyps im Datenverteiler. */
	public static final String PID = "typ.achsLastMessStelle"; 
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	

	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	/**
	Attributgruppe zur Speicherung von Default-Parameterdatensätzen für alle Parameter-Attributgruppen eines Typs.
	<p>
	
	</p>
	@return der Datensatz DefaultParameterdatensaetze.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze();
	
	/**
	Einzelergebnismeldung Achslasten und
						Kfz-Gesamtgewichte Version 1 udn 2 (FG 2 &#47; Typ
						60-62).
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;
								FG 2: DE-Block-Struktur im Typ
								60-61"Einzelergebnismeldung Achslasten und
								Kfz-Gesamtgewicht (Version 1-2)"
							&lt;&#47;titel&gt;
							&lt;absatz&gt;
								Wird verwendet mit ID 4 (Ergebnisse) und ID
								36 (ErgebnisMeldung aus Puffer) in
								Antwortrichtung
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Die Übertragung geschieht spontan (d.h. beim
								nächsten Polling-Abruf) nach der Verwiegung
								eines Fahrzeugs. Die Daten können nicht
								abgerufen werden.
							&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsAxlEinzelErgebnisMeldungAchsLastenUndKfzGesamtGewichteVersion1Bis2.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsAxlEinzelErgebnisMeldungAchsLastenUndKfzGesamtGewichteVersion1Bis2 getOdTlsAxlEinzelErgebnisMeldungAchsLastenUndKfzGesamtGewichteVersion1Bis2();
	
	/**
	Konfigurierende Eigenschaften der Objekte des Typs.
	<p>
	
	</p>
	@return der Datensatz AchsLastMessStelle.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten.KdAchsLastMessStelle getKdAchsLastMessStelle();
	
	/**
	Attributgruppe zur Speicherung von beschreibenden Informationen zu einem Objekt.
	<p>
	
	</p>
	@return der Datensatz Info.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo();
	
	/**
	Verwaltet bis zu zehn alternative Bezeichnungen.
	<p>
	
	</p>
	@return der Datensatz AlternativeObjektbezeichnung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung();
	
	/**
	ErgebnisMeldung Achslastdaten Version 10 (FG 2 &#47; Typ
						65).
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;
								FG 2: DE-Block-Struktur im Typ
								65"ErgebnisMeldung Achslastdaten Version 10"
							&lt;&#47;titel&gt;
							&lt;absatz&gt;
								Wird verwendet mit ID 4 (Ergebnisse) und ID
								36 (ErgebnisMeldung aus Puffer) in
								Antwortrichtung.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Lassen sich einzelne Werte des Blockes nicht
								ermitteln, ohne dass ein Totalausfall des
								DEs vorliegt, so werden die betroffenen
								Messwertbytes auf den Wert 255 (65535)
								gesetzt (z.B. aufgrund von Schleifendefekten
								oder verkehrsbedingt o.ä.).
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Die Achslastdaten werden für die
								Fahrzeugklassen 3 (Lkw), 4 (Lkw mit Anhänger
								und Sattelkraftfahrzeuge) und 5 (Busse)
								übertragen. Die Einteilung der Fahrzeuge in
								Klassen entspricht der in Anhang 2, Kapitel
								2.
							&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsAxlErgebnisMeldungAchsLastDatenVersion10.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsAxlErgebnisMeldungAchsLastDatenVersion10 getOdTlsAxlErgebnisMeldungAchsLastDatenVersion10();
	
	/**
	Koordinaten eines Punktes in Grad entsprechend WGS84.
	<p>
	
	</p>
	@return der Datensatz PunktKoordinaten.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdPunktKoordinaten getKdPunktKoordinaten();
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	 
}
