/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Bereich zwischen zwei Straßenknoten.
<p>
&lt;absatz&gt;
						Richtlinie für die Vergabe der Pid: 'ass.r.von.r.nach.z' mit
					&lt;&#47;absatz&gt;
					&lt;liste zeichen="punkt"&gt;
						&lt;listenPunkt&gt;
							'ass': Abkürzung für
							&lt;wichtig&gt;A&lt;&#47;wichtig&gt;
							eußeres
							&lt;wichtig&gt;S&lt;&#47;wichtig&gt;
							traßen
							&lt;wichtig&gt;S&lt;&#47;wichtig&gt;
							egment.
						&lt;&#47;listenPunkt&gt;
						&lt;listenPunkt&gt;
							'r : Richtung, in der sich auf den Location
							Code 'von' zubewegt wird:
							&lt;wichtig&gt;p&lt;&#47;wichtig&gt;
							:positive Richtung,
							&lt;wichtig&gt;n&lt;&#47;wichtig&gt;
							:für negative Richtung. Ist der nachstehende
							Knoten unbekannt (Wert = 00000), so wird
							immer p verwendet.
						&lt;&#47;listenPunkt&gt;
						&lt;listenPunkt&gt;
							'von': Location Code, fünfstellig mit
							führenden Nullen, von dem zugefahren wurde.
							Ist der Knoten nicht bekannt (z. B. bei
							Einfahrten), wird der Wert 00000 verwendet.
						&lt;&#47;listenPunkt&gt;
						&lt;listenPunkt&gt;
							'r' : Richtung, in der sich auf den Location
							Code 'nach' zubewegt wird:
							&lt;wichtig&gt;p&lt;&#47;wichtig&gt;
							:positive Richtung,
							&lt;wichtig&gt;n&lt;&#47;wichtig&gt;
							:für negative Richtung. Ist der nachstehende
							Knoten unbekannt (Wert = 00000), so wird
							immer p verwendet.
						&lt;&#47;listenPunkt&gt;
						&lt;listenPunkt&gt;
							'nach': Location Code, fünfstellig mit
							führenden Nullen, auf den sich zubewegt
							wird. Bei Abfahrten wird als Knotennummer
							00000 verwendet, da der Zielknoten i. d. R.
							nicht bekannt ist. Diese Regel wird auch
							angewandt, wenn die Abfahrt z. B. auf eine
							erfasste Bundesstraße mit Location Code
							erfolgt, bei der die Richtung bei einer
							Abfahrt auf eine Bundesstraße nicht
							eindeutig ist (es kann am Ende der Abfahrt
							sowohl nach links als auch nach rechts
							abgebogen werden!).
						&lt;&#47;listenPunkt&gt;
						&lt;listenPunkt&gt;
							'z': Zusätzliche Fahrbeziehungen, zweistellig
							00..99, wird z. B. verwendet, wenn die
							Verbindung zweier StraßenKnoten über mehrere
							Wege möglich ist (i. d. R. immer 00, in
							Ausnahmefällen können zwei
							ÄußereStraßenSegmente identische Knoten
							verbinden, in diesem Fall sind die
							Fahrbeziehungen durchzunummerieren).
						&lt;&#47;listenPunkt&gt;
					&lt;&#47;liste&gt;
					&lt;absatz&gt;
						Beispiele für gültige PID eines
						ÄußerenStraßenSegments:
					&lt;&#47;absatz&gt;
					&lt;absatz&gt;ass.p.11757.p.11758.00&lt;&#47;absatz&gt;
					&lt;absatz&gt;ass.p.00000.p.00123.00&lt;&#47;absatz&gt;
					&lt;absatz&gt;ass.n.10055.n.10054.01&lt;&#47;absatz&gt;
					&lt;absatz&gt;Richtlinie für die Vergabe des Namens:&lt;&#47;absatz&gt;
					&lt;liste zeichen="punkt"&gt;
						&lt;listenPunkt&gt;
							Bei der Bildung des Namen für Objekte vom typ.äußeresStraßenSegment wird ein für den
							Anwender lesbarer Name verwendet:
						&lt;&#47;listenPunkt&gt;
						&lt;listenPunkt&gt;
							Die Bildung des Namens sollte mit dem Format "ROADNUMBER von VON nach NACH" durchgeführt
							werden.
						&lt;&#47;listenPunkt&gt;
						&lt;liste zeichen="punkt"&gt;
							&lt;listenPunkt&gt;
								ROADNUMBER enthält den Wert der entsprechenden Spalte der LCL zu der Linien-Location,
								die dem äußeren Straßensegment zugeordnet ist.
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								VON enthält den Wert der Spalte FIRST_NAME der LCL des Startknotens des äußeren
								Straßensegments.
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;NACH enthält den Wert der Spalte FIRST_NAME der LCL des Endknotens des äußeren
								Straßensegments.
							&lt;&#47;listenPunkt&gt;
						&lt;&#47;liste&gt;
					&lt;&#47;liste&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public interface AeusseresStrassenSegment extends de.bsvrz.sys.funclib.bitctrl.modell.KonfigurationsObjekt
	,de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.NetzBestandTeil,de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenSegment
	
	
	
	{

	/** Die PID des Systemobjekttyps im Datenverteiler. */
	public static final String PID = "typ.äußeresStraßenSegment"; 
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	

	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	/**
	Zustand plus Verkehrsinformationen für einen
						Streckenabschnitt.
	<p>
	&lt;absatz&gt;
							Objekte dieses Typs beschreiben den
							Verkehrszustand auf Streckenabschnitten durch
							die Größen:
						&lt;&#47;absatz&gt;
						&lt;liste zeichen="punkt"&gt;
							&lt;listenPunkt&gt;
								Referenzzeit (Zeitpunkt der verwendeten
								Daten)
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;Prognosehorizont&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								Verkehrssituation (Level of Service)
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								Fahrzeitprognose für alle Kfz
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								Fahrzeitprognose für alle Pkw
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								Fahrzeitprognose für alle Lkw
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								mittlere Geschwindigkeit Kfz
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								mittlere Geschwindigkeit Pkw
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								mittlere Geschwindigkeit Lkw
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								mittlerer Fluss aller Kfz
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								mittlerer Fluss aller Pkw
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								mittlerer Fluss aller Lkw
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								mittlere Dichte aller Kfz
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								mittlere Dichte aller Pkw
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								mittlere Dichte aller Lkw
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								Güteindex für den Störfall-Verkehrszustand
							&lt;&#47;listenPunkt&gt;
						&lt;&#47;liste&gt;
	</p>
	@return der Datensatz StoerfallVerkehrsZustand.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdStoerfallVerkehrsZustand getOdStoerfallVerkehrsZustand();
	
	/**
	Attributgruppe zur Speicherung von Default-Parameterdatensätzen für alle Parameter-Attributgruppen eines Typs.
	<p>
	
	</p>
	@return der Datensatz DefaultParameterdatensaetze.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze();
	
	/**
	Referenzen auf Linienobjekte, die zusammen dieses Linienobjekt bilden. Der Offset einer Teillinie ergibt sich aus dem Index der Referenz und der Länge der referenzierten (Teil)Linie.
	<p>
	
	</p>
	@return der Datensatz BestehtAusLinienObjekten.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdBestehtAusLinienObjekten getKdBestehtAusLinienObjekten();
	
	/**
	Attributgruppe zur Speicherung von beschreibenden Informationen zu einem Objekt.
	<p>
	
	</p>
	@return der Datensatz Info.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo();
	
	/**
	Verwaltet bis zu zehn alternative Bezeichnungen.
	<p>
	
	</p>
	@return der Datensatz AlternativeObjektbezeichnung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung();
	
	/**
	Konfigurierende Eigenschaften der Objekte des Typs.
	<p>
	
	</p>
	@return der Datensatz Linie.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdLinie getKdLinie();
	
	/**
	Konfigurierende Eigenschaften der Objekte des Typs.
	<p>
	
	</p>
	@return der Datensatz AeusseresStrassenSegment.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten.KdAeusseresStrassenSegment getKdAeusseresStrassenSegment();
	
	/**
	Zustand eines Störfallindikators.
	<p>
	
	</p>
	@return der Datensatz StoerfallZustand.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdStoerfallZustand getOdStoerfallZustand();
	
	/**
	Konfigurierende Eigenschaften der Objekte des Typs.
	<p>
	
	</p>
	@return der Datensatz StrassenSegment.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten.KdStrassenSegment getKdStrassenSegment();
	
	/**
	Konfigurierende Eigenschaften der Objekte des Typs. Enthält ZUSÄTZLICHE Informationen der LCL zu
						diesem Objekt.
	<p>
	
	</p>
	@return der Datensatz StrassenSegmentLclInfo.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten.KdStrassenSegmentLclInfo getKdStrassenSegmentLclInfo();
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	 
}
