/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Dynamisch erzeugte Baustelle.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 10
 */
public interface Baustelle extends de.bsvrz.sys.funclib.bitctrl.modell.DynamischesObjekt
	,de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Situation
	
	
	
	{

	/** Die PID des Systemobjekttyps im Datenverteiler. */
	public static final String PID = "typ.baustelle"; 
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	

	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	/**
	Ermöglicht die umgehende Neuberechnung der
						Baustellenprogrnose (z. B. in der Entwurfsphase
						einer Baustelle).
	<p>
	
	</p>
	@return der Datensatz BaustellenSimulationStartenMitMq.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdBaustellenSimulationStartenMitMq getOdBaustellenSimulationStartenMitMq();
	
	/**
	Enthält Informationen, wenn dieses Objekt mit KExDaV übertragen wurde und von einer anderen Konfiguration stammt.
	<p>
	
	</p>
	@return der Datensatz KexdavAustauschObjekt.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdKexdavAustauschObjekt getKdKexdavAustauschObjekt();
	
	/**
	Erweitert die vorhandenen Baustelleneigenschaften.
	<p>
	
	</p>
	@return der Datensatz BaustellenEigenschaftenErweitert.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdBaustellenEigenschaftenErweitert getPdBaustellenEigenschaftenErweitert();
	
	/**
	Ermöglicht die umgehende Neuberechnung der
						Baustellenprogrnose (z. B. in der Entwurfsphase
						einer Baustelle).
	<p>
	
	</p>
	@return der Datensatz BaustellenSimulationStarten.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdBaustellenSimulationStarten getOdBaustellenSimulationStarten();
	
	/**
	Aktuelle Eigenschaften einer Baustelle.
	<p>
	
	</p>
	@return der Datensatz BaustellenEigenschaften.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdBaustellenEigenschaften getPdBaustellenEigenschaften();
	
	/**
	Attributgruppe zur Speicherung von beschreibenden Informationen zu einem Objekt.
	<p>
	
	</p>
	@return der Datensatz Info.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo();
	
	/**
	Verantwortlicher für die Baustelle.
	<p>
	
	</p>
	@return der Datensatz BaustellenVerantwortlicher.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdBaustellenVerantwortlicher getPdBaustellenVerantwortlicher();
	
	/**
	Aktuelle Eigenschaften eines Situationsobjekts.
	<p>
	
	</p>
	@return der Datensatz SituationsEigenschaften.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdSituationsEigenschaften getPdSituationsEigenschaften();
	
	/**
	Verwaltet bis zu zehn alternative Bezeichnungen.
	<p>
	
	</p>
	@return der Datensatz AlternativeObjektbezeichnung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung();
	
	/**
	Liste mit prognostizierten Staus aufgrund der
						Baustelle.
	<p>
	
	</p>
	@return der Datensatz BaustellenSimulation.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdBaustellenSimulation getOdBaustellenSimulation();
	
	/**
	Konfigurierende Eigenschaften der Objekte des Typs.
	<p>
	&lt;absatz&gt;
							Ist diese AttributGruppe am Objekt nicht vorhanden, so ist die Bedeutung im entsprechenden
							Kontext zu klären.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Im Kontext NBA werden folgende Bedeutungen verwendet. Baustelle Quelle 'BIS',
							Unfall Quelle 'RDS' und Stau Quelle 'StauAnalyse'.
						&lt;&#47;absatz&gt;
	</p>
	@return der Datensatz SituationsQuelle.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten.KdSituationsQuelle getKdSituationsQuelle();
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	 
}
