/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Fahrstreifen eines Messquerschnitts.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public interface FahrStreifen extends de.bsvrz.sys.funclib.bitctrl.modell.KonfigurationsObjekt
	,de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StoerfallIndikator
	
	
	
	{

	/** Die PID des Systemobjekttyps im Datenverteiler. */
	public static final String PID = "typ.fahrStreifen"; 
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	

	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	/**
	Attributgruppe zur Speicherung von beschreibenden Informationen zu einem Objekt.
	<p>
	
	</p>
	@return der Datensatz Info.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo();
	
	/**
	Parameter für die Differenzialkontrolle von
						Fahrstreifendaten.
	<p>
	
	</p>
	@return der Datensatz VerkehrsDatenDifferenzialKontrolleFs2.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsDatenDifferenzialKontrolleFs2 getPdVerkehrsDatenDifferenzialKontrolleFs2();
	
	/**
	Verkehrsdaten (Kurzzeit) mit Intervallwerten (noch
						nicht normiert auf Stundenwerte) .
	<p>
	
	</p>
	@return der Datensatz VerkehrsDatenKurzZeitIntervall.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrsDatenKurzZeitIntervall getOdVerkehrsDatenKurzZeitIntervall();
	
	/**
	Parameter für die zulässige Ausfallhäufigkeit von
						Fahrstreifendaten.
	<p>
	
	</p>
	@return der Datensatz VerkehrsDatenAusfallHaeufigkeitFs.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsDatenAusfallHaeufigkeitFs getPdVerkehrsDatenAusfallHaeufigkeitFs();
	
	/**
	Verkehrsdaten (Langzeit) mit Intervallwerten (nicht
						normiert auf Stundenwerte).
	<p>
	
	</p>
	@return der Datensatz VerkehrsDatenLangZeitIntervall.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrsDatenLangZeitIntervall getOdVerkehrsDatenLangZeitIntervall();
	
	/**
	Parameter für Verkehrslageverfahren 2 (NRW).
	<p>
	
	</p>
	@return der Datensatz VerkehrsLageVerfahren2.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsLageVerfahren2 getPdVerkehrsLageVerfahren2();
	
	/**
	Zustand plus Verkehrsinformationen für einen
						Streckenabschnitt.
	<p>
	&lt;absatz&gt;
							Objekte dieses Typs beschreiben den
							Verkehrszustand auf Streckenabschnitten durch
							die Größen:
						&lt;&#47;absatz&gt;
						&lt;liste zeichen="punkt"&gt;
							&lt;listenPunkt&gt;
								Referenzzeit (Zeitpunkt der verwendeten
								Daten)
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;Prognosehorizont&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								Verkehrssituation (Level of Service)
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								Fahrzeitprognose für alle Kfz
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								Fahrzeitprognose für alle Pkw
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								Fahrzeitprognose für alle Lkw
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								mittlere Geschwindigkeit Kfz
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								mittlere Geschwindigkeit Pkw
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								mittlere Geschwindigkeit Lkw
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								mittlerer Fluss aller Kfz
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								mittlerer Fluss aller Pkw
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								mittlerer Fluss aller Lkw
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								mittlere Dichte aller Kfz
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								mittlere Dichte aller Pkw
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								mittlere Dichte aller Lkw
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								Güteindex für den Störfall-Verkehrszustand
							&lt;&#47;listenPunkt&gt;
						&lt;&#47;liste&gt;
	</p>
	@return der Datensatz StoerfallVerkehrsZustand.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdStoerfallVerkehrsZustand getOdStoerfallVerkehrsZustand();
	
	/**
	Verkehrsdaten (DTV-Werte) normiert auf Tageswerte.
	<p>
	
	</p>
	@return der Datensatz VerkehrsDatenDtvFs.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrsDatenDtvFs getOdVerkehrsDatenDtvFs();
	
	/**
	Konfigurierende Eigenschaften der Objekte des Typs.
	<p>
	
	</p>
	@return der Datensatz FahrStreifen.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten.KdFahrStreifen getKdFahrStreifen();
	
	/**
	Parameter für Messwertersetzung bei Kurzzeitdaten
						Verkehr.
	<p>
	
	</p>
	@return der Datensatz VerkehrsDatenKurzZeitIntervallMessWertErsetzung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsDatenKurzZeitIntervallMessWertErsetzung getPdVerkehrsDatenKurzZeitIntervallMessWertErsetzung();
	
	/**
	Zeitlich geglätte Verkehrsprognosedaten.
	<p>
	
	</p>
	@return der Datensatz VerkehrsDatenKurzZeitGeglaettetFs.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrsDatenKurzZeitGeglaettetFs getOdVerkehrsDatenKurzZeitGeglaettetFs();
	
	/**
	Langzeitverkehrsdaten mit Geschwindigkeitsverteilung (aus TLS Version 24 (FG 1 &#47; Typ 79) und
						berechneten Zusatzwerten)für Fahrstreifen.
	<p>
	
	</p>
	@return der Datensatz VerkehrsDatenLangZeitIntervallGeschwindigkeitVerteilungFs.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrsDatenLangZeitIntervallGeschwindigkeitVerteilungFs getOdVerkehrsDatenLangZeitIntervallGeschwindigkeitVerteilungFs();
	
	/**
	Parameter für PL-Prüfung logisch bei Kurzzeitdaten
						Verkehr.
	<p>
	
	</p>
	@return der Datensatz VerkehrsDatenKurzZeitIntervallPlausibilitaetsPruefungLogisch.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsDatenKurzZeitIntervallPlausibilitaetsPruefungLogisch getPdVerkehrsDatenKurzZeitIntervallPlausibilitaetsPruefungLogisch();
	
	/**
	Attributgruppe zur Speicherung von Default-Parameterdatensätzen für alle Parameter-Attributgruppen eines Typs.
	<p>
	
	</p>
	@return der Datensatz DefaultParameterdatensaetze.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze();
	
	/**
	Parameter für Verkehrslageverfahren 1 (MARZ).
	<p>
	
	</p>
	@return der Datensatz VerkehrsLageVerfahren1.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsLageVerfahren1 getPdVerkehrsLageVerfahren1();
	
	/**
	Verwaltet bis zu zehn alternative Bezeichnungen.
	<p>
	
	</p>
	@return der Datensatz AlternativeObjektbezeichnung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung();
	
	/**
	Verkehrsdaten (Kurzzeit) mit Intervallwerten
						(normiert auf Stundenwerte).
	<p>
	
	</p>
	@return der Datensatz VerkehrsDatenKurzZeitFs.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrsDatenKurzZeitFs getOdVerkehrsDatenKurzZeitFs();
	
	/**
	Aktueller Zustand der logischen Passivierung des Fahrstreifens.
	<p>
	
	</p>
	@return der Datensatz PassivierungFs.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdPassivierungFs getOdPassivierungFs();
	
	/**
	Zustand eines Störfallindikators.
	<p>
	
	</p>
	@return der Datensatz StoerfallZustand.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdStoerfallZustand getOdStoerfallZustand();
	
	/**
	Zeitlich trendextrapolierte Verkehrsprognosedaten.
	<p>
	
	</p>
	@return der Datensatz VerkehrsDatenKurzZeitTrendExtraPolationFs.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrsDatenKurzZeitTrendExtraPolationFs getOdVerkehrsDatenKurzZeitTrendExtraPolationFs();
	
	/**
	Kfz-Einzeldaten.
	<p>
	
	</p>
	@return der Datensatz KfzEinzelDatenFs.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdKfzEinzelDatenFs getOdKfzEinzelDatenFs();
	
	/**
	DTV Langzeitverkehrsdaten mit Geschwindigkeitsverteilung und berechneten Zusatzwerten) für FS.
	<p>
	
	</p>
	@return der Datensatz VerkehrsDatenLangZeitIntervallGeschwindigkeitVerteilungDtvFs.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrsDatenLangZeitIntervallGeschwindigkeitVerteilungDtvFs getOdVerkehrsDatenLangZeitIntervallGeschwindigkeitVerteilungDtvFs();
	
	/**
	Parameter für zeitlich"flink" trendextrapolierte
						Verkehrsprognosedaten.
	<p>
	
	</p>
	@return der Datensatz VerkehrsDatenKurzZeitTrendExtraPolationPrognoseFlinkFs.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsDatenKurzZeitTrendExtraPolationPrognoseFlinkFs getPdVerkehrsDatenKurzZeitTrendExtraPolationPrognoseFlinkFs();
	
	/**
	Parameter für zeitlich"normal" trendextrapolierte
						Verkehrsprognosedaten.
	<p>
	
	</p>
	@return der Datensatz VerkehrsDatenKurzZeitTrendExtraPolationPrognoseNormalFs.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsDatenKurzZeitTrendExtraPolationPrognoseNormalFs getPdVerkehrsDatenKurzZeitTrendExtraPolationPrognoseNormalFs();
	
	/**
	Parameter für PL-Prüfung logisch bei Kurzzeitdaten
						Verkehr.
	<p>
	
	</p>
	@return der Datensatz VerkehrsDatenKurzZeitIntervallPlausibilitaetsPruefungLogisch2.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsDatenKurzZeitIntervallPlausibilitaetsPruefungLogisch2 getPdVerkehrsDatenKurzZeitIntervallPlausibilitaetsPruefungLogisch2();
	
	/**
	Parameter für zeitlich"träge" trendextrapolierte
						Verkehrsprognosedaten.
	<p>
	
	</p>
	@return der Datensatz VerkehrsDatenKurzZeitTrendExtraPolationPrognoseTraegeFs.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsDatenKurzZeitTrendExtraPolationPrognoseTraegeFs getPdVerkehrsDatenKurzZeitTrendExtraPolationPrognoseTraegeFs();
	
	/**
	Parameter für Analysedaten bei Kurzzeitdaten
						Verkehr.
	<p>
	
	</p>
	@return der Datensatz VerkehrsDatenKurzZeitAnalyseFs.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsDatenKurzZeitAnalyseFs getPdVerkehrsDatenKurzZeitAnalyseFs();
	
	/**
	Parameter für den Vertrauensbereich von
						Fahrstreifendaten.
	<p>
	
	</p>
	@return der Datensatz VerkehrsDatenVertrauensBereichFs.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsDatenVertrauensBereichFs getPdVerkehrsDatenVertrauensBereichFs();
	
	/**
	Verkehrsdaten (Geschwindigkeitsklassen Kurzzeit) mit
						Intervallwerten (noch nicht normiert auf
						Stundenwerte).
	<p>
	
	</p>
	@return der Datensatz VerkehrsDatenKurzZeitGeschwindigkeitsKlassenIntervall.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrsDatenKurzZeitGeschwindigkeitsKlassenIntervall getOdVerkehrsDatenKurzZeitGeschwindigkeitsKlassenIntervall();
	
	/**
	Parameter für die Differenzialkontrolle von
						Fahrstreifendaten.
	<p>
	
	</p>
	@return der Datensatz VerkehrsDatenDifferenzialKontrolleFs.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsDatenDifferenzialKontrolleFs getPdVerkehrsDatenDifferenzialKontrolleFs();
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	 
}
