/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Dynamisch erzeugtes Stauobjekt auf Basis von FCD-Daten.
<p>
Ein Stauobjekt ist charakterisiert durch einen entsprechenden Geschwindigkeitseinbruch auf
					einem bestimmten Streckenabschnitt zwischen Staukopf (stromabwärtige Staufront) und Stauende
					(stromaufwärtige Staufront). Da die räumliche Ausdehnung eines Stauobjektes sich in der Regel
					dynamisch verändert, soll für detaillierte räumlich-zeitliche Analysen ein Stau nicht als
					segmentbezogenes Attribut betrachtet werden. Zur zeitlichen Verfolgung von Stauobjekten sind über
					die jeweilige Lebensdauer jeweils die Online-Daten an dem jeweiligen Stauobjekt zu aktualisieren.
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 60
 */
public interface FcdStau extends de.bsvrz.sys.funclib.bitctrl.modell.DynamischesObjekt
	,de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.DynamischesObjekt
	
	
	
	{

	/** Die PID des Systemobjekttyps im Datenverteiler. */
	public static final String PID = "typ.fcdStau"; 
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	

	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	/**
	Enthält Informationen, wenn dieses Objekt mit KExDaV übertragen wurde und von einer anderen Konfiguration stammt.
	<p>
	
	</p>
	@return der Datensatz KexdavAustauschObjekt.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdKexdavAustauschObjekt getKdKexdavAustauschObjekt();
	
	/**
	Attributgruppe zur Speicherung von beschreibenden Informationen zu einem Objekt.
	<p>
	
	</p>
	@return der Datensatz Info.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo();
	
	/**
	Verwaltet bis zu zehn alternative Bezeichnungen.
	<p>
	
	</p>
	@return der Datensatz AlternativeObjektbezeichnung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung();
	
	/**
	Attributgruppe zur Verwaltung der aktuellen Zustandsdaten eines FCD-Staus.
	<p>
	
	</p>
	@return der Datensatz FcdStau.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdFcdStau getOdFcdStau();
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	 
}
