/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Gesamtstraße, die sich jeweils aus den Listen der (Teil)Straßen (typ.straße) in FR1
					(in positiver LCL-Richtung) und FR2 (in negativer LCL-Richtung) zusammensetzt.
<p>
&lt;absatz&gt;Die GesamtStrasse hat keine Fahrtrichtung bzw. gilt für beide Fahrtrichtungen. Es ist auch
						unerheblich,
						ob die GesamtStrasse baulich durchgehend befahrbar ist oder wegen fehlender Bauabschnitte aus
						mehreren physischen Stücken besteht.
					&lt;&#47;absatz&gt;
					&lt;absatz&gt;Beispiele für die Bezeichnung von GesamtStrassen sind "A1", "A3", "A555", "B55n", "L193",
						"A623" etc.
					&lt;&#47;absatz&gt;
					&lt;absatz&gt;Jede GesamtStrasse verwaltet über die atg.gesamtStraße zwei Listen mit den zugehörigen
						(Teil)Strassen, jeweils für die FR1 und die FR2, aufsteigend sortiert nach Fahrtrichtung.
						Die beiden Fahrtrichtung FR1 und FR2 sind jeweils die Fahrtrichtung im Sinne der LCL (FR1 =
						positive LCL Richtung, FR2 = negative LCL Richtung).
					&lt;&#47;absatz&gt;
					&lt;absatz&gt;
						Richtlinie für die Vergabe der Pid:
						gesamtStrasse.typ.nummer.zusatz.LocCode' mit
					&lt;&#47;absatz&gt;
					&lt;liste zeichen="punkt"&gt;
						&lt;listenPunkt&gt;
							'gesamtStrasse': fester Prefix.
						&lt;&#47;listenPunkt&gt;
						&lt;listenPunkt&gt;
							'typ': Typ der GesamtStraße (erster Buchstabe der
							Spalte ROADNUMBER der LCL).
						&lt;&#47;listenPunkt&gt;
						&lt;listenPunkt&gt;
							'nummer': Nummer der GesamtStraße
							(Ziffernkombination des Eintrags in der
							Spalte ROADNUMBER der LCL im Anschluss an
							den Typ).
						&lt;&#47;listenPunkt&gt;
						&lt;listenPunkt&gt;
							'zusatz': Optional, falls vorhanden.
							Zusatzbezeichnung für die GesamtStraße (eventuell
							vorhandene zusätzliche Zeichen des Eintrags
							in der Spalte ROADNUMBER der LCL im
							Anschluss an die Straßennummer).
						&lt;&#47;listenPunkt&gt;
						&lt;listenPunkt&gt;
							'LocCode': Referenz auf das Linienelement
							gemäß LCL, welches die Straße repräsentiert
							(PID der Linienreferenz hat die Form
							tmclc.xxxxx, mit xxxxx gleich Location Code
							des Linienelements, 5-stellig mit führenden
							Nullen).
						&lt;&#47;listenPunkt&gt;
					&lt;&#47;liste&gt;
					&lt;absatz&gt;
						Existiert für eine Location keine
						Linienlocation, so wird als PID der Wert
						gesamtStrasse.S.0.tmclcl.00000 verwendet.
					&lt;&#47;absatz&gt;
					&lt;absatz&gt;
						Beispiele für gültige PID einer GesamtStraße:
					&lt;&#47;absatz&gt;
					&lt;absatz&gt;gesamtStrasse.L.150.a.tmclc.39886&lt;&#47;absatz&gt;
					&lt;absatz&gt;gesamtStrasse.A.562.tmclc.07145&lt;&#47;absatz&gt;
					&lt;absatz&gt;
						Richtlinie für die Vergabe des Namens:
					&lt;&#47;absatz&gt;
					&lt;liste zeichen="punkt"&gt;
						&lt;listenPunkt&gt;
							Bei der Bildung der Namen für Objekte vom typ.gesamtStraße wird ein für den Anwender
							lesbarer Name mit Angabe des Bereichs (Fernziele aus der LCL) nach folgendem Muster
							verwendet:
							"ROADNUMBER zwischen FIRST_NAME und SECOND_NAME (ROAD_NAME)".

							Dabei sind für ROADNUMBER, FIRST_NAME, SECOND_NAME und ROAD_NAME die entsprechenden Werte
							der zugeordneten Linien-Location einzusetzen.
						&lt;&#47;listenPunkt&gt;
						&lt;liste zeichen="punkt"&gt;
							&lt;listenPunkt&gt;
								Wenn FIRST_NAME oder SECOND_NAME leer ist, dann wird auch das führende zwischen bzw.
								und weggelassen.
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								Wenn ROAD_NAME leer ist, dann werden auch die umschließenden Klammern und das führende
								Leerzeichen weggelassen.
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								Wenn ROADNUMBER nicht vorhanden, wird diese durch die Bezeichnung des erwei-terten
								Straßentyps (Typkennung der atg.straßenTypErweitert)
							&lt;&#47;listenPunkt&gt;
						&lt;&#47;liste&gt;
					&lt;&#47;liste&gt;
					&lt;absatz&gt;
						Beispiele für gültige Namen einer GesamtStraße:
					&lt;&#47;absatz&gt;
					&lt;absatz&gt;A562 zwischen Bonn-Rheinaue und Bonn-Ost (Abzweig Bonn Süd)
					&lt;&#47;absatz&gt;
					&lt;absatz&gt;A1 zwischen Saarbrücken und Oldenburg in Holstein
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 51
 */
public interface GesamtStrasse extends de.bsvrz.sys.funclib.bitctrl.modell.KonfigurationsObjekt
	,de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsObjekt
	
	
	
	{

	/** Die PID des Systemobjekttyps im Datenverteiler. */
	public static final String PID = "typ.gesamtStraße"; 
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	

	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	/**
	Attributgruppe zur Speicherung von Default-Parameterdatensätzen für alle Parameter-Attributgruppen eines Typs.
	<p>
	
	</p>
	@return der Datensatz DefaultParameterdatensaetze.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze();
	
	/**
	Attributgruppe zur Speicherung von beschreibenden Informationen zu einem Objekt.
	<p>
	
	</p>
	@return der Datensatz Info.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo();
	
	/**
	Verwaltet bis zu zehn alternative Bezeichnungen.
	<p>
	
	</p>
	@return der Datensatz AlternativeObjektbezeichnung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung();
	
	/**
	Konfigurierende Eigenschaften der Objekte des Typs.
	<p>
	
	</p>
	@return der Datensatz GesamtStrasse.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten.KdGesamtStrasse getKdGesamtStrasse();
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	 
}
