/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Messquerschnitt für Verkehrswerte. Wird direkt nicht
					instanziert..
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public interface MessQuerschnittAllgemein extends de.bsvrz.sys.funclib.bitctrl.modell.KonfigurationsObjekt
	,de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StoerfallIndikator,de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.PunktLiegtAufLinienObjekt,de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.PunktXY
	
	
	
	{

	/** Die PID des Systemobjekttyps im Datenverteiler. */
	public static final String PID = "typ.messQuerschnittAllgemein"; 
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	

	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	/**
	Parameter eines Fundamentaldiagramms.
	<p>
	
	</p>
	@return der Datensatz FundamentalDiagramm.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdFundamentalDiagramm getPdFundamentalDiagramm();
	
	/**
	Attributgruppe zur Speicherung von beschreibenden Informationen zu einem Objekt.
	<p>
	
	</p>
	@return der Datensatz Info.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo();
	
	/**
	Parameter für Verkehrslageverfahren 3 (RDS).
	<p>
	
	</p>
	@return der Datensatz VerkehrsLageVerfahren3.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsLageVerfahren3 getPdVerkehrsLageVerfahren3();
	
	/**
	Parameter für Verkehrslageverfahren 2 (NRW).
	<p>
	
	</p>
	@return der Datensatz VerkehrsLageVerfahren2.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsLageVerfahren2 getPdVerkehrsLageVerfahren2();
	
	/**
	Verkehrsdaten (Kurzzeit) mit Intervallwerten
						(normiert auf Stundenwerte).
	<p>
	
	</p>
	@return der Datensatz VerkehrsDatenKurzZeitMq.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrsDatenKurzZeitMq getOdVerkehrsDatenKurzZeitMq();
	
	/**
	Attributgruppe zur Definition von Ganglinien.
	<p>
	
	</p>
	@return der Datensatz Ganglinie.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.parameter.PdGanglinie getPdGanglinie();
	
	/**
	Zeitlich geglätte Verkehrsprognosedaten.
	<p>
	
	</p>
	@return der Datensatz VerkehrsDatenKurzZeitGeglaettetMq.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrsDatenKurzZeitGeglaettetMq getOdVerkehrsDatenKurzZeitGeglaettetMq();
	
	/**
	Zustand plus Verkehrsinformationen für einen
						Streckenabschnitt.
	<p>
	&lt;absatz&gt;
							Objekte dieses Typs beschreiben den
							Verkehrszustand auf Streckenabschnitten durch
							die Größen:
						&lt;&#47;absatz&gt;
						&lt;liste zeichen="punkt"&gt;
							&lt;listenPunkt&gt;
								Referenzzeit (Zeitpunkt der verwendeten
								Daten)
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;Prognosehorizont&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								Verkehrssituation (Level of Service)
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								Fahrzeitprognose für alle Kfz
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								Fahrzeitprognose für alle Pkw
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								Fahrzeitprognose für alle Lkw
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								mittlere Geschwindigkeit Kfz
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								mittlere Geschwindigkeit Pkw
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								mittlere Geschwindigkeit Lkw
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								mittlerer Fluss aller Kfz
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								mittlerer Fluss aller Pkw
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								mittlerer Fluss aller Lkw
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								mittlere Dichte aller Kfz
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								mittlere Dichte aller Pkw
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								mittlere Dichte aller Lkw
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								Güteindex für den Störfall-Verkehrszustand
							&lt;&#47;listenPunkt&gt;
						&lt;&#47;liste&gt;
	</p>
	@return der Datensatz StoerfallVerkehrsZustand.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdStoerfallVerkehrsZustand getOdStoerfallVerkehrsZustand();
	
	/**
	Verkehrsdaten (DTV-Werte) normiert auf Tageswerte.
	<p>
	
	</p>
	@return der Datensatz VerkehrsDatenDtvMq.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrsDatenDtvMq getOdVerkehrsDatenDtvMq();
	
	/**
	Konfigurierende Eigenschaften der Objekte des Typs.
	<p>
	
	</p>
	@return der Datensatz MessQuerschnittAllgemein.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten.KdMessQuerschnittAllgemein getKdMessQuerschnittAllgemein();
	
	/**
	Fuzzy-Set (Parameter) für Verkehrsstärke
						(Stundenwerte).
	<p>
	
	</p>
	@return der Datensatz VerkehrsStaerkeStundeFuzzy.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsStaerkeStundeFuzzy getPdVerkehrsStaerkeStundeFuzzy();
	
	/**
	Fuzzy-Regelbasis.
	<p>
	
	</p>
	@return der Datensatz FuzzyRegelbasis.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdFuzzyRegelbasis getPdFuzzyRegelbasis();
	
	/**
	Fuzzy-Set (Parameter) für Geschwindigkeit.
	<p>
	
	</p>
	@return der Datensatz VerkehrGeschwindigkeitFuzzy.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrGeschwindigkeitFuzzy getPdVerkehrGeschwindigkeitFuzzy();
	
	/**
	Zeitlich trendextrapolierte Verkehrsprognosedaten.
	<p>
	
	</p>
	@return der Datensatz VerkehrsDatenKurzZeitTrendExtraPolationMq.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrsDatenKurzZeitTrendExtraPolationMq getOdVerkehrsDatenKurzZeitTrendExtraPolationMq();
	
	/**
	Fuzzy-Set (Parameter) für Verkehrszustand im
						Verkehr.
	<p>
	
	</p>
	@return der Datensatz VerkehrsZustandFuzzy.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsZustandFuzzy getPdVerkehrsZustandFuzzy();
	
	/**
	DTV Langzeitverkehrsdaten mit Geschwindigkeitsverteilung und berechneten Zusatzwerten)für MQ
						und LZZS (berechnet aus den FS-Werten).
	<p>
	
	</p>
	@return der Datensatz VerkehrsDatenLangZeitIntervallGeschwindigkeitVerteilungDtvMq.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrsDatenLangZeitIntervallGeschwindigkeitVerteilungDtvMq getOdVerkehrsDatenLangZeitIntervallGeschwindigkeitVerteilungDtvMq();
	
	/**
	Unruhe im Verkehr als lingustischer Term.
	<p>
	
	</p>
	@return der Datensatz VerkehrsUnruhe.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrsUnruhe getOdVerkehrsUnruhe();
	
	/**
	Fuzzy-Set (Parameter) für BemessungsDichte .
	<p>
	
	</p>
	@return der Datensatz BemessungsDichteFuzzy.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdBemessungsDichteFuzzy getPdBemessungsDichteFuzzy();
	
	/**
	Fuzzy-Set (Parameter) für den Lkw-Anteil.
	<p>
	
	</p>
	@return der Datensatz AnteilLkwFuzzy.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdAnteilLkwFuzzy getPdAnteilLkwFuzzy();
	
	/**
	Parameter für Analysedaten bei Kurzzeitdaten
						Verkehr.
	<p>
	
	</p>
	@return der Datensatz VerkehrsDatenKurzZeitAnalyseMq.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsDatenKurzZeitAnalyseMq getPdVerkehrsDatenKurzZeitAnalyseMq();
	
	/**
	Geschwindigkeit als linguistischer Term.
	<p>
	
	</p>
	@return der Datensatz VerkehrGeschwindigkeit.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrGeschwindigkeit getOdVerkehrGeschwindigkeit();
	
	/**
	Verkehrzustand bezogen auf Unruhe im Verkehr als
						linguistischer Term.
	<p>
	
	</p>
	@return der Datensatz VerkehrsZustandUnruhe.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrsZustandUnruhe getOdVerkehrsZustandUnruhe();
	
	/**
	Attributgruppe zur Speicherung von Default-Parameterdatensätzen für alle Parameter-Attributgruppen eines Typs.
	<p>
	
	</p>
	@return der Datensatz DefaultParameterdatensaetze.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze();
	
	/**
	BemessungsDichte als linguistischer Term.
	<p>
	
	</p>
	@return der Datensatz BemessungsDichte.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdBemessungsDichte getOdBemessungsDichte();
	
	/**
	Verkehrzustand als linguistischer Term.
	<p>
	
	</p>
	@return der Datensatz VerkehrsZustand.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrsZustand getOdVerkehrsZustand();
	
	/**
	Parameter zur Ganglinienprognose je Prognoseobjekt.
	<p>
	
	</p>
	@return der Datensatz GanglinienModellPrognose.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.parameter.PdGanglinienModellPrognose getPdGanglinienModellPrognose();
	
	/**
	Verkehrsstärke als linguistischer Term
						(Stundenwerte).
	<p>
	
	</p>
	@return der Datensatz VerkehrsStaerkeStunde.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrsStaerkeStunde getOdVerkehrsStaerkeStunde();
	
	/**
	Parameter für Verkehrslageverfahren 1 (MARZ).
	<p>
	
	</p>
	@return der Datensatz VerkehrsLageVerfahren1.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsLageVerfahren1 getPdVerkehrsLageVerfahren1();
	
	/**
	Verwaltet bis zu zehn alternative Bezeichnungen.
	<p>
	
	</p>
	@return der Datensatz AlternativeObjektbezeichnung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung();
	
	/**
	Lkw-Anteil als lingustischer Term.
	<p>
	
	</p>
	@return der Datensatz AnteilLkw.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdAnteilLkw getOdAnteilLkw();
	
	/**
	Fuzzy-Set (Parameter) für Verkehrzustand bezogen auf
						Unruhe im Verkehr.
	<p>
	
	</p>
	@return der Datensatz VerkehrsZustandUnruheFuzzy.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsZustandUnruheFuzzy getPdVerkehrsZustandUnruheFuzzy();
	
	/**
	Zustand eines Störfallindikators.
	<p>
	
	</p>
	@return der Datensatz StoerfallZustand.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdStoerfallZustand getOdStoerfallZustand();
	
	/**
	Fuzzy-Set (Parameter) für Unruhe im Verkehr.
	<p>
	
	</p>
	@return der Datensatz VerkehrsUnruheFuzzy.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsUnruheFuzzy getPdVerkehrsUnruheFuzzy();
	
	/**
	Referenz auf ein Linienobjekt mit Offsetangabe vom Begin der Linie. Darüber läßt sich dessen Koordinate ermitteln. Liegen mehrer Objekte auf einem Linienobjekt, läßt sich über die Offsets die Topologie ermitteln.
	<p>
	
	</p>
	@return der Datensatz PunktLiegtAufLinienObjekt.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdPunktLiegtAufLinienObjekt getKdPunktLiegtAufLinienObjekt();
	
	/**
	Parameter für lokale Störfallerkennung mittels
						Fundamentaldiagramm.
	<p>
	
	</p>
	@return der Datensatz LokaleStoerfallErkennungFundamentalDiagramm.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdLokaleStoerfallErkennungFundamentalDiagramm getPdLokaleStoerfallErkennungFundamentalDiagramm();
	
	/**
	Parameter für zeitlich"träge" trendextrapolierte
						Verkehrsprognosedaten.
	<p>
	
	</p>
	@return der Datensatz VerkehrsDatenKurzZeitTrendExtraPolationPrognoseTraegeMq.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsDatenKurzZeitTrendExtraPolationPrognoseTraegeMq getPdVerkehrsDatenKurzZeitTrendExtraPolationPrognoseTraegeMq();
	
	/**
	Parameter für zeitlich"flink" trendextrapolierte
						Verkehrsprognosedaten.
	<p>
	
	</p>
	@return der Datensatz VerkehrsDatenKurzZeitTrendExtraPolationPrognoseFlinkMq.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsDatenKurzZeitTrendExtraPolationPrognoseFlinkMq getPdVerkehrsDatenKurzZeitTrendExtraPolationPrognoseFlinkMq();
	
	/**
	Parameter für zeitlich"normal" trendextrapolierte
						Verkehrsprognosedaten.
	<p>
	
	</p>
	@return der Datensatz VerkehrsDatenKurzZeitTrendExtraPolationPrognoseNormalMq.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsDatenKurzZeitTrendExtraPolationPrognoseNormalMq getPdVerkehrsDatenKurzZeitTrendExtraPolationPrognoseNormalMq();
	
	/**
	MSV-Wert (Bemessungsverkehrsstärke) für die Gesamt-Kfz für ein Jahr (1., 30. und 50.
						Spitzenstunde QKfzGesamt) .
	<p>
	
	</p>
	@return der Datensatz VerkehrsDatenLangZeitMSV.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrsDatenLangZeitMSV getOdVerkehrsDatenLangZeitMSV();
	
	/**
	Koordinaten eines Punktes in Grad entsprechend WGS84.
	<p>
	
	</p>
	@return der Datensatz PunktKoordinaten.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdPunktKoordinaten getKdPunktKoordinaten();
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	 
}
