/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Begrenzungspunkte (Autobahnkreuz, Anschlussstelle
					etc.), die andere verkehrliche Objekte begrenzen.
<p>
&lt;absatz&gt;
						Richtlinie für die Vergabe der Pid und des
						Namens: 'strassenKnoten.loc1... .locN' mit
					&lt;&#47;absatz&gt;
					&lt;liste zeichen="punkt"&gt;
						&lt;listenPunkt&gt;
							'strassenKnoten': fester Präfix.
						&lt;&#47;listenPunkt&gt;
						&lt;listenPunkt&gt;
							'loc1': LocationCode, fünfstellig mit
							führenden Nullen, für diesen Knoten. Bei
							einfachen Anschlussstellen ist dies i.d.R.
							nur ein LocationCode, bei Autobahnkreuzen
							sind dies i.d.R. mindestens zwei. Bei
							mehreren Locationcodes sind diese in
							aufsteigender Reihenfolge zu sortieren.
						&lt;&#47;listenPunkt&gt;
						&lt;listenPunkt&gt;...&lt;&#47;listenPunkt&gt;
						&lt;listenPunkt&gt;'locN'&lt;&#47;listenPunkt&gt;
					&lt;&#47;liste&gt;
					&lt;absatz&gt;
						Beispiele für gültige PID eines StraßenKnotens:
					&lt;&#47;absatz&gt;
					&lt;absatz&gt;strassenKnoten.11743.23935.24471&lt;&#47;absatz&gt;
					&lt;absatz&gt;strassenKnoten.11313.22217&lt;&#47;absatz&gt;
					&lt;absatz&gt;strassenKnoten.40201&lt;&#47;absatz&gt;
					&lt;absatz&gt;
						Richtlinie für die Vergabe des Namens:"
					&lt;&#47;absatz&gt;
					&lt;liste zeichen="punkt"&gt;
						&lt;listenPunkt&gt;
							Bei der Bildung des Namen für Objekte vom typ.straßenKnoten wird die Knotenbezeichnung
							aus der LCL verwendet in der Form "Typ Name1 (Name 2) [NK Netzknoten]" mit:
						&lt;&#47;listenPunkt&gt;
						&lt;liste zeichen="punkt"&gt;
							&lt;listenPunkt&gt;
								Typ: Textuelle Umsetzung der Informationen aus den Spalten TYPE und SUBTYPE der LCL,
								siehe auch Attribut att.tmcOrtsTyp in Teilmodell TMC.
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								Name: Eintrag der Spalte FIRST_NAME der LCL.
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								Name2: Optional, wenn nicht leer. Eintrag der Spalte SECOND_NAME der LCL.
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								Netzknoten: Netzknotennummer. Eintrag der Spalte NETZKNOTEN_NR der LCL.
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								Da die Straßenknoten-Objekte häufig aus mehreren TMC-Location gebildet werden, die
								über die Spalte INTERSECTIONCODE der LCL miteinander verknüpft sind und die Spalten
								FIRST_NAME bzw. SECOND_NAME der verknüpften Locations nicht immer übereinstimmen, wird
								die Location ausgewählt, die auf der wichtigsten der kreuzenden Straßen liegt. Dazu
								werden je Punkt-Location die zugeordneten LCL-Straßenobjekte mit Hilfe der Spalte
								LINEAR_REFERENCE ermittelt und deren Werte der Spalten TYPE und SUBTYPE verglichen.
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								Da einige Locations keinen eigenen Netzknoten zugeordnet haben, wird in diesen Fällen
								der Teil [NK Netzknoten] ersetzt werden durch [NK NETZKNOTEN_NR-NETZKNOTEN2_NR Offset
								STATION m], wobei NETKNOTEN2_NR und STATION durch die entsprechenden Werte der LCL
								ersetzt werden.
							&lt;&#47;listenPunkt&gt;
						&lt;&#47;liste&gt;
					&lt;&#47;liste&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public interface StrassenKnoten extends de.bsvrz.sys.funclib.bitctrl.modell.KonfigurationsObjekt
	,de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StoerfallIndikator
	
	
	
	{

	/** Die PID des Systemobjekttyps im Datenverteiler. */
	public static final String PID = "typ.straßenKnoten"; 
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	
/**
Fahrbeziehung innerhalb eines AK oder AD werden
						durch InnereStraßenSegmente gebildet.
<p>

</p>

@return die Menge InnereStrassenSegmente oder <code>null</code>, wenn eine optionale Menge nicht versorgt ist.
*/
	Collection<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.InneresStrassenSegment> getInnereStrassenSegmente();


	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	/**
	Zustand plus Verkehrsinformationen für einen
						Streckenabschnitt.
	<p>
	&lt;absatz&gt;
							Objekte dieses Typs beschreiben den
							Verkehrszustand auf Streckenabschnitten durch
							die Größen:
						&lt;&#47;absatz&gt;
						&lt;liste zeichen="punkt"&gt;
							&lt;listenPunkt&gt;
								Referenzzeit (Zeitpunkt der verwendeten
								Daten)
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;Prognosehorizont&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								Verkehrssituation (Level of Service)
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								Fahrzeitprognose für alle Kfz
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								Fahrzeitprognose für alle Pkw
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								Fahrzeitprognose für alle Lkw
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								mittlere Geschwindigkeit Kfz
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								mittlere Geschwindigkeit Pkw
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								mittlere Geschwindigkeit Lkw
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								mittlerer Fluss aller Kfz
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								mittlerer Fluss aller Pkw
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								mittlerer Fluss aller Lkw
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								mittlere Dichte aller Kfz
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								mittlere Dichte aller Pkw
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								mittlere Dichte aller Lkw
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								Güteindex für den Störfall-Verkehrszustand
							&lt;&#47;listenPunkt&gt;
						&lt;&#47;liste&gt;
	</p>
	@return der Datensatz StoerfallVerkehrsZustand.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdStoerfallVerkehrsZustand getOdStoerfallVerkehrsZustand();
	
	/**
	Konfigurierende Eigenschaften der Objekte des Typs.
	<p>
	
	</p>
	@return der Datensatz StrassenKnoten.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten.KdStrassenKnoten getKdStrassenKnoten();
	
	/**
	Attributgruppe zur Speicherung von Default-Parameterdatensätzen für alle Parameter-Attributgruppen eines Typs.
	<p>
	
	</p>
	@return der Datensatz DefaultParameterdatensaetze.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze();
	
	/**
	Konfigurierende Eigenschaften der Objekte des Typs. Enthält ZUSÄTZLICHE Informationen der LCL zu
						diesem Objekt.
	<p>
	
	</p>
	@return der Datensatz StrassenKnotenLclInfo.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten.KdStrassenKnotenLclInfo getKdStrassenKnotenLclInfo();
	
	/**
	Attributgruppe zur Speicherung von beschreibenden Informationen zu einem Objekt.
	<p>
	
	</p>
	@return der Datensatz Info.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo();
	
	/**
	Attributgruppe mit dem Typ des Straßenknotens (AutobahnKreuz,
						Anschlussstellle, ...) entsprechend der LCL-Typenliste.
	<p>
	
	</p>
	@return der Datensatz StrassenKnotenTypErweitert.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten.KdStrassenKnotenTypErweitert getKdStrassenKnotenTypErweitert();
	
	/**
	Verwaltet bis zu zehn alternative Bezeichnungen.
	<p>
	
	</p>
	@return der Datensatz AlternativeObjektbezeichnung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung();
	
	/**
	Zustand eines Störfallindikators.
	<p>
	
	</p>
	@return der Datensatz StoerfallZustand.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdStoerfallZustand getOdStoerfallZustand();
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	 
}
