/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.impl;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Straßensegment innerhalb eines Straßenknotens.
<p>
&lt;absatz&gt;
						Richtlinie für die Vergabe der Pid:
						'iss.r.von.r.nach.z' mit
					&lt;&#47;absatz&gt;
					&lt;liste zeichen="punkt"&gt;
						&lt;listenPunkt&gt;
							'iss' : Abkürzung für
							&lt;wichtig&gt;I&lt;&#47;wichtig&gt;
							nneres
							&lt;wichtig&gt;S&lt;&#47;wichtig&gt;
							traßen
							&lt;wichtig&gt;S&lt;&#47;wichtig&gt;
							egment.
						&lt;&#47;listenPunkt&gt;
						&lt;listenPunkt&gt;
							'r' : Richtung, in der sich auf den Location
							Code 'von' zubewegt wird:
							&lt;wichtig&gt;p&lt;&#47;wichtig&gt;
							:positive Richtung,
							&lt;wichtig&gt;n&lt;&#47;wichtig&gt;
							:für negative Richtung. Ist der nachstehende
							Knoten unbekannt (Wert = 00000), so wird
							immer p verwendet.
						&lt;&#47;listenPunkt&gt;
						&lt;listenPunkt&gt;
							'von' : Location Code, fünfstellig mit
							führenden Nullen, von dem zugefahren wurde.
							Ist der Knoten nicht bekannt (z. B. bei
							Einfahrten), wird der Wert 00000 verwendet.
							Der Knoten, von dem zugefahren wurde,
							entspricht dabei dem nach-Knoten des
							angrenzenden ÄußerenStraßenSegments, von dem
							aus auf den Knoten zugefahren wurde, dies
							ist also der LocationCode des Knotens selbst
							für diese Fahrtrichtung.
						&lt;&#47;listenPunkt&gt;
						&lt;listenPunkt&gt;
							'r' : Richtung, in der sich auf den Location
							Code 'nach' zubewegt wird:
							&lt;wichtig&gt;p&lt;&#47;wichtig&gt;
							:positive Richtung,
							&lt;wichtig&gt;n&lt;&#47;wichtig&gt;
							:für negative Richtung. Ist der nachstehende
							Knoten unbekannt (Wert = 00000), so wird
							immer p verwendet.
						&lt;&#47;listenPunkt&gt;
						&lt;listenPunkt&gt;
							'nach' : Location Code, fünfstellig mit
							führenden Nullen, auf den sich zubewegt
							wird. Bei Abfahrten wird als Knotennummer
							00000 verwendet, da der Zielknoten i. d. R.
							nicht bekannt ist. Diese Regel wird auch
							angewandt, wenn die Abfahrt z. B. auf eine
							erfasste Bundesstraße mit Location Code
							erfolgt, bei der die Richtung bei einer
							Abfahrt auf eine Bundesstraße nicht
							eindeutig ist (es kann am Ende der Abfahrt
							sowohl nach links als auch nach rechts
							abgebogen werden!).
						&lt;&#47;listenPunkt&gt;
						&lt;listenPunkt&gt;
							'z': Zusätzliche Fahrbeziehungen, zweistellig
							00..99, wird z. B. verwendet, wenn die
							Verbindung zweier ÄußererStraßenSegmente
							über mehrere Wege möglich ist (z. B. zur
							Ermittlung der Route durch ein Kreuz bei
							gesperrter Tangente).Die Verbindungen werden aufsteigend durchnummeriert.
						&lt;&#47;listenPunkt&gt;
					&lt;&#47;liste&gt;
					&lt;absatz&gt;
						Beispiele für gültige PID eines
						InnerenStraßenSegments:
					&lt;&#47;absatz&gt;
					&lt;absatz&gt;iss.p.11757.p.11758.00&lt;&#47;absatz&gt;
					&lt;absatz&gt;iss.p.00000.p.00123.00&lt;&#47;absatz&gt;
					&lt;absatz&gt;iss.n.10055.n.10054.01&lt;&#47;absatz&gt;
					&lt;absatz&gt;
						Richtlinie für die Vergabe des Namens:
					&lt;&#47;absatz&gt;
					&lt;liste zeichen="punkt"&gt;
						&lt;listenPunkt&gt;
							Bei der Bildung des Namen für Objekte vom typ.inneresStraßenSegment wird ein für den
							Anwender lesbarer Name verwendet:
						&lt;&#47;listenPunkt&gt;
						&lt;listenPunkt&gt;
							Die Bildung des Namens sollte je nach Situation eins der folgenden Formate ausgewählt
							werden:
						&lt;&#47;listenPunkt&gt;
						&lt;listenPunkt&gt;
							ROADNUMBER FIRST_NAME aus Richtung VON nach NACH
						&lt;&#47;listenPunkt&gt;
						&lt;liste zeichen="punkt"&gt;
							&lt;listenPunkt&gt;
								Dieses Format wird verwendet, wenn sowohl der Knoten, von dem zugefahren wird, als
								auch der Knoten, auf den zugefahren wird, definiert sind.
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								ROADNUMBER enthält den Wert der entsprechenden Spalte der LCL zu der Linien-Location,
								die sowohl die Punkt-Location des Knotens, von dem zugefahren wird, als auch die
								Punkt-Location des Knotens, auf den zugefahren wird, enthält. Dazu müssen ausgehend von
								den Punkt-Locations alle über die Spalte LINEAR_REFERENCE rekursiv definierten
								Linien-Locations verglichen werden. Falls keine gemeinsame übergeordnete Linien-Location
								ermittelt werden kann, wird das Feld einschließlich des nachfolgenden Leerzeichens
								weggelassen.
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								FIRST_NAME enthält den Wert der entsprechenden Spalte LCL der wichtigsten (siehe
								Bildung des Namens beim Typ typ.straßenKnoten) Location des Netzknotens zu dem das
								innere Straßensegment gehört.
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								VON enthält den Wert der Spalte FIRST_NAME der LCL desjenigen Knotens, von dem
								zugefahren wird.
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								NACH enthält den Wert der Spalte FIRST_NAME der LCL desjenigen Knotens, auf den
								zugefahren wird.
							&lt;&#47;listenPunkt&gt;
						&lt;&#47;liste&gt;
						&lt;listenPunkt&gt;
							FIRST_NAME Abfahrt aus Richtung VON
						&lt;&#47;listenPunkt&gt;
						&lt;liste zeichen="punkt"&gt;
							&lt;listenPunkt&gt;
								Dieses Format wird verwendet, wenn der Knoten auf den zugefahren wird, nicht
								defi-niert sind.
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								FIRST_NAME enthält den Wert der entsprechenden Spalte LCL der kleinsten Location des
								Netzknotens zu dem das innere Straßensegment gehört.
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								VON enthält den Wert der Spalte FIRST_NAME der LCL desjenigen Knotens, von dem
								zugefahren wird.
							&lt;&#47;listenPunkt&gt;
						&lt;&#47;liste&gt;
						&lt;listenPunkt&gt;
							FIRST_NAME Auffahrt in Richtung NACH
						&lt;&#47;listenPunkt&gt;
						&lt;liste zeichen="punkt"&gt;
							&lt;listenPunkt&gt;
								Dieses Format wird verwendet, wenn der Knoten von dem zugefahren wird, nicht
								definiert sind.
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								FIRST_NAME enthält den Wert der entsprechenden Spalte der LCL der kleinsten Location
								des Netzknotens, zu dem das innere Straßensegment gehört.
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								NACH enthält den Wert der Spalte FIRST_NAME der LCL desjenigen Knotens, auf den
								zugefahren wird.
							&lt;&#47;listenPunkt&gt;
						&lt;&#47;liste&gt;
					&lt;&#47;liste&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class InneresStrassenSegmentImpl extends AbstractSystemObjekt
	implements de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.InneresStrassenSegment { 

	/**
	 * Der Defaultkonstruktor wird für das Erzeugen des Systemobjekts über per
	 * Reflection-API benötigt.
	 */
	public InneresStrassenSegmentImpl() {
		// tut nix
	}
	
	/**
	 * Initialisierung.
	 * 
	 * @param objekt
	 *            ein beliebiges Systemobjekt.
	 * @param factory
	 *            die Fabrik, die das Systemobjekt angelegt hat.
	 */
	public InneresStrassenSegmentImpl(final SystemObject objekt, final ObjektFactory factory) {
		super(objekt, factory);
		
		if (!objekt.isOfType(getTyp().getPid())) {
			throw new IllegalArgumentException(
					"Systemobjekt ist kein InneresStraßenSegment.");
		}
	}
	
	@Override
	protected String doGetTypPid() {
		return PID;
	}
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	

	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten.KdInneresStrassenSegment getKdInneresStrassenSegment() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten.KdInneresStrassenSegment.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdStoerfallVerkehrsZustand getOdStoerfallVerkehrsZustand() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdStoerfallVerkehrsZustand.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdBestehtAusLinienObjekten getKdBestehtAusLinienObjekten() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdBestehtAusLinienObjekten.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdLinie getKdLinie() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdLinie.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten.KdStrassenSegment getKdStrassenSegment() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten.KdStrassenSegment.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten.KdStrassenSegmentLclInfo getKdStrassenSegmentLclInfo() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten.KdStrassenSegmentLclInfo.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdStoerfallZustand getOdStoerfallZustand() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdStoerfallZustand.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten.KdInneresStrassenSegmentHauptFahrBeziehung getKdInneresStrassenSegmentHauptFahrBeziehung() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten.KdInneresStrassenSegmentHauptFahrBeziehung.class);
	}
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	
	// Sonderfall Klasse AttributImpl
	 

}
