/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.impl;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Messquerschnitt für Handzählungen.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 10
 */
public class MessQuerschnittHandZaehlungImpl extends AbstractSystemObjekt
	implements de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnittHandZaehlung { 

	/**
	 * Der Defaultkonstruktor wird für das Erzeugen des Systemobjekts über per
	 * Reflection-API benötigt.
	 */
	public MessQuerschnittHandZaehlungImpl() {
		// tut nix
	}
	
	/**
	 * Initialisierung.
	 * 
	 * @param objekt
	 *            ein beliebiges Systemobjekt.
	 * @param factory
	 *            die Fabrik, die das Systemobjekt angelegt hat.
	 */
	public MessQuerschnittHandZaehlungImpl(final SystemObject objekt, final ObjektFactory factory) {
		super(objekt, factory);
		
		if (!objekt.isOfType(getTyp().getPid())) {
			throw new IllegalArgumentException(
					"Systemobjekt ist kein MessQuerschnittHandZählung.");
		}
	}
	
	@Override
	protected String doGetTypPid() {
		return PID;
	}
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	

	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdFundamentalDiagramm getPdFundamentalDiagramm() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdFundamentalDiagramm.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsLageVerfahren3 getPdVerkehrsLageVerfahren3() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsLageVerfahren3.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsLageVerfahren2 getPdVerkehrsLageVerfahren2() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsLageVerfahren2.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrsDatenKurzZeitMq getOdVerkehrsDatenKurzZeitMq() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrsDatenKurzZeitMq.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.parameter.PdGanglinie getPdGanglinie() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.parameter.PdGanglinie.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrsDatenKurzZeitGeglaettetMq getOdVerkehrsDatenKurzZeitGeglaettetMq() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrsDatenKurzZeitGeglaettetMq.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdStoerfallVerkehrsZustand getOdStoerfallVerkehrsZustand() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdStoerfallVerkehrsZustand.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrsDatenDtvMq getOdVerkehrsDatenDtvMq() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrsDatenDtvMq.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten.KdMessQuerschnittAllgemein getKdMessQuerschnittAllgemein() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten.KdMessQuerschnittAllgemein.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsStaerkeStundeFuzzy getPdVerkehrsStaerkeStundeFuzzy() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsStaerkeStundeFuzzy.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdFuzzyRegelbasis getPdFuzzyRegelbasis() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdFuzzyRegelbasis.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrGeschwindigkeitFuzzy getPdVerkehrGeschwindigkeitFuzzy() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrGeschwindigkeitFuzzy.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrsDatenKurzZeitTrendExtraPolationMq getOdVerkehrsDatenKurzZeitTrendExtraPolationMq() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrsDatenKurzZeitTrendExtraPolationMq.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsZustandFuzzy getPdVerkehrsZustandFuzzy() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsZustandFuzzy.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrsDatenLangZeitIntervallGeschwindigkeitVerteilungDtvMq getOdVerkehrsDatenLangZeitIntervallGeschwindigkeitVerteilungDtvMq() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrsDatenLangZeitIntervallGeschwindigkeitVerteilungDtvMq.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrsUnruhe getOdVerkehrsUnruhe() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrsUnruhe.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdBemessungsDichteFuzzy getPdBemessungsDichteFuzzy() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdBemessungsDichteFuzzy.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdAnteilLkwFuzzy getPdAnteilLkwFuzzy() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdAnteilLkwFuzzy.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsDatenKurzZeitAnalyseMq getPdVerkehrsDatenKurzZeitAnalyseMq() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsDatenKurzZeitAnalyseMq.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrGeschwindigkeit getOdVerkehrGeschwindigkeit() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrGeschwindigkeit.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrsZustandUnruhe getOdVerkehrsZustandUnruhe() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrsZustandUnruhe.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdBemessungsDichte getOdBemessungsDichte() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdBemessungsDichte.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrsZustand getOdVerkehrsZustand() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrsZustand.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.parameter.PdGanglinienModellPrognose getPdGanglinienModellPrognose() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.parameter.PdGanglinienModellPrognose.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrsStaerkeStunde getOdVerkehrsStaerkeStunde() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrsStaerkeStunde.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsLageVerfahren1 getPdVerkehrsLageVerfahren1() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsLageVerfahren1.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdAnteilLkw getOdAnteilLkw() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdAnteilLkw.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsZustandUnruheFuzzy getPdVerkehrsZustandUnruheFuzzy() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsZustandUnruheFuzzy.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdStoerfallZustand getOdStoerfallZustand() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdStoerfallZustand.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsUnruheFuzzy getPdVerkehrsUnruheFuzzy() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsUnruheFuzzy.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdPunktLiegtAufLinienObjekt getKdPunktLiegtAufLinienObjekt() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdPunktLiegtAufLinienObjekt.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdLokaleStoerfallErkennungFundamentalDiagramm getPdLokaleStoerfallErkennungFundamentalDiagramm() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdLokaleStoerfallErkennungFundamentalDiagramm.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsDatenKurzZeitTrendExtraPolationPrognoseTraegeMq getPdVerkehrsDatenKurzZeitTrendExtraPolationPrognoseTraegeMq() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsDatenKurzZeitTrendExtraPolationPrognoseTraegeMq.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsDatenKurzZeitTrendExtraPolationPrognoseFlinkMq getPdVerkehrsDatenKurzZeitTrendExtraPolationPrognoseFlinkMq() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsDatenKurzZeitTrendExtraPolationPrognoseFlinkMq.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsDatenKurzZeitTrendExtraPolationPrognoseNormalMq getPdVerkehrsDatenKurzZeitTrendExtraPolationPrognoseNormalMq() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsDatenKurzZeitTrendExtraPolationPrognoseNormalMq.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrsDatenLangZeitMSV getOdVerkehrsDatenLangZeitMSV() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrsDatenLangZeitMSV.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdPunktKoordinaten getKdPunktKoordinaten() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdPunktKoordinaten.class);
	}
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	
	// Sonderfall Klasse AttributImpl
	 

}
