/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.impl;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Fahrtrichtungsbezogenes Teilstück einer GesamtStraße (typ.gesamtStraße, z. B. A4)
					mit welches ohne Unterbrechung durchfahren werden kann (z. B. "A1 von Dortmund nach Münster").
<p>
&lt;absatz&gt;
						Richtlinie für die Vergabe der Pid:
						strasse.typ.nummer.zusatz.LocCode.r' mit
					&lt;&#47;absatz&gt;
					&lt;liste zeichen="punkt"&gt;
						&lt;listenPunkt&gt;
							'strasse': fester Prefix.
						&lt;&#47;listenPunkt&gt;
						&lt;listenPunkt&gt;
							'typ': Typ der Straße (erster Buchstabe der
							Spalte ROADNUMBER der LCL).
						&lt;&#47;listenPunkt&gt;
						&lt;listenPunkt&gt;
							'nummer': Nummer der Straße
							(Ziffernkombination des Eintrags in der
							Spalte ROADNUMBER der LCL im Anschluss an
							den Typ).
						&lt;&#47;listenPunkt&gt;
						&lt;listenPunkt&gt;
							'zusatz': Optional, falls vorhanden.
							Zusatzbezeichnung für die Straße (eventuell
							vorhandene zusätzliche Zeichen des Eintrags
							in der Spalte ROADNUMBER der LCL im
							Anschluss an die Straßennummer).
						&lt;&#47;listenPunkt&gt;
						&lt;listenPunkt&gt;
							'LocCode': Referenz auf das Linienelement
							gemäß LCL, welches die Straße repräsentiert
							(PID der Linienreferenz hat die Form
							tmclc.xxxxx, mit xxxxx gleich Location Code
							des Linienelements, 5-stellig mit führenden
							Nullen).
						&lt;&#47;listenPunkt&gt;
						&lt;listenPunkt&gt;
							'r': LCL-Richtung der Straße: 'p', wenn Fahrtrichtung und LCL-Richtung übereinstimmen, und
							'n', wenn Fahrtrichtung und LCL-Richtung entgegengesetzt sind.
						&lt;&#47;listenPunkt&gt;
					&lt;&#47;liste&gt;
					&lt;absatz&gt;
						Existiert für eine Location keine
						Linienlocation, so wird als PID der Wert
						strasse.S.0.tmclcl.00000.(p|n) verwendet.
					&lt;&#47;absatz&gt;
					&lt;absatz&gt;
						Beispiele für gültige PID einerStraße:
					&lt;&#47;absatz&gt;
					&lt;absatz&gt;strasse.L.150.a.tmclc.39886.p&lt;&#47;absatz&gt;
					&lt;absatz&gt;strasse.A.562.tmclc.07145.n&lt;&#47;absatz&gt;
					&lt;absatz&gt;
						Richtlinie für die Vergabe des Namens:
					&lt;&#47;absatz&gt;

					&lt;liste zeichen="punkt"&gt;
						&lt;listenPunkt&gt;
							Bei der Bildung der Namen für Objekte vom typ.straße wird ein für den Anwender lesbarer
							Name mit Angabe der Richtung (Fernziele aus der LCL) nach folgendem Muster verwendet:
							"ROADNUMBER von FIRST_NAME nach SECOND_NAME (ROAD_NAME)".

							Dabei sind für ROADNUMBER, FIRST_NAME, SECOND_NAME und ROAD_NAME die entsprechenden Werte
							der zugeordneten Linien-Location einzusetzen.
						&lt;&#47;listenPunkt&gt;
						&lt;liste zeichen="punkt"&gt;
							&lt;listenPunkt&gt;
								Wenn FIRST_NAME oder SECOND_NAME leer ist, dann wird auch das führende von bzw. nach
								weggelassen.
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								Wenn ROAD_NAME leer ist, dann werden auch die umschließenden Klammern und das führende
								Leerzeichen weggelassen.
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								Wenn ROADNUMBER nicht vorhanden, wird diese durch die Bezeichnung des erweiterten
								Straßentyps (Typkennung der atg.straßenTypErweitert)
							&lt;&#47;listenPunkt&gt;
						&lt;&#47;liste&gt;
					&lt;&#47;liste&gt;
					&lt;absatz&gt;
						Beispiele für gültige Namen einer Straße:
					&lt;&#47;absatz&gt;
					&lt;absatz&gt;
						A61 von Mönchengladbach nach Koblenz
					&lt;&#47;absatz&gt;
					&lt;absatz&gt;
						B27 von Autobahn 7 nach Göttingen (Nordumgehung Göttingen)
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class StrasseUngueltig extends BaseUngueltigesSystemObjekt implements de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Strasse { 

	private long id;

	/**
	 * Der Defaultkonstruktor wird für das Erzeugen des Systemobjekts über per
	 * Reflection-API benötigt.
	 */
	public StrasseUngueltig() {
		// tut nix
	}
	
	/**
	 * Initialisierung.
	 * 
	 * @param id
	 *            die ID des Systemobjekt.
	 */
	public StrasseUngueltig(final long id) {
		super(id);
	}
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	

	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze() {
		throw new UnsupportedOperationException("Das Systemobjekt ist ungültig.");
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo() {
		throw new UnsupportedOperationException("Das Systemobjekt ist ungültig.");
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung() {
		throw new UnsupportedOperationException("Das Systemobjekt ist ungültig.");
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten.KdStrasseErweitert getKdStrasseErweitert() {
		throw new UnsupportedOperationException("Das Systemobjekt ist ungültig.");
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten.KdStrasseFernZiele getKdStrasseFernZiele() {
		throw new UnsupportedOperationException("Das Systemobjekt ist ungültig.");
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten.KdStrasse getKdStrasse() {
		throw new UnsupportedOperationException("Das Systemobjekt ist ungültig.");
	}
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */

	// Sonderfall Klasse AttributImpl
	 

}
