/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.impl;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Begrenzungspunkte (Autobahnkreuz, Anschlussstelle
					etc.), die andere verkehrliche Objekte begrenzen.
<p>
&lt;absatz&gt;
						Richtlinie für die Vergabe der Pid und des
						Namens: 'strassenKnoten.loc1... .locN' mit
					&lt;&#47;absatz&gt;
					&lt;liste zeichen="punkt"&gt;
						&lt;listenPunkt&gt;
							'strassenKnoten': fester Präfix.
						&lt;&#47;listenPunkt&gt;
						&lt;listenPunkt&gt;
							'loc1': LocationCode, fünfstellig mit
							führenden Nullen, für diesen Knoten. Bei
							einfachen Anschlussstellen ist dies i.d.R.
							nur ein LocationCode, bei Autobahnkreuzen
							sind dies i.d.R. mindestens zwei. Bei
							mehreren Locationcodes sind diese in
							aufsteigender Reihenfolge zu sortieren.
						&lt;&#47;listenPunkt&gt;
						&lt;listenPunkt&gt;...&lt;&#47;listenPunkt&gt;
						&lt;listenPunkt&gt;'locN'&lt;&#47;listenPunkt&gt;
					&lt;&#47;liste&gt;
					&lt;absatz&gt;
						Beispiele für gültige PID eines StraßenKnotens:
					&lt;&#47;absatz&gt;
					&lt;absatz&gt;strassenKnoten.11743.23935.24471&lt;&#47;absatz&gt;
					&lt;absatz&gt;strassenKnoten.11313.22217&lt;&#47;absatz&gt;
					&lt;absatz&gt;strassenKnoten.40201&lt;&#47;absatz&gt;
					&lt;absatz&gt;
						Richtlinie für die Vergabe des Namens:"
					&lt;&#47;absatz&gt;
					&lt;liste zeichen="punkt"&gt;
						&lt;listenPunkt&gt;
							Bei der Bildung des Namen für Objekte vom typ.straßenKnoten wird die Knotenbezeichnung
							aus der LCL verwendet in der Form "Typ Name1 (Name 2) [NK Netzknoten]" mit:
						&lt;&#47;listenPunkt&gt;
						&lt;liste zeichen="punkt"&gt;
							&lt;listenPunkt&gt;
								Typ: Textuelle Umsetzung der Informationen aus den Spalten TYPE und SUBTYPE der LCL,
								siehe auch Attribut att.tmcOrtsTyp in Teilmodell TMC.
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								Name: Eintrag der Spalte FIRST_NAME der LCL.
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								Name2: Optional, wenn nicht leer. Eintrag der Spalte SECOND_NAME der LCL.
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								Netzknoten: Netzknotennummer. Eintrag der Spalte NETZKNOTEN_NR der LCL.
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								Da die Straßenknoten-Objekte häufig aus mehreren TMC-Location gebildet werden, die
								über die Spalte INTERSECTIONCODE der LCL miteinander verknüpft sind und die Spalten
								FIRST_NAME bzw. SECOND_NAME der verknüpften Locations nicht immer übereinstimmen, wird
								die Location ausgewählt, die auf der wichtigsten der kreuzenden Straßen liegt. Dazu
								werden je Punkt-Location die zugeordneten LCL-Straßenobjekte mit Hilfe der Spalte
								LINEAR_REFERENCE ermittelt und deren Werte der Spalten TYPE und SUBTYPE verglichen.
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								Da einige Locations keinen eigenen Netzknoten zugeordnet haben, wird in diesen Fällen
								der Teil [NK Netzknoten] ersetzt werden durch [NK NETZKNOTEN_NR-NETZKNOTEN2_NR Offset
								STATION m], wobei NETKNOTEN2_NR und STATION durch die entsprechenden Werte der LCL
								ersetzt werden.
							&lt;&#47;listenPunkt&gt;
						&lt;&#47;liste&gt;
					&lt;&#47;liste&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class StrassenKnotenUngueltig extends BaseUngueltigesSystemObjekt implements de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenKnoten { 

	private long id;

	/**
	 * Der Defaultkonstruktor wird für das Erzeugen des Systemobjekts über per
	 * Reflection-API benötigt.
	 */
	public StrassenKnotenUngueltig() {
		// tut nix
	}
	
	/**
	 * Initialisierung.
	 * 
	 * @param id
	 *            die ID des Systemobjekt.
	 */
	public StrassenKnotenUngueltig(final long id) {
		super(id);
	}
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	
	public Collection<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.InneresStrassenSegment> getInnereStrassenSegmente() {
		throw new UnsupportedOperationException("Das Systemobjekt ist ungültig.");
	}

	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdStoerfallVerkehrsZustand getOdStoerfallVerkehrsZustand() {
		throw new UnsupportedOperationException("Das Systemobjekt ist ungültig."); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten.KdStrassenKnoten getKdStrassenKnoten() {
		throw new UnsupportedOperationException("Das Systemobjekt ist ungültig.");
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze() {
		throw new UnsupportedOperationException("Das Systemobjekt ist ungültig.");
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten.KdStrassenKnotenLclInfo getKdStrassenKnotenLclInfo() {
		throw new UnsupportedOperationException("Das Systemobjekt ist ungültig.");
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo() {
		throw new UnsupportedOperationException("Das Systemobjekt ist ungültig.");
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten.KdStrassenKnotenTypErweitert getKdStrassenKnotenTypErweitert() {
		throw new UnsupportedOperationException("Das Systemobjekt ist ungültig.");
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung() {
		throw new UnsupportedOperationException("Das Systemobjekt ist ungültig.");
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdStoerfallZustand getOdStoerfallZustand() {
		throw new UnsupportedOperationException("Das Systemobjekt ist ungültig."); 
	}
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */

	// Sonderfall Klasse AttributImpl
	 

}
