/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.impl;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Unterteilung eines Straßensegments bei Änderung der
					verkehrlichen Eigenschaften.
<p>
&lt;absatz&gt;
						Richtlinie für die Vergabe der Pid und des
						Namens: 'sts.nr.bundesland' mit
					&lt;&#47;absatz&gt;
					&lt;liste zeichen="punkt"&gt;
						&lt;listenPunkt&gt;
							'sts': Abkürzung für StraßenTeilSegment.
						&lt;&#47;listenPunkt&gt;
						&lt;listenPunkt&gt;
							'nr': Laufende Nummer des
							StraßenTeilSegments eines StraßenSegments
							(Äußeres- oder InneresStraßenSegment),
							siebenstellig mit führenden Nullen.
						&lt;&#47;listenPunkt&gt;
						&lt;listenPunkt&gt;
							'bundesland': Kürzel des Bundeslandes (zwei
							Zeichen): BB Brandenburg, BE Berlin, BW
							Baden-Württemberg, BY Bayern, HB Bremen, HE
							Hessen, HH Hamburg, MV
							Mecklenburg-Vorpommern, NI Niedersachsen, NW
							Nordrhein-Westfalen, RP Rheinland-Pfalz, SH
							Schleswig-Holstein, SL Saarland, SN Sachsen,
							ST Sachsen-Anhalt, TH Thüringen.
						&lt;&#47;listenPunkt&gt;
					&lt;&#47;liste&gt;
					&lt;absatz&gt;
						Beispiele für gültige PID&#47;Namen eines
						StraßenTeilSegments:
					&lt;&#47;absatz&gt;
					&lt;absatz&gt;sts.0000001.BW&lt;&#47;absatz&gt;
					&lt;absatz&gt;sts.1234567.NW&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class StrassenTeilSegmentUngueltig extends BaseUngueltigesSystemObjekt implements de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenTeilSegment { 

	private long id;

	/**
	 * Der Defaultkonstruktor wird für das Erzeugen des Systemobjekts über per
	 * Reflection-API benötigt.
	 */
	public StrassenTeilSegmentUngueltig() {
		// tut nix
	}
	
	/**
	 * Initialisierung.
	 * 
	 * @param id
	 *            die ID des Systemobjekt.
	 */
	public StrassenTeilSegmentUngueltig(final long id) {
		super(id);
	}
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	

	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdNbaFundamentaldiagrammAuswahl getPdNbaFundamentaldiagrammAuswahl() {
		throw new UnsupportedOperationException("Das Systemobjekt ist ungültig.");
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdFundamentalDiagramm getPdFundamentalDiagramm() {
		throw new UnsupportedOperationException("Das Systemobjekt ist ungültig.");
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo() {
		throw new UnsupportedOperationException("Das Systemobjekt ist ungültig.");
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdStoerfallVerkehrsZustand getOdStoerfallVerkehrsZustand() {
		throw new UnsupportedOperationException("Das Systemobjekt ist ungültig."); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten.KdAsbStationierung getKdAsbStationierung() {
		throw new UnsupportedOperationException("Das Systemobjekt ist ungültig.");
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdNbaDatenStauPrognose getOdNbaDatenStauPrognose() {
		throw new UnsupportedOperationException("Das Systemobjekt ist ungültig."); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten.KdBetriebsKilometer getKdBetriebsKilometer() {
		throw new UnsupportedOperationException("Das Systemobjekt ist ungültig.");
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsStaerkeStundeFuzzy getPdVerkehrsStaerkeStundeFuzzy() {
		throw new UnsupportedOperationException("Das Systemobjekt ist ungültig.");
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdNbaDatenKapazitaetsermittlung getOdNbaDatenKapazitaetsermittlung() {
		throw new UnsupportedOperationException("Das Systemobjekt ist ungültig."); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdFuzzyRegelbasis getPdFuzzyRegelbasis() {
		throw new UnsupportedOperationException("Das Systemobjekt ist ungültig.");
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrGeschwindigkeitFuzzy getPdVerkehrGeschwindigkeitFuzzy() {
		throw new UnsupportedOperationException("Das Systemobjekt ist ungültig.");
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsZustandFuzzy getPdVerkehrsZustandFuzzy() {
		throw new UnsupportedOperationException("Das Systemobjekt ist ungültig.");
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrsUnruhe getOdVerkehrsUnruhe() {
		throw new UnsupportedOperationException("Das Systemobjekt ist ungültig."); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdBemessungsDichteFuzzy getPdBemessungsDichteFuzzy() {
		throw new UnsupportedOperationException("Das Systemobjekt ist ungültig.");
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdNbaDatenVerkehrszustand getOdNbaDatenVerkehrszustand() {
		throw new UnsupportedOperationException("Das Systemobjekt ist ungültig."); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdAnteilLkwFuzzy getPdAnteilLkwFuzzy() {
		throw new UnsupportedOperationException("Das Systemobjekt ist ungültig.");
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrGeschwindigkeit getOdVerkehrGeschwindigkeit() {
		throw new UnsupportedOperationException("Das Systemobjekt ist ungültig."); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdFcdStrassenTeilSegmentDaten getOdFcdStrassenTeilSegmentDaten() {
		throw new UnsupportedOperationException("Das Systemobjekt ist ungültig."); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrsZustandUnruhe getOdVerkehrsZustandUnruhe() {
		throw new UnsupportedOperationException("Das Systemobjekt ist ungültig."); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze() {
		throw new UnsupportedOperationException("Das Systemobjekt ist ungültig.");
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdBemessungsDichte getOdBemessungsDichte() {
		throw new UnsupportedOperationException("Das Systemobjekt ist ungültig."); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrsZustand getOdVerkehrsZustand() {
		throw new UnsupportedOperationException("Das Systemobjekt ist ungültig."); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrsStaerkeStunde getOdVerkehrsStaerkeStunde() {
		throw new UnsupportedOperationException("Das Systemobjekt ist ungültig."); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten.KdLaengsNeigungListe getKdLaengsNeigungListe() {
		throw new UnsupportedOperationException("Das Systemobjekt ist ungültig.");
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung() {
		throw new UnsupportedOperationException("Das Systemobjekt ist ungültig.");
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten.KdStrassenTeilSegment getKdStrassenTeilSegment() {
		throw new UnsupportedOperationException("Das Systemobjekt ist ungültig.");
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdAnteilLkw getOdAnteilLkw() {
		throw new UnsupportedOperationException("Das Systemobjekt ist ungültig."); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsZustandUnruheFuzzy getPdVerkehrsZustandUnruheFuzzy() {
		throw new UnsupportedOperationException("Das Systemobjekt ist ungültig.");
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdStoerfallZustand getOdStoerfallZustand() {
		throw new UnsupportedOperationException("Das Systemobjekt ist ungültig."); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten.KdStatischeBeschilderungVerkehrListe getKdStatischeBeschilderungVerkehrListe() {
		throw new UnsupportedOperationException("Das Systemobjekt ist ungültig.");
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdNbaPrognoseGanglinie getPdNbaPrognoseGanglinie() {
		throw new UnsupportedOperationException("Das Systemobjekt ist ungültig.");
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten.KdBetriebsKilometerListe getKdBetriebsKilometerListe() {
		throw new UnsupportedOperationException("Das Systemobjekt ist ungültig.");
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsUnruheFuzzy getPdVerkehrsUnruheFuzzy() {
		throw new UnsupportedOperationException("Das Systemobjekt ist ungültig.");
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten.KdStrassenTeilSegmentVerkehr getKdStrassenTeilSegmentVerkehr() {
		throw new UnsupportedOperationException("Das Systemobjekt ist ungültig.");
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdNbaGanglinienAuswahl getPdNbaGanglinienAuswahl() {
		throw new UnsupportedOperationException("Das Systemobjekt ist ungültig.");
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdLinienKoordinaten getKdLinienKoordinaten() {
		throw new UnsupportedOperationException("Das Systemobjekt ist ungültig.");
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdLinie getKdLinie() {
		throw new UnsupportedOperationException("Das Systemobjekt ist ungültig.");
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdConstraint getPdConstraint() {
		throw new UnsupportedOperationException("Das Systemobjekt ist ungültig.");
	}
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */

	// Sonderfall Klasse AttributImpl
	 

}
