/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Abweichungen der Verkehrsdaten für die
					Langzeitfehlererkennung von Verkehrsdaten.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 20
 */
public class OdAbweichungVerkehrsStaerke extends AbstractOnlineDatensatz<OdAbweichungVerkehrsStaerke.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.MessQuerschnittDerMessStellenGruppeLangZeit,
					Aspekte.MessQuerschnittDerMessStellenGruppeKurzZeit,
					Aspekte.MessQuerschnittZumVorgaengerLangZeit,
					Aspekte.MessQuerschnittZumVorgaengerKurzZeit,
				};
			}
	
			/**
			 * Langzeitfehlererkennung von Verkehrsdaten: Daten
						beziehen sich auf den Messquerschnitt der Messstelle
						im Vergleich zu den Werten der Messstellengruppe
						beim Langzeitvergleichsintervall.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt MessQuerschnittDerMessStellenGruppeLangZeit = new Aspekte("MessQuerschnittDerMessStellenGruppeLangZeit", "asp.messQuerschnittDerMessStellenGruppeLangZeit");
			
			/**
			 * Langzeitfehlererkennung von Verkehrsdaten: Daten
						beziehen sich auf den Messquerschnitt der Messstelle
						im Vergleich zu den Werten der Messstellengruppe
						beim Kurzzeitvergleichsintervall.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt MessQuerschnittDerMessStellenGruppeKurzZeit = new Aspekte("MessQuerschnittDerMessStellenGruppeKurzZeit", "asp.messQuerschnittDerMessStellenGruppeKurzZeit");
			
			/**
			 * Langzeitfehlererkennung von Verkehrsdaten: Daten
						beziehen sich auf den Messquerschnitt der Messstelle
						im Vergleich zu den Werten des
						Vorgänger-Messquerschnitts beim
						Langzeitvergleichsintervall.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt MessQuerschnittZumVorgaengerLangZeit = new Aspekte("MessQuerschnittZumVorgängerLangZeit", "asp.messQuerschnittZumVorgängerLangZeit");
			
			/**
			 * Langzeitfehlererkennung von Verkehrsdaten: Daten
						beziehen sich auf den Messquerschnitt der Messstelle
						im Vergleich zu den Werten des
						Vorgänger-Messquerschnitts beim
						Kurzzeitvergleichsintervall.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt MessQuerschnittZumVorgaengerKurzZeit = new Aspekte("MessQuerschnittZumVorgängerKurzZeit", "asp.messQuerschnittZumVorgängerKurzZeit");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttProzentPlusMinus
				 _qKfz
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttProzentPlusMinus
				 _qLkw
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttProzentPlusMinus
				 _qPkw
				;
		
			/**
			Ermittelter Wert der Abweichung der
									Langzeitfehlerüberwachung von Verkehrsdaten.
			<p>
			
			</p>
			
			@return der Wert von QKfz.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttProzentPlusMinus
				 getQKfz() {
				return _qKfz;
			}
		
			/**
			Ermittelter Wert der Abweichung der
									Langzeitfehlerüberwachung von Verkehrsdaten.
			<p>
			
			</p>
			
			@param _qKfz der neue Wert von QKfz.
			*/
			public void setQKfz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttProzentPlusMinus
			 _qKfz) {
				this._qKfz = _qKfz;
			}
		
			/**
			Ermittelter Wert der Abweichung der
									Langzeitfehlerüberwachung von Verkehrsdaten.
			<p>
			
			</p>
			
			@return der Wert von QLkw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttProzentPlusMinus
				 getQLkw() {
				return _qLkw;
			}
		
			/**
			Ermittelter Wert der Abweichung der
									Langzeitfehlerüberwachung von Verkehrsdaten.
			<p>
			
			</p>
			
			@param _qLkw der neue Wert von QLkw.
			*/
			public void setQLkw(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttProzentPlusMinus
			 _qLkw) {
				this._qLkw = _qLkw;
			}
		
			/**
			Ermittelter Wert der Abweichung der
									Langzeitfehlerüberwachung von Verkehrsdaten.
			<p>
			
			</p>
			
			@return der Wert von QPkw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttProzentPlusMinus
				 getQPkw() {
				return _qPkw;
			}
		
			/**
			Ermittelter Wert der Abweichung der
									Langzeitfehlerüberwachung von Verkehrsdaten.
			<p>
			
			</p>
			
			@param _qPkw der neue Wert von QPkw.
			*/
			public void setQPkw(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttProzentPlusMinus
			 _qPkw) {
				this._qPkw = _qPkw;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getQKfz() != null) {
		                if (getQKfz().isZustand()) {
		                    datum.getUnscaledValue("QKfz").setText(getQKfz().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("QKfz").set(getQKfz().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getQLkw() != null) {
		                if (getQLkw().isZustand()) {
		                    datum.getUnscaledValue("QLkw").setText(getQLkw().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("QLkw").set(getQLkw().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getQPkw() != null) {
		                if (getQPkw().isZustand()) {
		                    datum.getUnscaledValue("QPkw").setText(getQPkw().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("QPkw").set(getQPkw().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("QKfz").isState()) {
								setQKfz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttProzentPlusMinus
								.getZustand(daten.getScaledValue("QKfz").getText()));
							} else {
							setQKfz(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttProzentPlusMinus
							(daten.
								getUnscaledValue
							("QKfz").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("QLkw").isState()) {
								setQLkw(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttProzentPlusMinus
								.getZustand(daten.getScaledValue("QLkw").getText()));
							} else {
							setQLkw(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttProzentPlusMinus
							(daten.
								getUnscaledValue
							("QLkw").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("QPkw").isState()) {
								setQPkw(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttProzentPlusMinus
								.getZustand(daten.getScaledValue("QPkw").getText()));
							} else {
							setQPkw(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttProzentPlusMinus
							(daten.
								getUnscaledValue
							("QPkw").
									intValue
							()));
							}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setQKfz(getQKfz());
							klon.setQLkw(getQLkw());
							klon.setQPkw(getQPkw());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.abweichungVerkehrsStärke";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdAbweichungVerkehrsStaerke(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
