/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Liste mit prognostizierten Staus aufgrund der
					Baustelle.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 25
 */
public class OdBaustellenSimulation extends AbstractOnlineDatensatz<OdBaustellenSimulation.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.PrognoseNormal,
				};
			}
	
			/**
			 * Prognosewertberechnung mit normaler"Dämpfung", d.h.
						den Analysewerten normal" folgend.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt PrognoseNormal = new Aspekte("PrognoseNormal", "asp.prognoseNormal");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _simulationErfolgreich
				;
				private String
				 _auftraggeber
				= new String
				()
				;
				private String
				 _bemerkung
				= new String
				()
				;
				private String
				 _fehlermeldung
				= new String
				()
				;
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlBaustellenSimulation
				> _baustellenSimulation = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlBaustellenSimulation
				>(0, true);
		
			/**
			Gibt an, ob die Simulation erfolgreich
									durchgeführt werden konnte oder nicht.
			<p>
			
			</p>
			
			@return der Wert von SimulationErfolgreich.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getSimulationErfolgreich() {
				return _simulationErfolgreich;
			}
		
			/**
			Gibt an, ob die Simulation erfolgreich
									durchgeführt werden konnte oder nicht.
			<p>
			
			</p>
			
			@param _simulationErfolgreich der neue Wert von SimulationErfolgreich.
			*/
			public void setSimulationErfolgreich(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _simulationErfolgreich) {
				this._simulationErfolgreich = _simulationErfolgreich;
			}
		
			/**
			Name des Auftraggebers, um die Rückmeldung des
									manuellen Simulationsstarts zuzuordnen.
			<p>
			
			</p>
			
			@return der Wert von Auftraggeber.
			*/
				public String
				 getAuftraggeber() {
				return _auftraggeber;
			}
		
			/**
			Name des Auftraggebers, um die Rückmeldung des
									manuellen Simulationsstarts zuzuordnen.
			<p>
			
			</p>
			
			@param _auftraggeber der neue Wert von Auftraggeber.
			*/
			public void setAuftraggeber(String
			 _auftraggeber) {
				if (_auftraggeber.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._auftraggeber = _auftraggeber;
			}
		
			/**
			Bemerkungstext aus dem manuellen
									Simulationsstart.
			<p>
			
			</p>
			
			@return der Wert von Bemerkung.
			*/
				public String
				 getBemerkung() {
				return _bemerkung;
			}
		
			/**
			Bemerkungstext aus dem manuellen
									Simulationsstart.
			<p>
			
			</p>
			
			@param _bemerkung der neue Wert von Bemerkung.
			*/
			public void setBemerkung(String
			 _bemerkung) {
				if (_bemerkung.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._bemerkung = _bemerkung;
			}
		
			/**
			Fehlermeldung, wenn die Simulation nicht
									erfolgreich ausgeführt werden konnte.
			<p>
			
			</p>
			
			@return der Wert von Fehlermeldung.
			*/
				public String
				 getFehlermeldung() {
				return _fehlermeldung;
			}
		
			/**
			Fehlermeldung, wenn die Simulation nicht
									erfolgreich ausgeführt werden konnte.
			<p>
			
			</p>
			
			@param _fehlermeldung der neue Wert von Fehlermeldung.
			*/
			public void setFehlermeldung(String
			 _fehlermeldung) {
				if (_fehlermeldung.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._fehlermeldung = _fehlermeldung;
			}
		
			/**
			Liste der Ergebnisse der Baustellensimulation.
			<p>
			
			</p>
			
			@return der Wert von BaustellenSimulation.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlBaustellenSimulation
				> getBaustellenSimulation() {
				return _baustellenSimulation;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getSimulationErfolgreich() != null) {
		                if (getSimulationErfolgreich().isZustand()) {
		                    datum.getUnscaledValue("SimulationErfolgreich").setText(getSimulationErfolgreich().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("SimulationErfolgreich").set(getSimulationErfolgreich().getValue());
		                }
					}
					// ZeichenkettenAttributTyp
					if (getAuftraggeber() != null) {
						datum.getTextValue("Auftraggeber").setText(getAuftraggeber());
					}
					// ZeichenkettenAttributTyp
					if (getBemerkung() != null) {
						datum.getTextValue("Bemerkung").setText(getBemerkung());
					}
					// ZeichenkettenAttributTyp
					if (getFehlermeldung() != null) {
						datum.getTextValue("Fehlermeldung").setText(getFehlermeldung());
					}
					// AttributListenDefinition
						final Data.Array arrayBaustellenSimulation = datum.getArray("BaustellenSimulation");
						arrayBaustellenSimulation.setLength(getBaustellenSimulation().size());
						for (int i = 0; i < arrayBaustellenSimulation.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlBaustellenSimulation
							 atl = getBaustellenSimulation().get(i);
							atl.bean2Atl(arrayBaustellenSimulation.getItem(i), factory);
		
						}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("SimulationErfolgreich").isState()) {
								setSimulationErfolgreich(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("SimulationErfolgreich").getText()));
							} else {
							setSimulationErfolgreich(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("SimulationErfolgreich").
									byteValue
							()));
							}
					// ZeichenkettenAttributTyp
						setAuftraggeber(daten.getTextValue("Auftraggeber").getText());
					// ZeichenkettenAttributTyp
						setBemerkung(daten.getTextValue("Bemerkung").getText());
					// ZeichenkettenAttributTyp
						setFehlermeldung(daten.getTextValue("Fehlermeldung").getText());
					// AttributListenDefinition
						final Data.Array arrayBaustellenSimulation = daten.getArray("BaustellenSimulation");
						for (int i = 0; i < arrayBaustellenSimulation.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlBaustellenSimulation
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlBaustellenSimulation
							 ();
							atl.atl2Bean(arrayBaustellenSimulation.getItem(i), factory);
							getBaustellenSimulation().add(atl);
						}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setSimulationErfolgreich(getSimulationErfolgreich());
							klon.setAuftraggeber(getAuftraggeber());
							klon.setBemerkung(getBemerkung());
							klon.setFehlermeldung(getFehlermeldung());
						klon._baustellenSimulation = getBaustellenSimulation().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.baustellenSimulation";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdBaustellenSimulation(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
