/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Attributgruppe zur Verwaltung der aktuellen Zustandsdaten eines FCD-Staus.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 61
 */
public class OdFcdStau extends AbstractOnlineDatensatz<OdFcdStau.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.ExterneErfassung,
				};
			}
	
			/**
			 * Attributgruppe wurde durch eine externe Erfassungseinheit geschrieben (z.B. TLS).	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ExterneErfassung = new Aspekte("ExterneErfassung", "asp.externeErfassung");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private 	Zeitstempel
				 _tErkennung
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
				 _laenge
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
				 _vMittel
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZeitDauerSekunden
				 _tReiseVerlust
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFcdTendenz
				 _tendenz
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
				 _vonOffset
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
				 _bisOffset
				;
				private Feld<String
				> _pidSTS = new Feld<String
				>(0, true);
		
			/**
			Zeitpunkt des erstmaligen Erkennens des Stauobjekts.
			<p>
			
			</p>
			
			@return der Wert von TErkennung.
			*/
				public 	Zeitstempel
				 getTErkennung() {
				return _tErkennung;
			}
		
			/**
			Zeitpunkt des erstmaligen Erkennens des Stauobjekts.
			<p>
			
			</p>
			
			@param _tErkennung der neue Wert von TErkennung.
			*/
			public void setTErkennung(	Zeitstempel
			 _tErkennung) {
				this._tErkennung = _tErkennung;
			}
		
			/**
			Aktuelle Länge des Staus.
			<p>
			
			</p>
			
			@return der Wert von Laenge.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
				 getLaenge() {
				return _laenge;
			}
		
			/**
			Aktuelle Länge des Staus.
			<p>
			
			</p>
			
			@param _laenge der neue Wert von Laenge.
			*/
			public void setLaenge(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 _laenge) {
				this._laenge = _laenge;
			}
		
			/**
			Mittlere Geschwindigkeit im Stau.
			<p>
			
			</p>
			
			@return der Wert von VMittel.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
				 getVMittel() {
				return _vMittel;
			}
		
			/**
			Mittlere Geschwindigkeit im Stau.
			<p>
			
			</p>
			
			@param _vMittel der neue Wert von VMittel.
			*/
			public void setVMittel(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
			 _vMittel) {
				this._vMittel = _vMittel;
			}
		
			/**
			Reisezeitverlust im Stau.
			<p>
			
			</p>
			
			@return der Wert von TReiseVerlust.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZeitDauerSekunden
				 getTReiseVerlust() {
				return _tReiseVerlust;
			}
		
			/**
			Reisezeitverlust im Stau.
			<p>
			
			</p>
			
			@param _tReiseVerlust der neue Wert von TReiseVerlust.
			*/
			public void setTReiseVerlust(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZeitDauerSekunden
			 _tReiseVerlust) {
				this._tReiseVerlust = _tReiseVerlust;
			}
		
			/**
			Tendenz der Stauentwicklung. Auf Basis des Vergleichs zwischen aktueller Stauausprägung
									und der Stauausprägung in zurückliegenden Zeitintervallen ist eine Tendenz anzugeben
									(Wertebereich: {-1; 0; 1} mit '-1' für 'abnehmend', '0' für 'gleichbleibend', '1' für
									'zunehmend'). Die Ermittlung des Tendenzwertes (insbesondere bzgl. Vergleichszeitraum und
									Staukriterien) ist in einer getrennten Dokumentation beschrieben.
			<p>
			
			</p>
			
			@return der Wert von Tendenz.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFcdTendenz
				 getTendenz() {
				return _tendenz;
			}
		
			/**
			Tendenz der Stauentwicklung. Auf Basis des Vergleichs zwischen aktueller Stauausprägung
									und der Stauausprägung in zurückliegenden Zeitintervallen ist eine Tendenz anzugeben
									(Wertebereich: {-1; 0; 1} mit '-1' für 'abnehmend', '0' für 'gleichbleibend', '1' für
									'zunehmend'). Die Ermittlung des Tendenzwertes (insbesondere bzgl. Vergleichszeitraum und
									Staukriterien) ist in einer getrennten Dokumentation beschrieben.
			<p>
			
			</p>
			
			@param _tendenz der neue Wert von Tendenz.
			*/
			public void setTendenz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFcdTendenz
			 _tendenz) {
				this._tendenz = _tendenz;
			}
		
			/**
			Offset in m vom Beginn des ersten StraßenTeilSegments aus dem Array PidSTS bis zum
									Stauende.
			<p>
			
			</p>
			
			@return der Wert von VonOffset.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
				 getVonOffset() {
				return _vonOffset;
			}
		
			/**
			Offset in m vom Beginn des ersten StraßenTeilSegments aus dem Array PidSTS bis zum
									Stauende.
			<p>
			
			</p>
			
			@param _vonOffset der neue Wert von VonOffset.
			*/
			public void setVonOffset(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 _vonOffset) {
				this._vonOffset = _vonOffset;
			}
		
			/**
			Offset in m vom Beginn des letzten StraßenTeilSegments aus dem Array PidSTS bis zum
									Stauanfang (Stauwurzel).
			<p>
			
			</p>
			
			@return der Wert von BisOffset.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
				 getBisOffset() {
				return _bisOffset;
			}
		
			/**
			Offset in m vom Beginn des letzten StraßenTeilSegments aus dem Array PidSTS bis zum
									Stauanfang (Stauwurzel).
			<p>
			
			</p>
			
			@param _bisOffset der neue Wert von BisOffset.
			*/
			public void setBisOffset(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 _bisOffset) {
				this._bisOffset = _bisOffset;
			}
		
			/**
			Array, welches die vollständige Liste der PID der vom Stau betroffenen StraßenTeilSegmente
									(STS) enthält. Die Einträge der STS sind in Fahrtrichtung einzutragen, d.h. der erste Eintrag
									enthält die PID des STS welches das Stauende enthält, der letzte Eintrag enthält die PID des
									STS, welches den Stauanfang (Stauwurzel) enthält.
			<p>
			
			</p>
			
			@return der Wert von PidSTS.
			*/
				public Feld<String
				> getPidSTS() {
				return _pidSTS;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ZeitstempelAttributTyp
						datum.getTimeValue("tErkennung").setMillis(getTErkennung().getTime());
					// GanzzahlAttributTyp
					if (getLaenge() != null) {
		                if (getLaenge().isZustand()) {
		                    datum.getUnscaledValue("Länge").setText(getLaenge().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Länge").set(getLaenge().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getVMittel() != null) {
		                if (getVMittel().isZustand()) {
		                    datum.getUnscaledValue("vMittel").setText(getVMittel().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("vMittel").set(getVMittel().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getTReiseVerlust() != null) {
		                if (getTReiseVerlust().isZustand()) {
		                    datum.getUnscaledValue("tReiseVerlust").setText(getTReiseVerlust().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("tReiseVerlust").set(getTReiseVerlust().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getTendenz() != null) {
		                if (getTendenz().isZustand()) {
		                    datum.getUnscaledValue("Tendenz").setText(getTendenz().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Tendenz").set(getTendenz().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getVonOffset() != null) {
		                if (getVonOffset().isZustand()) {
		                    datum.getUnscaledValue("vonOffset").setText(getVonOffset().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("vonOffset").set(getVonOffset().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getBisOffset() != null) {
		                if (getBisOffset().isZustand()) {
		                    datum.getUnscaledValue("bisOffset").setText(getBisOffset().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("bisOffset").set(getBisOffset().getValue());
		                }
					}
					// ZeichenkettenAttributTyp
					if (getPidSTS() != null) {
						final Data.TextArray arrayPidSTS = datum.getTextArray("PidSTS");
						arrayPidSTS.setLength(getPidSTS().size());
						for (int i = 0; i < arrayPidSTS.getLength(); ++i) {
							arrayPidSTS.getTextValue(i).setText(getPidSTS().get(i));
						}
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ZeitstempelAttributTyp
						setTErkennung(new
							Zeitstempel
							(daten.getTimeValue("tErkennung").getMillis()));
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Länge").isState()) {
								setLaenge(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
								.getZustand(daten.getScaledValue("Länge").getText()));
							} else {
							setLaenge(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
							(daten.
								getUnscaledValue
							("Länge").
									longValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("vMittel").isState()) {
								setVMittel(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
								.getZustand(daten.getScaledValue("vMittel").getText()));
							} else {
							setVMittel(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
							(daten.
								getUnscaledValue
							("vMittel").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("tReiseVerlust").isState()) {
								setTReiseVerlust(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZeitDauerSekunden
								.getZustand(daten.getScaledValue("tReiseVerlust").getText()));
							} else {
							setTReiseVerlust(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZeitDauerSekunden
							(daten.
								getUnscaledValue
							("tReiseVerlust").
									longValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Tendenz").isState()) {
								setTendenz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFcdTendenz
								.getZustand(daten.getScaledValue("Tendenz").getText()));
							} else {
							setTendenz(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFcdTendenz
							(daten.
								getUnscaledValue
							("Tendenz").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("vonOffset").isState()) {
								setVonOffset(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
								.getZustand(daten.getScaledValue("vonOffset").getText()));
							} else {
							setVonOffset(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
							(daten.
								getUnscaledValue
							("vonOffset").
									longValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("bisOffset").isState()) {
								setBisOffset(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
								.getZustand(daten.getScaledValue("bisOffset").getText()));
							} else {
							setBisOffset(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
							(daten.
								getUnscaledValue
							("bisOffset").
									longValue
							()));
							}
					// ZeichenkettenAttributTyp
						final Data.TextArray arrayPidSTS = daten.getTextArray("PidSTS");
						for (int i = 0; i < arrayPidSTS.getLength(); ++i) {
							getPidSTS().add(arrayPidSTS.getText(i));
						}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setTErkennung(getTErkennung());
							klon.setLaenge(getLaenge());
							klon.setVMittel(getVMittel());
							klon.setTReiseVerlust(getTReiseVerlust());
							klon.setTendenz(getTendenz());
							klon.setVonOffset(getVonOffset());
							klon.setBisOffset(getBisOffset());
						klon._pidSTS = getPidSTS().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.fcdStau";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdFcdStau(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
