/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Kfz-Einzeldaten.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 48
 */
public class OdKfzEinzelDatenFs extends AbstractOnlineDatensatz<OdKfzEinzelDatenFs.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.ExterneErfassung,
				};
			}
	
			/**
			 * Attributgruppe wurde durch eine externe Erfassungseinheit geschrieben (z.B. TLS).	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ExterneErfassung = new Aspekte("ExterneErfassung", "asp.externeErfassung");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveStatusErfassungEFZ
				 _status
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsFahrzeugklassencode
				 _fZKlasse
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeitEFZ
				 _vKfz
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveFahrtrichtung
				 _fahrtrichtung
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsZeitdauer3
				 _belegzeit
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsZeitdauer2
				 _tNetto
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLaenge2
				 _fZLaenge
				;
		
			/**
			Status der Erfassung bei Einzelfahrzeugdaten gemäß
								TLS.
			<p>
			
			</p>
			
			@return der Wert von Status.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveStatusErfassungEFZ
				 getStatus() {
				return _status;
			}
		
			/**
			Status der Erfassung bei Einzelfahrzeugdaten gemäß
								TLS.
			<p>
			
			</p>
			
			@param _status der neue Wert von Status.
			*/
			public void setStatus(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveStatusErfassungEFZ
			 _status) {
				this._status = _status;
			}
		
			/**
			Fahrzeugklassencode, siehe TLS.
			<p>
			Welche Fahrzeugklassen detektiert werden können,
									ist vom Detektor abhängig. Bei Detektoren mit
									einfacher Unterscheidung zwischen Pkw-Ähnlichen
									und Lkw-Ähnlichen Fahrzeugen werden nur die
									Codenummern 32 und 33 verwendet. Bei Detektoren,
									die eine Klassifizierung in 5+1 Klassen
									vornehmen, werden die Codenummern 1 bis 6
									verwendet. Bei Detektoren, die eine
									Klassifizierung in 8+1 Klassen vornehmen, werden
									die Codenummern 2, 3 und 5 bis 11 verwendet.
			</p>
			
			@return der Wert von FZKlasse.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsFahrzeugklassencode
				 getFZKlasse() {
				return _fZKlasse;
			}
		
			/**
			Fahrzeugklassencode, siehe TLS.
			<p>
			Welche Fahrzeugklassen detektiert werden können,
									ist vom Detektor abhängig. Bei Detektoren mit
									einfacher Unterscheidung zwischen Pkw-Ähnlichen
									und Lkw-Ähnlichen Fahrzeugen werden nur die
									Codenummern 32 und 33 verwendet. Bei Detektoren,
									die eine Klassifizierung in 5+1 Klassen
									vornehmen, werden die Codenummern 1 bis 6
									verwendet. Bei Detektoren, die eine
									Klassifizierung in 8+1 Klassen vornehmen, werden
									die Codenummern 2, 3 und 5 bis 11 verwendet.
			</p>
			
			@param _fZKlasse der neue Wert von FZKlasse.
			*/
			public void setFZKlasse(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsFahrzeugklassencode
			 _fZKlasse) {
				this._fZKlasse = _fZKlasse;
			}
		
			/**
			Geschwindigkeit des Einzelfahrzeugs.
			<p>
			Die Geschwindigkeit und die Fahrtrichtung werden
									nur bei Detektoren mit Doppelschleifen
									ermittelt. Bei Einzelschleifen oder Ausfall
									einer Schleife wird der Wert"nicht ermittelbar"
									übertragen. Die Geschwindigkeit wird als
									vorzeichenloser Wert (0 bis mindestens 250 km&#47;h,
									maximal möglich 32767) übertragen. Die
									Geschwindigkeit wird in km&#47;h mit einer Auflösung
									von 1 km&#47;h übertragen.
			</p>
			
			@return der Wert von VKfz.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeitEFZ
				 getVKfz() {
				return _vKfz;
			}
		
			/**
			Geschwindigkeit des Einzelfahrzeugs.
			<p>
			Die Geschwindigkeit und die Fahrtrichtung werden
									nur bei Detektoren mit Doppelschleifen
									ermittelt. Bei Einzelschleifen oder Ausfall
									einer Schleife wird der Wert"nicht ermittelbar"
									übertragen. Die Geschwindigkeit wird als
									vorzeichenloser Wert (0 bis mindestens 250 km&#47;h,
									maximal möglich 32767) übertragen. Die
									Geschwindigkeit wird in km&#47;h mit einer Auflösung
									von 1 km&#47;h übertragen.
			</p>
			
			@param _vKfz der neue Wert von VKfz.
			*/
			public void setVKfz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeitEFZ
			 _vKfz) {
				this._vKfz = _vKfz;
			}
		
			/**
			Fahrtrichtung des gemessenen Fahrzeugs.
			<p>
			Fahrzeug fährt in Fahrtrichtung oder Fahrzeug
									fährt in Gegenrichtung (Falschfahrer, Schleifen
									vertauscht).
			</p>
			
			@return der Wert von Fahrtrichtung.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveFahrtrichtung
				 getFahrtrichtung() {
				return _fahrtrichtung;
			}
		
			/**
			Fahrtrichtung des gemessenen Fahrzeugs.
			<p>
			Fahrzeug fährt in Fahrtrichtung oder Fahrzeug
									fährt in Gegenrichtung (Falschfahrer, Schleifen
									vertauscht).
			</p>
			
			@param _fahrtrichtung der neue Wert von Fahrtrichtung.
			*/
			public void setFahrtrichtung(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveFahrtrichtung
			 _fahrtrichtung) {
				this._fahrtrichtung = _fahrtrichtung;
			}
		
			/**
			Belegzeit der Schleife.
			<p>
			Die Belegtzeit ist der Quotient aus ermittelter
									Fahrzeuglänge und Fahrzeuggeschwindigkeit. Sie
									ist unabhängig von der Schleifengeometrie und
									entspricht der Zeit, die ein Fahrzeug zur
									Überquerung einer gedachten Linie auf der
									Fahrbahn senkrecht zur Fahrtrichtung benötigt.
									Bei Einzelschleifen oder Ausfall einer Schleife
									wird als Belegtzeit die Meldezeit der Schleife
									verwendet. Die Belegtzeit wird im Bereich von 0
									bis 65534 Millisekunden mit der Auflösung von 1
									Millisekunde als vorzeichenloser Wert
									(0000h-FFFEh) übertragen. Bei Werten größer als
									65534 Millisekunden wird der Wert 65534
									übertragen. Lässt sich die Belegtzeit vom
									Detektor nicht ermitteln, wird der Wert 65535
									(=FFFFh) übertragen.
			</p>
			
			@return der Wert von Belegzeit.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsZeitdauer3
				 getBelegzeit() {
				return _belegzeit;
			}
		
			/**
			Belegzeit der Schleife.
			<p>
			Die Belegtzeit ist der Quotient aus ermittelter
									Fahrzeuglänge und Fahrzeuggeschwindigkeit. Sie
									ist unabhängig von der Schleifengeometrie und
									entspricht der Zeit, die ein Fahrzeug zur
									Überquerung einer gedachten Linie auf der
									Fahrbahn senkrecht zur Fahrtrichtung benötigt.
									Bei Einzelschleifen oder Ausfall einer Schleife
									wird als Belegtzeit die Meldezeit der Schleife
									verwendet. Die Belegtzeit wird im Bereich von 0
									bis 65534 Millisekunden mit der Auflösung von 1
									Millisekunde als vorzeichenloser Wert
									(0000h-FFFEh) übertragen. Bei Werten größer als
									65534 Millisekunden wird der Wert 65534
									übertragen. Lässt sich die Belegtzeit vom
									Detektor nicht ermitteln, wird der Wert 65535
									(=FFFFh) übertragen.
			</p>
			
			@param _belegzeit der neue Wert von Belegzeit.
			*/
			public void setBelegzeit(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsZeitdauer3
			 _belegzeit) {
				this._belegzeit = _belegzeit;
			}
		
			/**
			Nettozeitlücke.
			<p>
			Die Nettozeitlücke wird mit einer Auflösung von
									10 Millisekunden übertragen. Es lassen sich
									Werte im Bereich von 0 bis 655,34 Sekunden
									übertragen. Bei Werten größer 655,34 wird der
									Wert 655,34 Sekunden übertragen. Nach einem
									Neustart des Detektors ist für das erste
									Fahrzeug keine Nettozeitlücke ermittelbar. Es
									wird der Wert 65535 (=FFFFh) übertragen.
			</p>
			
			@return der Wert von TNetto.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsZeitdauer2
				 getTNetto() {
				return _tNetto;
			}
		
			/**
			Nettozeitlücke.
			<p>
			Die Nettozeitlücke wird mit einer Auflösung von
									10 Millisekunden übertragen. Es lassen sich
									Werte im Bereich von 0 bis 655,34 Sekunden
									übertragen. Bei Werten größer 655,34 wird der
									Wert 655,34 Sekunden übertragen. Nach einem
									Neustart des Detektors ist für das erste
									Fahrzeug keine Nettozeitlücke ermittelbar. Es
									wird der Wert 65535 (=FFFFh) übertragen.
			</p>
			
			@param _tNetto der neue Wert von TNetto.
			*/
			public void setTNetto(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsZeitdauer2
			 _tNetto) {
				this._tNetto = _tNetto;
			}
		
			/**
			Fahrzeuglänge.
			<p>
			Die ermittelte Fahrzeuglänge wird mit der
									Auflösung von 1 Dezimeter im Bereich von 0 bis
									254 dm als vorzeichenloser Wert übertragen. Das
									Verkehrserfassungsgerät muss justierbar und auf
									die jeweilige Schleifenabmessung einstellbar
									sein.
			</p>
			
			@return der Wert von FZLaenge.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLaenge2
				 getFZLaenge() {
				return _fZLaenge;
			}
		
			/**
			Fahrzeuglänge.
			<p>
			Die ermittelte Fahrzeuglänge wird mit der
									Auflösung von 1 Dezimeter im Bereich von 0 bis
									254 dm als vorzeichenloser Wert übertragen. Das
									Verkehrserfassungsgerät muss justierbar und auf
									die jeweilige Schleifenabmessung einstellbar
									sein.
			</p>
			
			@param _fZLaenge der neue Wert von FZLaenge.
			*/
			public void setFZLaenge(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLaenge2
			 _fZLaenge) {
				this._fZLaenge = _fZLaenge;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getStatus() != null) {
		                if (getStatus().isZustand()) {
		                    datum.getUnscaledValue("Status").setText(getStatus().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Status").set(getStatus().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getFZKlasse() != null) {
		                if (getFZKlasse().isZustand()) {
		                    datum.getUnscaledValue("FZKlasse").setText(getFZKlasse().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("FZKlasse").set(getFZKlasse().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getVKfz() != null) {
		                if (getVKfz().isZustand()) {
		                    datum.getUnscaledValue("vKfz").setText(getVKfz().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("vKfz").set(getVKfz().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getFahrtrichtung() != null) {
		                if (getFahrtrichtung().isZustand()) {
		                    datum.getUnscaledValue("Fahrtrichtung").setText(getFahrtrichtung().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Fahrtrichtung").set(getFahrtrichtung().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getBelegzeit() != null) {
		                if (getBelegzeit().isZustand()) {
		                    datum.getUnscaledValue("Belegzeit").setText(getBelegzeit().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Belegzeit").set(getBelegzeit().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getTNetto() != null) {
		                if (getTNetto().isZustand()) {
		                    datum.getUnscaledValue("tNetto").setText(getTNetto().toString());
		                } else {
							datum.
							getScaledValue
		                	("tNetto").set(getTNetto().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getFZLaenge() != null) {
		                if (getFZLaenge().isZustand()) {
		                    datum.getUnscaledValue("FZLänge").setText(getFZLaenge().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("FZLänge").set(getFZLaenge().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Status").isState()) {
								setStatus(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveStatusErfassungEFZ
								.getZustand(daten.getScaledValue("Status").getText()));
							} else {
							setStatus(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveStatusErfassungEFZ
							(daten.
								getUnscaledValue
							("Status").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("FZKlasse").isState()) {
								setFZKlasse(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsFahrzeugklassencode
								.getZustand(daten.getScaledValue("FZKlasse").getText()));
							} else {
							setFZKlasse(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsFahrzeugklassencode
							(daten.
								getUnscaledValue
							("FZKlasse").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("vKfz").isState()) {
								setVKfz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeitEFZ
								.getZustand(daten.getScaledValue("vKfz").getText()));
							} else {
							setVKfz(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeitEFZ
							(daten.
								getUnscaledValue
							("vKfz").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Fahrtrichtung").isState()) {
								setFahrtrichtung(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveFahrtrichtung
								.getZustand(daten.getScaledValue("Fahrtrichtung").getText()));
							} else {
							setFahrtrichtung(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveFahrtrichtung
							(daten.
								getUnscaledValue
							("Fahrtrichtung").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Belegzeit").isState()) {
								setBelegzeit(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsZeitdauer3
								.getZustand(daten.getScaledValue("Belegzeit").getText()));
							} else {
							setBelegzeit(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsZeitdauer3
							(daten.
								getUnscaledValue
							("Belegzeit").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("tNetto").isState()) {
								setTNetto(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsZeitdauer2
								.getZustand(daten.getScaledValue("tNetto").getText()));
							} else {
							setTNetto(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsZeitdauer2
							(daten.
								getScaledValue
							("tNetto").
								doubleValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("FZLänge").isState()) {
								setFZLaenge(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLaenge2
								.getZustand(daten.getScaledValue("FZLänge").getText()));
							} else {
							setFZLaenge(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLaenge2
							(daten.
								getUnscaledValue
							("FZLänge").
									shortValue
							()));
							}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setStatus(getStatus());
							klon.setFZKlasse(getFZKlasse());
							klon.setVKfz(getVKfz());
							klon.setFahrtrichtung(getFahrtrichtung());
							klon.setBelegzeit(getBelegzeit());
							klon.setTNetto(getTNetto());
							klon.setFZLaenge(getFZLaenge());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.kfzEinzelDatenFs";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdKfzEinzelDatenFs(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
