/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Aktuelle Stauverlaufsprognosedaten eines
					Stauobjekts.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 18
 */
public class OdStauVerlauf extends AbstractOnlineDatensatz<OdStauVerlauf.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.PrognoseNormal,
				};
			}
	
			/**
			 * Prognosewertberechnung mit normaler"Dämpfung", d.h.
						den Analysewerten normal" folgend.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt PrognoseNormal = new Aspekte("PrognoseNormal", "asp.prognoseNormal");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private 	RelativerZeitstempel
				 _schrittweite
				;
				private 	RelativerZeitstempel
				 _dauer
				;
				private 	Zeitstempel
				 _aufloesungsZeit
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
				 _maxLaenge
				;
				private 	Zeitstempel
				 _maxLaengeZeit
				;
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlStauVerlaufPrognoseSchritt
				> _prognoseverlauf = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlStauVerlaufPrognoseSchritt
				>(0, true);
		
			/**
			Zeitliche Schrittweite der Prognoseergebnisse.
			<p>
			
			</p>
			
			@return der Wert von Schrittweite.
			*/
				public 	RelativerZeitstempel
				 getSchrittweite() {
				return _schrittweite;
			}
		
			/**
			Zeitliche Schrittweite der Prognoseergebnisse.
			<p>
			
			</p>
			
			@param _schrittweite der neue Wert von Schrittweite.
			*/
			public void setSchrittweite(	RelativerZeitstempel
			 _schrittweite) {
				this._schrittweite = _schrittweite;
			}
		
			/**
			Dauer des Staus gemessen vom aktuellen
									Zeitpunkt.
			<p>
			
			</p>
			
			@return der Wert von Dauer.
			*/
				public 	RelativerZeitstempel
				 getDauer() {
				return _dauer;
			}
		
			/**
			Dauer des Staus gemessen vom aktuellen
									Zeitpunkt.
			<p>
			
			</p>
			
			@param _dauer der neue Wert von Dauer.
			*/
			public void setDauer(	RelativerZeitstempel
			 _dauer) {
				this._dauer = _dauer;
			}
		
			/**
			Zeitpunkt der Stauauflösung.
			<p>
			
			</p>
			
			@return der Wert von AufloesungsZeit.
			*/
				public 	Zeitstempel
				 getAufloesungsZeit() {
				return _aufloesungsZeit;
			}
		
			/**
			Zeitpunkt der Stauauflösung.
			<p>
			
			</p>
			
			@param _aufloesungsZeit der neue Wert von AufloesungsZeit.
			*/
			public void setAufloesungsZeit(	Zeitstempel
			 _aufloesungsZeit) {
				this._aufloesungsZeit = _aufloesungsZeit;
			}
		
			/**
			Maximale Staulänge.
			<p>
			
			</p>
			
			@return der Wert von MaxLaenge.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
				 getMaxLaenge() {
				return _maxLaenge;
			}
		
			/**
			Maximale Staulänge.
			<p>
			
			</p>
			
			@param _maxLaenge der neue Wert von MaxLaenge.
			*/
			public void setMaxLaenge(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 _maxLaenge) {
				this._maxLaenge = _maxLaenge;
			}
		
			/**
			Zeitpunkt der maximalen Staulänge.
			<p>
			
			</p>
			
			@return der Wert von MaxLaengeZeit.
			*/
				public 	Zeitstempel
				 getMaxLaengeZeit() {
				return _maxLaengeZeit;
			}
		
			/**
			Zeitpunkt der maximalen Staulänge.
			<p>
			
			</p>
			
			@param _maxLaengeZeit der neue Wert von MaxLaengeZeit.
			*/
			public void setMaxLaengeZeit(	Zeitstempel
			 _maxLaengeZeit) {
				this._maxLaengeZeit = _maxLaengeZeit;
			}
		
			/**
			Daten der einzelnen Prognoseschritte.
			<p>
			
			</p>
			
			@return der Wert von Prognoseverlauf.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlStauVerlaufPrognoseSchritt
				> getPrognoseverlauf() {
				return _prognoseverlauf;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ZeitstempelAttributTyp
						datum.getTimeValue("Schrittweite").setMillis(getSchrittweite().getTime());
					// ZeitstempelAttributTyp
						datum.getTimeValue("Dauer").setMillis(getDauer().getTime());
					// ZeitstempelAttributTyp
						datum.getTimeValue("AuflösungsZeit").setMillis(getAufloesungsZeit().getTime());
					// GanzzahlAttributTyp
					if (getMaxLaenge() != null) {
		                if (getMaxLaenge().isZustand()) {
		                    datum.getUnscaledValue("MaxLänge").setText(getMaxLaenge().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("MaxLänge").set(getMaxLaenge().getValue());
		                }
					}
					// ZeitstempelAttributTyp
						datum.getTimeValue("MaxLängeZeit").setMillis(getMaxLaengeZeit().getTime());
					// AttributListenDefinition
						final Data.Array arrayPrognoseverlauf = datum.getArray("Prognoseverlauf");
						arrayPrognoseverlauf.setLength(getPrognoseverlauf().size());
						for (int i = 0; i < arrayPrognoseverlauf.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlStauVerlaufPrognoseSchritt
							 atl = getPrognoseverlauf().get(i);
							atl.bean2Atl(arrayPrognoseverlauf.getItem(i), factory);
		
						}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ZeitstempelAttributTyp
						setSchrittweite(new
							RelativerZeitstempel
							(daten.getTimeValue("Schrittweite").getMillis()));
					// ZeitstempelAttributTyp
						setDauer(new
							RelativerZeitstempel
							(daten.getTimeValue("Dauer").getMillis()));
					// ZeitstempelAttributTyp
						setAufloesungsZeit(new
							Zeitstempel
							(daten.getTimeValue("AuflösungsZeit").getMillis()));
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("MaxLänge").isState()) {
								setMaxLaenge(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
								.getZustand(daten.getScaledValue("MaxLänge").getText()));
							} else {
							setMaxLaenge(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
							(daten.
								getUnscaledValue
							("MaxLänge").
									longValue
							()));
							}
					// ZeitstempelAttributTyp
						setMaxLaengeZeit(new
							Zeitstempel
							(daten.getTimeValue("MaxLängeZeit").getMillis()));
					// AttributListenDefinition
						final Data.Array arrayPrognoseverlauf = daten.getArray("Prognoseverlauf");
						for (int i = 0; i < arrayPrognoseverlauf.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlStauVerlaufPrognoseSchritt
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlStauVerlaufPrognoseSchritt
							 ();
							atl.atl2Bean(arrayPrognoseverlauf.getItem(i), factory);
							getPrognoseverlauf().add(atl);
						}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setSchrittweite(getSchrittweite());
							klon.setDauer(getDauer());
							klon.setAufloesungsZeit(getAufloesungsZeit());
							klon.setMaxLaenge(getMaxLaenge());
							klon.setMaxLaengeZeit(getMaxLaengeZeit());
						klon._prognoseverlauf = getPrognoseverlauf().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.stauVerlauf";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdStauVerlauf(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
