/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Zustand eines Störfallindikators.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 4
 */
public class OdStoerfallZustand extends AbstractOnlineDatensatz<OdStoerfallZustand.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.StoerfallVerfahrenNRWHB,
					Aspekte.StoerfallVerfahrenMOBINET,
					Aspekte.StoerfallVerfahrenRDSHB,
					Aspekte.StoerfallVerfahrenOLSIM1Delta,
					Aspekte.StoerfallVerfahrenOLSIM2Delta,
					Aspekte.StoerfallVerfahrenStandard,
					Aspekte.StoerfallVerfahrenMARZ,
					Aspekte.StoerfallVerfahrenNRW,
					Aspekte.StoerfallVerfahrenRDS,
					Aspekte.StoerfallVerfahrenVKDiffKfz,
					Aspekte.StoerfallVerfahrenOLSIM3Delta,
					Aspekte.StoerfallVerfahrenFD,
					Aspekte.StoerfallVerfahrenOLSIM4Delta,
					Aspekte.StoerfallVerfahrenConstraint,
					Aspekte.StoerfallVerfahrenOLSIM1,
					Aspekte.StoerfallVerfahrenFuzzy,
					Aspekte.StoerfallVerfahrenOLSIM2,
					Aspekte.StoerfallVerfahrenOLSIM3,
					Aspekte.StoerfallVerfahrenOLSIM4,
					Aspekte.StoerfallVerfahrenVWD,
				};
			}
	
			/**
			 * StörfallIndikator wurde mit dem Verfahren nach NRW Variante HB
						ermittelt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt StoerfallVerfahrenNRWHB = new Aspekte("StörfallVerfahrenNRWHB", "asp.störfallVerfahrenNRWHB");
			
			/**
			 * StörfallIndikator wurde mit einem MOBINET-Verfahren
						ermittelt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt StoerfallVerfahrenMOBINET = new Aspekte("StörfallVerfahrenMOBINET", "asp.störfallVerfahrenMOBINET");
			
			/**
			 * StörfallIndikator wurde mit dem Verfahren für RDS Variante HB
						ermittelt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt StoerfallVerfahrenRDSHB = new Aspekte("StörfallVerfahrenRDSHB", "asp.störfallVerfahrenRDSHB");
			
			/**
			 * StörfallIndikator wurde mit dem
						Störfall-Analyse-Verfahrens OLSIM ermittelt.
						Datenübertragung nur bei Vorliegen von Datenveränderungen.
						(Prognosehorizont in Attributgruppe, Standard: aktuelle Werte).	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt StoerfallVerfahrenOLSIM1Delta = new Aspekte("StörfallVerfahrenOLSIM1Delta", "asp.störfallVerfahrenOLSIM1Delta");
			
			/**
			 * StörfallIndikator wurde mit dem
						Störfall-Analyse-Verfahrens OLSIM ermittelt.
						Datenübertragung nur bei Vorliegen von Datenveränderungen.
						(Prognosehorizont in Attributgruppe, Standard: Prognose 30 Minuten).	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt StoerfallVerfahrenOLSIM2Delta = new Aspekte("StörfallVerfahrenOLSIM2Delta", "asp.störfallVerfahrenOLSIM2Delta");
			
			/**
			 * StörfallIndikator wurde mit dem Standard-Verfahren
						ermittelt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt StoerfallVerfahrenStandard = new Aspekte("StörfallVerfahrenStandard", "asp.störfallVerfahrenStandard");
			
			/**
			 * StörfallIndikator wurde mit dem Verfahren nach MARZ
						ermittelt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt StoerfallVerfahrenMARZ = new Aspekte("StörfallVerfahrenMARZ", "asp.störfallVerfahrenMARZ");
			
			/**
			 * StörfallIndikator wurde mit dem Verfahren nach NRW
						ermittelt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt StoerfallVerfahrenNRW = new Aspekte("StörfallVerfahrenNRW", "asp.störfallVerfahrenNRW");
			
			/**
			 * StörfallIndikator wurde mit dem Verfahren für RDS
						ermittelt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt StoerfallVerfahrenRDS = new Aspekte("StörfallVerfahrenRDS", "asp.störfallVerfahrenRDS");
			
			/**
			 * StörfallIndikator wurde mit dem Verfahren VKdiffKfz
						für StraßenAbschnitte ermittelt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt StoerfallVerfahrenVKDiffKfz = new Aspekte("StörfallVerfahrenVKDiffKfz", "asp.störfallVerfahrenVKDiffKfz");
			
			/**
			 * StörfallIndikator wurde mit dem
						Störfall-Analyse-Verfahrens OLSIM ermittelt.
						Datenübertragung nur bei Vorliegen von Datenveränderungen.
						(Prognosehorizont in Attributgruppe, Standard: Prognose 60 Minuten).	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt StoerfallVerfahrenOLSIM3Delta = new Aspekte("StörfallVerfahrenOLSIM3Delta", "asp.störfallVerfahrenOLSIM3Delta");
			
			/**
			 * StörfallIndikator wurde mit dem Verfahren
						LokaleStörfallerkennung mit Fundamentaldiagramm
						ermittelt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt StoerfallVerfahrenFD = new Aspekte("StörfallVerfahrenFD", "asp.störfallVerfahrenFD");
			
			/**
			 * StörfallIndikator wurde mit dem
						Störfall-Analyse-Verfahrens OLSIM ermittelt.
						Datenübertragung nur bei Vorliegen von Datenveränderungen.
						(Prognosehorizont in Attributgruppe, Standard: Prognose 7 Tage).	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt StoerfallVerfahrenOLSIM4Delta = new Aspekte("StörfallVerfahrenOLSIM4Delta", "asp.störfallVerfahrenOLSIM4Delta");
			
			/**
			 * StörfallIndikator wurde mit dem Constraint-Verfahren
						ermittelt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt StoerfallVerfahrenConstraint = new Aspekte("StörfallVerfahrenConstraint", "asp.störfallVerfahrenConstraint");
			
			/**
			 * StörfallIndikator wurde mit dem
						Störfall-Analyse-Verfahrens OLSIM ermittelt
						(Prognosehorizont in Attributgruppe, Standard: aktuelle Werte).	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt StoerfallVerfahrenOLSIM1 = new Aspekte("StörfallVerfahrenOLSIM1", "asp.störfallVerfahrenOLSIM1");
			
			/**
			 * StörfallIndikator wurde mit einem Fuzzy-Verfahren
						ermittelt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt StoerfallVerfahrenFuzzy = new Aspekte("StörfallVerfahrenFuzzy", "asp.störfallVerfahrenFuzzy");
			
			/**
			 * StörfallIndikator wurde mit dem
						Störfall-Analyse-Verfahrens OLSIM ermittelt
						(Prognosehorizont in Attributgruppe, Standard: Prognose 30 Minuten).	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt StoerfallVerfahrenOLSIM2 = new Aspekte("StörfallVerfahrenOLSIM2", "asp.störfallVerfahrenOLSIM2");
			
			/**
			 * StörfallIndikator wurde mit dem
						Störfall-Analyse-Verfahrens OLSIM ermittelt
						(Prognosehorizont in Attributgruppe, Standard: Prognose 60 Minuten).	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt StoerfallVerfahrenOLSIM3 = new Aspekte("StörfallVerfahrenOLSIM3", "asp.störfallVerfahrenOLSIM3");
			
			/**
			 * StörfallIndikator wurde mit dem
						Störfall-Analyse-Verfahrens OLSIM ermittelt
						(Prognosehorizont in Attributgruppe, Standard: Prognose 7 Tage).	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt StoerfallVerfahrenOLSIM4 = new Aspekte("StörfallVerfahrenOLSIM4", "asp.störfallVerfahrenOLSIM4");
			
			/**
			 * Aktueller Verkehrszustand (Berechnung nach MARZ) für den Verkehrswarndiest VWD in
						Rheinland-Pfalz.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt StoerfallVerfahrenVWD = new Aspekte("StörfallVerfahrenVWD", "asp.störfallVerfahrenVWD");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private 	RelativerZeitstempel
				 _t
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttStoerfallSituation
				 _situation
				;
				private 	RelativerZeitstempel
				 _horizont
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AtlGuete
				 _guete
				= new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AtlGuete
				()
				;
		
			/**
			Intervalldauer, mit dem die Werte erfasst
									wurden.
			<p>
			
			</p>
			
			@return der Wert von T.
			*/
				public 	RelativerZeitstempel
				 getT() {
				return _t;
			}
		
			/**
			Intervalldauer, mit dem die Werte erfasst
									wurden.
			<p>
			
			</p>
			
			@param _t der neue Wert von T.
			*/
			public void setT(	RelativerZeitstempel
			 _t) {
				this._t = _t;
			}
		
			/**
			Verkehrssituation (Level Of Service).
			<p>
			
			</p>
			
			@return der Wert von Situation.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttStoerfallSituation
				 getSituation() {
				return _situation;
			}
		
			/**
			Verkehrssituation (Level Of Service).
			<p>
			
			</p>
			
			@param _situation der neue Wert von Situation.
			*/
			public void setSituation(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttStoerfallSituation
			 _situation) {
				this._situation = _situation;
			}
		
			/**
			Prognosehorizont (0 entspricht Analysewert).
			<p>
			
			</p>
			
			@return der Wert von Horizont.
			*/
				public 	RelativerZeitstempel
				 getHorizont() {
				return _horizont;
			}
		
			/**
			Prognosehorizont (0 entspricht Analysewert).
			<p>
			
			</p>
			
			@param _horizont der neue Wert von Horizont.
			*/
			public void setHorizont(	RelativerZeitstempel
			 _horizont) {
				this._horizont = _horizont;
			}
		
			/**
			Güteindex für den Störfallindikatior.
			<p>
			
			</p>
			
			@return der Wert von Guete.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AtlGuete
				 getGuete() {
				return _guete;
			}
		
			/**
			Güteindex für den Störfallindikatior.
			<p>
			
			</p>
			
			@param _guete der neue Wert von Guete.
			*/
			public void setGuete(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AtlGuete
			 _guete) {
				this._guete = _guete;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ZeitstempelAttributTyp
						datum.getTimeValue("T").setMillis(getT().getTime());
					// GanzzahlAttributTyp
					if (getSituation() != null) {
		                if (getSituation().isZustand()) {
		                    datum.getUnscaledValue("Situation").setText(getSituation().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Situation").set(getSituation().getValue());
		                }
					}
					// ZeitstempelAttributTyp
						datum.getTimeValue("Horizont").setMillis(getHorizont().getTime());
					// AttributListenDefinition
						getGuete().bean2Atl(datum.getItem("Güte"), factory);
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ZeitstempelAttributTyp
						setT(new
							RelativerZeitstempel
							(daten.getTimeValue("T").getMillis()));
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Situation").isState()) {
								setSituation(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttStoerfallSituation
								.getZustand(daten.getScaledValue("Situation").getText()));
							} else {
							setSituation(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttStoerfallSituation
							(daten.
								getUnscaledValue
							("Situation").
									byteValue
							()));
							}
					// ZeitstempelAttributTyp
						setHorizont(new
							RelativerZeitstempel
							(daten.getTimeValue("Horizont").getMillis()));
					// AttributListenDefinition
						getGuete().atl2Bean(daten.getItem("Güte"), factory);
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setT(getT());
							klon.setSituation(getSituation());
							klon.setHorizont(getHorizont());
							klon._guete = getGuete().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.störfallZustand";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdStoerfallZustand(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
